#include <qkeycode.h>
#include <qscrbar.h>
#include "ScrolledWindow.h"

ScrolledWindow::ScrolledWindow( QWidget* parent, const char* name )
        : QWidget( parent, name ),
          _window( 0 )
{
    _hsb = new QScrollBar( QScrollBar::Horizontal, this );
    _hsb->setTracking( TRUE );
    connect( _hsb, SIGNAL( valueChanged( int ) ), this, SLOT( hsbMoved( int ) ) );

    _vsb = new QScrollBar( QScrollBar::Vertical, this );
    _vsb->setTracking( TRUE );
    connect( _vsb, SIGNAL( valueChanged( int ) ), this, SLOT( vsbMoved( int ) ) );

    _clip = new QWidget( this );
    _clip->move( 0, 0 );
}

ScrolledWindow::~ScrolledWindow()
{
}

QWidget* ScrolledWindow::clip()
{
    return _clip;
}

void ScrolledWindow::setWindow( QWidget* window )
{
    _window = window;
    _window->show();
    resizeEvent( 0 );
}

void ScrolledWindow::hsbMoved( int value )
{
    if ( _window ) {
        _window->move( -value, _window->y() );
    }
}

void ScrolledWindow::vsbMoved( int value )
{
    if ( _window ) {
        _window->move( _window->x(), -value );
    }
}

void ScrolledWindow::resizeEvent( QResizeEvent* )
{
    _hsb->setGeometry( 0, height() - 16, width() - 16, 16 );
    _hsb->setRange( 0, _window->width() - width() + 16 );
    _hsb->setSteps( 10, width() - 16 );

    _vsb->setGeometry( width() - 16, 0, 16, height() - 16 );
    _vsb->setRange( 0, _window->height() - height() + 16 );
    _vsb->setSteps( 10, height() - 16 );

    _clip->resize( width() - 16, height() - 16 );
}

void ScrolledWindow::windowResized()
{
    resizeEvent( 0 );
}

void ScrolledWindow::scrollUp()
{
    _vsb->setValue( _vsb->value() - _vsb->lineStep() );
}

void ScrolledWindow::scrollDown()
{
    _vsb->setValue( _vsb->value() + _vsb->lineStep() );
}

void ScrolledWindow::scrollLeft()
{
    _hsb->setValue( _hsb->value() - _hsb->lineStep() );
}

void ScrolledWindow::scrollRight()
{
    _hsb->setValue( _hsb->value() + _hsb->lineStep() );
}

void ScrolledWindow::scrollPrior()
{
    _vsb->setValue( _vsb->value() - _vsb->pageStep() );
}

void ScrolledWindow::scrollNext()
{
    _vsb->setValue( _vsb->value() + _vsb->pageStep() );
}

void ScrolledWindow::keyPressEvent( QKeyEvent* e )
{
    switch ( e->key() ) {
        case Key_Up:
            scrollUp();
            return;

        case Key_Down:
            scrollDown();
            return;

        case Key_Left:
            scrollLeft();
            return;

        case Key_Right:
            scrollRight();
            return;

        case Key_Prior:
            scrollPrior();
            return;

        case Key_Next:
            scrollNext();
            return;
    }

    e->ignore();
}
