//
// Many parts of this source code were 'inspired' by the ircII4.4 translat.c source.
// RIPPED FROM KVirc: http://www.kvirc.org
// Original by Szymon Stefanek (kvirc@tin.it).
// Modified by Andrew Frolov (dron@linuxer.net)


#ifndef _LICQ_TRANSLATE_H_INCLUDED_
#define _LICQ_TRANSLATE_H_INCLUDED_

#include <qstring.h>
#include <qfile.h>
#include <qmsgbox.h>

class LicqTranslator{
public:
	LicqTranslator();
	~LicqTranslator();
protected:
	unsigned char serverToClientTab[256];
	unsigned char clientToServerTab[256];
	QString m_szMapFileName;
	bool m_bDefault;
public:
	void setDefaultTranslationMap();
	bool setTranslationMap(const char *szMapFileName);
	void translateToClient(char *szString);
	void translateToServer(char *szString);
	const char *getMapFileName(){return m_szMapFileName.data();};
};

#endif //_LICQ_TRANSLATE_H_INCLUDED_
