// Copyright (c) 1997,1998 Albrecht Kleine    All rights reserved
// Copyright (c) 1998 Artur Biesiadowski
// file version #202

#include "tyaconfig.h"
#include <stdio.h>
#include <native.h>
#include <monitor.h>
#include "tya.h"

#define IGNORE_DISABLE

#ifdef MEMDEBUG
#include "MemDebug.h"
#endif

#ifdef EXCEPTIONS_BY_SIGNALS
#include <asm/sigcontext.h>
#include <asm/segment.h>
#endif

#ifdef VERBOSE
static int totalCompByte = 0;
#endif

static int JitCompCode=1;
static int ExtendCodeSpace(struct CINFO *cinfo);


// ------------ some helpers for compilation-----------------------

int getint16U(int *j, struct CINFO* cinfo)
{
#if 0
   int x;
   x =*(cinfo->bptr+(*j)++)<<8;
   x+=*(cinfo->bptr+(*j)++);
#else
   register int x asm ("%eax");
   x=*(unsigned short int*)(cinfo->bptr+*j);
   (*j)+=2;
   asm ("xchg %al,%ah");
#endif
   return x;  
}

int getint16S(int *j, struct CINFO* cinfo)
{
#if 0   
   int x;
   x =*(signed char*) (cinfo->bptr+(*j)++) << 8;
   x+=*(cinfo->bptr+(*j)++);
#else
   register int x asm ("%eax");
   x=*(unsigned short int*)(cinfo->bptr+*j);
   (*j)+=2;
   asm ("xchg %al,%ah");
   asm ("cwde");
#endif   
   return x;
}

int getint32(int *j, struct CINFO* cinfo)
{
#if 0 		// #if 1 --> IF YOU HAVE 386 CPU: no "bswap" available
   int x;
   x =*(cinfo->bptr+(*j)++)<<24;
   x+=*(cinfo->bptr+(*j)++)<<16;
   x+=*(cinfo->bptr+(*j)++)<<8;
   x+=*(cinfo->bptr+(*j)++);
#else
   int x=*(int*)(cinfo->bptr+*j);
   (*j)+=4;
   asm ("bswap %0": : "r" (x));		// little big endian stuff
#endif   
   return x;
}

//----------------- access to classes -------------------------------------

// look for a method in array during compilation
//
int GetMethNr(struct methodblock *mbp)
{
  int u;
  int anz=unhand(mbp->fb.clazz)->methods_count;
  for (u=0;u<anz;u++)
   if (unhand(mbp->fb.clazz)->methods[u].fb.ID == mbp->fb.ID)
     return u;
   return 0;	// should never happen
}

// look for a method in methodtable or field during compilation
//
//
int GetMethodNumber(struct methodblock* mb,Classjava_lang_Class *klazz)
{
   int i;
   struct methodblock **xmethods=klazz->methodtable->methods;
   for (i=klazz->methodtable_size-1;i /* >0 */ ;i--)
// for (i=1;i<klazz->methodtable_size;i++)
   {
      if (xmethods[i] == mb)
      {
	 dprintf(stderr,"\nfound in tab %d: %s.%s\n",i,klazz->name,xmethods[i]->fb.name);
	 return i;
      }
    }
   dprintf(stderr,"\ndid not find in tab\n");
   return 0;
}
	  
int CheckException(struct execenv *ee,int code)
{
   if (exceptionOccurred(ee))
     {
      ClassClass *clazz=obj_classblock(ee->exception.exc);
      dprintf(stderr,"TYA: *** Resolver (op=%x) exc: %s\n",code,unha11(clazz)->name);
      if (ee->current_frame->current_method)
        dprintf(stderr,"     in compiling %s\n",ee->current_frame->current_method->fb.name);
      else
	dprintf(stderr,"     in compiling <unknown>\n");
      ee->exceptionKind=0;
      ee->exception.exc=NULL;
      return 1;
     }
   return 0;
}

int IgnoreBadClass(Classjava_lang_Class *klazz,Classjava_lang_Class *clazz)
{
   int i;	
   dprintf(stderr,"TYA: ignoring bad class in R-FT level1\n");
   lock_classes();
   for (i=0;i<clazz->methods_count;i++)
   {
     if (clazz->methods[i].CompiledCodeInfo)
	 clazz->methods[i].invoker=clazz->methods[i].CompiledCodeInfo;
     clazz->methods[i].CompiledCodeInfo=NULL;
     clazz->methods[i].CompiledCode=NULL;
   }
   unlock_classes();
   return klazz==clazz;
}

			 
void* GetBlock(int *nr,int isfield,unsigned char code,int *pj,Classjava_lang_Class *klass,
				 struct CINFO* cinfo,int quick)
{
   unsigned int wop;
   register int hash;
   int k,l,m,ipool,cnt,needflag=0;
   ClassClass *clazz;
#if JDK102   
   ClassClass *class=klass;
#else
   ClassClass *class=klass->HandleToSelf;
#endif
   Classjava_lang_Class *klazz;
   wop=getint16U(pj,cinfo);
   if (!quick)   
    if (!ResolveClassConstantFromClass(class,wop,cinfo->ee,(unsigned)-1))
    {
      struct fieldblock* fb;
    #if RESOLVE_FT>=1
     {
	fb = klass->constantpool[wop].fb;
        CheckException(cinfo->ee,code);
	if ((int)fb>0x4000000)
	  dprintf(stderr,"     %s.%s  (%s)\n",unha11(fb->clazz)->name,  fb->name,fb->signature);
	else
	{
	  dprintf(stderr,"     unknown fb %x\n",(int)fb);
	  return NULL;
	}
     }
   #endif
   #if RESOLVE_FT==1
     if (IgnoreBadClass(klass,unha11(fb->clazz)))
       return NULL;
    #endif
    #if RESOLVE_FT==0
      return NULL;
    #endif
    }
   ipool=klass->constantpool[wop].i;

   	switch (code)
	{
           case 0xb2:dprintf(stderr,"getstatic");
           	     needflag=ACC_STATIC;
           	     break;
           case 0xb3:dprintf(stderr,"putstatic");
           	     needflag=ACC_STATIC;
           	     break;
           case 0xB4:dprintf(stderr,"getfield");
           	     break;
           case 0xB5:dprintf(stderr,"putfield");
           	     break;
	   case 0xE2:dprintf(stderr,"INVOKE_VIRTUAL_QUICK_W");
                     break;
	   case 0xD7:dprintf(stderr,"INVOKE_NON_VIRTUAL_QUICK");
                     break;
	   case 0xD9:dprintf(stderr,"INVOKE_STATIC_QUICK");
                     break;
	   default  :dprintf(stderr,"other quick INVOKE_other or get/put");
                     break;
	   case 0xb6:dprintf(stderr,"INVOKE_VIRTUAL");
                     break;
           case 0xb7:dprintf(stderr,"INVOKE_NON_VIRTUAL");
                     break;
           case 0xb8:dprintf(stderr,"INVOKE_STATIC");
               	     needflag=ACC_STATIC;
                     break;
	   case 0xb9:dprintf(stderr,"INVOKE_INTERFACE");
                     break;
	}
   
   if (quick || ipool>0x4000000)	// FIXME!!
   {
     if (nr)
	{	
	   *nr=GetMethodNumber((struct methodblock*)ipool, unha11(((struct methodblock*)ipool)->fb.clazz));
	   #ifdef NOGUA_WORKAROUND
	   if (!*nr)
	     return NULL;
	   #endif
	}
     // dprintf(stderr," GetBlock quick ipool=%08x\n",ipool);
     dprintf(stderr,"\n");
     return (void*)ipool; // could be  struct fieldblock*  or  struct methodblock*
   }
   l=ipool&0xffff;
   k=ipool>>16;
   if (!ResolveClassConstantFromClass(class,l,cinfo->ee,(unsigned)-1)  ||
       !ResolveClassConstantFromClass(class,k,cinfo->ee,(unsigned)-1)  )
   {
	  dprintf(stderr," GMB:Resolve Error\n");
   	  return NULL;
   }
   hash =klass->constantpool[ l ].i;
   clazz =(ClassClass*)klass->constantpool[ k ].cp;
   klazz=unha11(clazz);
   
   
   cnt=isfield ? klazz->fields_count : klazz->methods_count;
   for (m =0;m<cnt;m++)
   {
    if (isfield)
    {
      if (klazz->fields[ m ].ID==hash)
	{
	  dprintf(stderr," found field  #%d of %d\n",m,cnt-1);
	  dprintf(stderr,"GFB %s.%s\n",klazz->name,klazz->fields[ m ].name);
          if ( (klazz->fields[m].access & ACC_STATIC) != needflag)
          {
     	   dprintf(stderr,"GFB:access flag error\n");
           return NULL;
          }
          return &klazz->fields[ m ];
	}
     }
     else
     {
       if (klazz->methods[ m ].fb.ID==hash)
	{
	  dprintf(stderr," found method #%d of %d\n",m,cnt-1);
	  dprintf(stderr,"GMB %s.%s\n",klazz->name,klazz->methods[ m ].fb.name);
          if ( (klazz->methods[m].fb.access & ACC_STATIC   ) != needflag)
          {
     	   dprintf(stderr,"GMB:access flag error\n");
           return NULL;
          }
	  if (nr)
	     {  
                *nr=GetMethodNumber(&klazz->methods[ m ], unha11(klazz->methods[ m ].fb.clazz));
	     }
          return &klazz->methods[ m ];
	}
     }
   }
   {
     char *msg=alloca(80);
     sprintf(msg,"GetBlock: field or method not found !!!! hashID = %x , klazz %p\n",hash,klazz);
     lprintf(msg);panic(msg);
   }
   return NULL;
}

// -----------------------------------------------------------------------

// look for some typical code snippets:
// replace .... with x NOPs etc,
//
#define GW(a) (*((unsigned short *) (a)))
void TinyPeepHoleOpt(struct CINFO* cinfo,int codesize)
{
 int i;
 unsigned short int *ptr; 
 for (i=0;i<cinfo->ipcnt;i++)
 {
    if (cinfo->iptab[i].isdest)
     continue;
   // 
   // Eliminate Stack operation for doubles
   //
   if  ((GW(cinfo->iptab[i].x86-4) == FSTPQW_MSP) && 
   	(GW(cinfo->iptab[i].x86-1) == POPPUSHAX) && 
	(GW(cinfo->iptab[i].x86+1) == FLDQW_MSP) )
	{
      	 dprintf(stderr,"++ %x   %d ++++ %x\n" , GW((cinfo->iptab[i].x86))
	 	 ,cinfo->iptab[i].x86 - cinfo->codebase,*cinfo->iptab[i].java);
	 ptr = (unsigned short *) (cinfo->iptab[i].x86-4);
	 *ptr++ = NOP2;
	 *ptr++ = NOP2;
	 *ptr++ = NOP2;
	 *ptr   = NOP2;// 8 Byte at all
	 //dprintf(stderr,"Tiny\n");
	}
 }
}			
 

// ----------------------------------INTERFACE & HOOKS ----------------------------------
//
// this function does the init
//
long java_lang_Compiler_start(int **XX)
{
   void* (*CCLinkVector)=(void*)*XX;
   lopen();				// logfile
   #ifndef DEBUG
    lprintf(" TYA %s (for J%s) loaded. Copyright (c) 1997,98 The TYA Team\n",TYAVER,JVER);
   #else
    dprintf(stderr," TYA %s-DEBUG (for J%s) loaded. Copyright (c) 1997,98 The TYA Team\n",TYAVER,JVER);
   #endif
   lprintf(" Contact  The TYA Team   via Albrecht Kleine  <kleine@ak.sax.de>\n");
   dprintf(stderr,"------------ start java_lang_Compiler_start ---------\n");
   CCLinkVector[CCLbase+2] =InitializeForCompiler_Hook;
   CCLinkVector[CCLbase+3] =CompilerFreeClass_hook;
   CCLinkVector[CCLbase+4] =InvokeCompiledMethod_Hook;
   CCLinkVector[CCLbase+5] =CompiledCodeSignalHandler_hook;
   CCLinkVector[CCLbase+6] =CompileClass_Hook;
   CCLinkVector[CCLbase+7] =CompileClasses_Hook;
   CCLinkVector[CCLbase+8] =CompilerCommand_hook;
   CCLinkVector[CCLbase+9] =Enable_hook;
   CCLinkVector[CCLbase+10]=Disable_hook;
   CCLinkVector[CCLbase+11]=PCinCompiledCode_Hook;
   CCLinkVector[CCLbase+12]=CompiledCodePC_Hook;
#ifndef NOCOMPPREL
   {
    int i;
    lock_classes();
    for (i= 0  ;i<nbinclasses;i++) 
     { 
	dprintf(stderr,"preloaded class:  %s\n",unha11(binclasses[i])->name);
	CompileClass_Hook(binclasses[i]);
     }
    unlock_classes();
   }
#endif
   PrepareExceptions();
   return 1L;
}
			 
			
#ifdef DEBUG
void ShowPreInvokeInfo(struct methodblock *mb,int args_size,struct execenv *ee,int noncom)
{
  int i;
  dprintf(stderr,"***** INVOKN %sCOMPILED",noncom?"NON":"");
  dprintf(stderr," %s.%s\t %s  (%d args)\n",unha11(mb->fb.clazz)->name,mb->fb.name,mb->fb.signature,args_size);
  if (ee->current_frame->prev && ee->current_frame->prev->current_method)
    dprintf(stderr,"        CALLED BY %s.%s\n",
	    unha11(ee->current_frame->prev->current_method->fb.clazz)->name,
	    ee->current_frame->prev->current_method->fb.name);
  else   
    dprintf(stderr,"        CALLED BY (unknown)\n");
  dprintf(stderr,"        maxstack=%d  nlocals=%d  asize=%d\n", mb->maxstack,mb->nlocals,mb->args_size);
  dprintf(stderr,"Stack:\n");
  for (i=0;i<args_size;i++)
     dprintf(stderr,"  %d. =\t%d\t=%x\t=%f\n",i,ee->current_frame->optop[i].i,
	     ee->current_frame->optop[i].i,*(float*)&ee->current_frame->optop[i]);
}

void ShowPostInvokeInfo(struct methodblock *mb,struct execenv *ee,int noncom)
{
   dprintf(stderr,"***** RETURN from %sCOMPILED %s.%s\n",noncom?"NON":"",
	   unha11(mb->fb.clazz)->name,mb->fb.name);
   if (exceptionOccurred(ee))
      dprintf(stderr,"*** exceptionOccurred ******\n");
}
#endif

//---------------------------------------------------------------------------------

//  called by InvokeCompiledMethod_Hook()
//
			
void ReverseCopyViaReversedScript(stack_item *loc,char *xx,int anz,stack_item *args,int maxvaroffs)
{
   int i;
   maxvaroffs--;
   for (i=0;i<anz;i++)
	if (*xx-- != 0x64)
          loc[maxvaroffs-i]=args[i];
        else
	  {
	     loc[maxvaroffs-i]=args[i+1];
	     loc[maxvaroffs-i-1]=args[i];
	     i++;
	  }
}

// hook #4
//
bool_t InvokeCompiledMethod_Hook(JHandle *thiso, struct methodblock *mb, int args_size, struct execenv *ee)
{
#define EXTRALOCAL 3   
#define EXTRAARGS 2
   int allspace=mb->nlocals+args_size;
   char *xx;
   struct methodblock *mbcaller;
   stack_item *oldvar;
   stack_item *args=ee->current_frame->optop;
   stack_item *local=alloca(( EXTRALOCAL+EXTRAARGS+ allspace )*SIS4);
   //
   // "local" is later used by machine code...
   // ...for storing the local variables (addressed via ebp+LOCSTART+xx )
   // FYI: this is completely changed in TYA 0.4 for first
   //      ... and once again in TYA 0.7
   //
   //         DATA            EBP+OFFS   LOCSTART-OFFSET, DESCRIPTION 
   //         ============    ========   ============================
   //         Local_Data_0    x  <------ maybe "this" (as first local data)
   //         Local_Data_1    x+1
   //		.........
   //         Local_Data_x    40 <------ LOCSTART (the last java local data)
   //	      cw87, calld st size 36     =LOCSTART-4  (used for invocation, dtoi,ftoi)
   //         DI storage      32         =LOCSTART-8  (used for inlining)
   //         SI storage      28         =LOCSTART-12 (used for inlining)
   //	      ExecEnv         24 <------ =LOCSTART-16 (used everywhere)
   //	      frame pointer   20         =LOCSTART-20 (if fast inv, else 0)
   //         return Adress   16
   //	      caller EBX      12
   //         caller ESI      8
   //         caller EDI      4
   // EBP=ESP-> EBP on Stack  0
   //         (...used for private buffer and calls...)
   //
#ifdef DEBUG   
   ShowPreInvokeInfo(mb,args_size,ee,0);
#endif
   if (!mb->CompiledCodeFlags)
     MakeStackRevInstruction(mb, !(mb->fb.access & ACC_STATIC));
   switch (mb->CompiledCodeFlags)
     {
      case 257:break;
      case 1:local[ EXTRALOCAL+EXTRAARGS +allspace -1]=args[0];
	break;
      case 2:local[ EXTRALOCAL+EXTRAARGS +allspace -1]=args[0];
	     local[ EXTRALOCAL+EXTRAARGS +allspace -1 -1]=args[1];
	break;
      case 3:local[ EXTRALOCAL+EXTRAARGS +allspace -1]=args[0];
	     local[ EXTRALOCAL+EXTRAARGS +allspace -1 -1]=args[1];
	     local[ EXTRALOCAL+EXTRAARGS +allspace -1 -2]=args[2];
	break;
      case 256:local[ EXTRALOCAL+EXTRAARGS +allspace -1]=args[1];
	       local[ EXTRALOCAL+EXTRAARGS +allspace -2]=args[0];
	break;
      default:xx=(char*)mb->CompiledCodeFlags; // reverse instruction string 
	      while (*xx)		       // here we go from end back to start
	       xx++;
	      xx--;
              ReverseCopyViaReversedScript(&local[EXTRALOCAL+EXTRAARGS],xx,args_size,args,allspace);
	break;
     }
   local[1].h=(JHandle*)ee;  		// 2 additional parameter
   local[0].h=(JHandle*)0;
   
   mbcaller= ee->current_frame->current_method;
   ee->current_frame->current_method=mb;
   oldvar=ee->current_frame->vars;	// stor old value
   ee->current_frame->vars=&local[EXTRALOCAL+EXTRAARGS];

   // invoke.....
   if (mb->fb.access & ACC_XXUNUSED3)	// pseudo result type 64bit
     {
	*(long long *)(&ee->current_frame->optop[0])=((long long(*)(void)) mb->CompiledCode)();
	ee->current_frame->optop+=2;
     }
     else
     {
	if (mb->fb.access & ACC_DOCED)	// void result
	  ((void(*)(void))mb->CompiledCode)();
	else
	{
//	  *(int *) (&ee->current_frame->optop[0])=((int(*)(void))mb->CompiledCode)();
	  ee->current_frame->optop[0].i=((int(*)(void)) mb->CompiledCode)();
	  ee->current_frame->optop++;
	}
     }
   ee->current_frame->vars=oldvar;	// reset to old variable
   ee->current_frame->current_method=mbcaller;
#ifdef DEBUG
   ShowPostInvokeInfo(mb,ee,0);
#endif
   return !exceptionOccurred(ee);
}


#ifdef DEBUG
#ifdef DEBUG_INV
bool_t InvokeNonCompiledMethod_Hook(JHandle *thiso, struct methodblock *mb, int args_size, struct execenv *ee)
{
   int z;
   void *f;
   stack_item *args=ee->current_frame->optop;
   ShowPreInvokeInfo(mb,args_size,ee,1);
   if (! (mb->fb.access & ACC_STATIC))
      f=(void*)*(int*)args++;
   else
      f=mb->fb.clazz;
   mb->invoker= mb->CompiledCodeInfo;
   z= do_execute_java_method_vararg(ee,f /* = object or class */,
	mb->fb.name,mb->fb.signature,mb, mb->fb.access & ACC_STATIC ,args,NULL, TRUE);
   ShowPostInvokeInfo(mb,ee,1);
   mb->invoker= InvokeNonCompiledMethod_Hook;
   return z;        			// or !exceptionOccurred(ee);
}
#endif
#endif

//hook #3
//
void* CompilerFreeClass_hook(ClassClass *clazz)
{
  int i;
  dprintf(stderr,"------- CompilerFreeClass_hook called for %s ---------\n",unha11(clazz)->name);
  for (i=0;i<unha11(clazz)->methods_count;i++)
     {
	if (unha11(clazz)->methods[i].CompiledCode)
	  sysFree((unha11(clazz)->methods[i].CompiledCode)-ENTRYPOINT);
	unha11(clazz)->methods[i].CompiledCode=NULL;
	unha11(clazz)->methods[i].invoker=unha11(clazz)->methods[i].CompiledCodeInfo;
	unha11(clazz)->methods[i].CompiledCodeInfo=NULL;
	if (unha11(clazz)->methods[i].CompiledCodeFlags > 0x10000)
	  sysFree((char*)unha11(clazz)->methods[i].CompiledCodeFlags);
	unha11(clazz)->methods[i].CompiledCodeFlags=0;
     }
  return NULL; //? FIXME
}

// hook #5
//

#ifdef EXCEPTIONS_BY_SIGNALS
void dumpSigcontext( TYA_SIGCONTEXT * ptr )
{
	dprintf(stderr, "sigcontext:\n");
	dprintf(stderr, "edi=%8.8lX esi=%8.8lX ebp=%8.8lX esp=%8.8lX\n",
		ptr->edi, ptr->esi, ptr->ebp, ptr->esp);	
	dprintf(stderr, "ebx=%8.8lX edx=%8.8lX ecx=%8.8lX eax=%8.8lX\n", 
		ptr->ebx, ptr->edx,ptr->ecx, ptr->eax);
	dprintf(stderr, "err=%lu\n", ptr->err);	
	dprintf(stderr, "eip=%lX\n", ptr->eip);
	dprintf(stderr, "esp_at_signal %8.8lX\n", ptr->esp_at_signal);
	return;
}

unsigned long  oldeip asm("anOldip");
unsigned long  oldesp asm("anOldsp");
unsigned long  oldebp asm("anOldbp");
unsigned long  jumpTo asm("aJumpTo");
#endif EXCEPTIONS_BY_SIGNALS

#define NEWGETCONTEXT
#define OFF116v5 4	// 0 for 114v4a
// at all it is impossible to estimate the correct jdk 
// sub version,  so this is undefined since build #201
#undef NEWGETCONTEXT	


void CompiledCodeSignalHandler_hook(int sig,void *info,void *uc)
{
#ifdef EXCEPTIONS_BY_SIGNALS
   void * startOfCode;
#ifdef EASYEX
   TYA_SIGCONTEXT * context = (TYA_SIGCONTEXT *)
                                        (((char *)uc)- sizeof(TYA_SIGCONTEXT));
   struct execenv * ee = *(struct execenv**)((char*)info+20);
#else   
   struct execenv * ee = EE();
   TYA_SIGCONTEXT * context=NULL;
#ifndef NEWGETCONTEXT
   // at all FIXME: unknown uc pointer
   #define MAXSEARCH 100
   int *ptr=(int*)uc-MAXSEARCH;
   int i;
#endif   
   asm ("pushl %esp");
   asm ("popl anOldsp");
#ifndef NEWGETCONTEXT
   //lprintf("TYA: %x\n",oldesp);
   // grep for a sigcontext_struct
   if ( sig == SIGSEGV  ||  sig == SIGFPE )
   {
    for (i=0;i<MAXSEARCH;i++)
     if (ptr[i]==USER_DS && ptr[i+1]==USER_DS && 
	 ptr[i+2]==USER_DS && ptr[i+3]==USER_DS)
       break;
    if (i>=MAXSEARCH)
	{
	     char *msg="TYA:EXCEPTIONS_BY_SIGNALS problem\n";
	     lprintf(msg);panic(msg);
	}
   context=(void*)&ptr[i];
//   lprintf("TYA:CompiledCodeSignalHandler_hook--context at offset =%d  %p %p\n",100-i,context,info);
//   lprintf("TYA:context at offset = entry_esp + 0x%xh\n",(void*)context-(void*)oldesp);      
    
//   {  int z; for (z=0;z<50;z++)
  //    lprintf("context %p %d.  %x\n",&((int*)oldesp)[z],z,((int*)oldesp)[z]);}   
   }
#else
   context=(TYA_SIGCONTEXT *)(oldesp+64 + OFF116v5);
   lprintf("TYA:CompiledCodeSignalHandler_hook--context at %p \n",context);
   if (!(context->gs==USER_DS && context->fs==USER_DS && 
         context->ds==USER_DS && context->ds==USER_DS))
   {
	     char *msg="TYA:EXCEPTIONS_BY_SIGNALS problem\n";
	     lprintf(msg);panic(msg);
   }
#endif
   
#endif   
   // compute start of offending method
   startOfCode = ee->current_frame->current_method->CompiledCode - ENTRYPOINT;
   // get NullPointerHandler/DivZeroHandler adress
   if ( sig == SIGSEGV )
        jumpTo = ((unsigned long) startOfCode) +
                DIVZEROHANDSIZE+ARROUTOFFSIZE+NEGARRSIZESIZE + RESERVED1;
   else
     if ( sig == SIGFPE )
        jumpTo = ((unsigned long) startOfCode)+RESERVED1;
     else
     {
        lprintf("TYA: Signal %d, returning to default handler;\n",sig);
        return;
     }
   lprintf("TYA:Signal %d in %s\n",sig,ee->current_frame->current_method->fb.name);
#ifdef DEBUG
   dumpSigcontext(context);
   dprintf(stderr, "info = %8.8lX\n", (unsigned long) info);
   dprintf(stderr, "execenv = %p\n",ee);
   dprintf(stderr, "current_frame = %p\n",ee->current_frame);
   dprintf(stderr, "current_method =%p\n",ee->current_frame->current_method);
   dprintf(stderr, "CompiledCode = %p\n",startOfCode);
#endif
 // all this global variables could be locals, but how can I reference locals
 // in AT&T asm ?

   // registers at the moment of exception
   oldeip=context->eip;
   oldebp=context->ebp;
   oldesp=context->esp;
   // restore old ebp and esp, push old eip on stack for exception handler
   // and jump there
   asm volatile( "
   movl $anOldbp, %eax 
   movl (%eax), %ebp
   movl $anOldsp, %eax
   movl (%eax), %esp
   movl $anOldip, %eax
   movl (%eax),%eax
   pushl %eax
   movl $aJumpTo, %eax
   movl (%eax), %eax
   jmp *%eax" );
#endif // EXCEPTIONS_BY_SIGNALS
}

// hook #8
//
// could be used for some difficult debug problems...
//
JHandle *CompilerCommand_hook(JHandle *x)
{
 dprintf(stderr,"----------CompileCommand_hook-------->handle= %p\n",x);
 return x;
}


// hook #9
//
void Enable_hook(void)
{
   JitCompCode=1;
   dprintf(stderr,"----------Enable_hook---------\n");
}


// hook #10
//
void Disable_hook(void)
{
   #ifdef IGNORE_DISABLE
     lprintf("TYA: Disable_hook call ignored");
   #else
     JitCompCode=0;
   #endif
   dprintf(stderr,"----------Disable_hook--------\n");
}


// hook #11
int PCinCompiledCode_Hook(unsigned char *pc,struct methodblock *mb)
{
   dprintf(stderr,"-------- PCinCompiledCode_Hook -------- %s.%s  %p %p\n",
	   unha11(mb->fb.clazz)->name,mb->fb.name,pc,mb->code);
   return pc==mb->CompiledCode;
}

// hook #12
unsigned char *CompiledCodePC_Hook(JavaFrame *frame,struct methodblock *mb)
{
   dprintf(stderr,"-------- CompiledCodePC_Hook ---------- %s.%s\n",
	   unha11(mb->fb.clazz)->name,mb->fb.name);
   return (is_subclass_of(mb->fb.clazz, classJavaLangThrowable, 
		  frame->javastack->execenv)) ? NULL : mb->CompiledCode;
}


// hook #7
long CompileClasses_Hook(Hjava_lang_String *hclname)
{
   ClassClass *class;
   char clbuf[254];			// FIXME: max len?
   char *clp=clbuf;
   int i;
   javaString2CString(hclname,clbuf,sizeof clbuf);
   dprintf(stderr,"----------CompileClasses_Hook--------- %s\n",clbuf);
   while(*clp)
     {
	if (*clp=='.') *clp='/';
	clp++;
     }
   class=FindClass(NULL,clbuf,FALSE);
   dprintf(stderr,"          class = %p\n",class);
   if (!class)
     i=0;
   else
     i=CompileClass_Hook(class);
   if (i)
     {    
      struct CINFO cinfo;
      int i;
      for (i=0;i<unha11(class)->methods_count;i++)
      {
	if (unha11(class)->methods[i].invoker==MYInvokeCompiledMethod)
	  {
	     dprintf(stderr,"Compilation requested by java code\n");
             CompiliereMethode(&unha11(class)->methods[i], &cinfo,EE());
	  }
      }
     }
   dprintf(stderr,"----------Ende CompileClasses_Hook-----Erg=%d\n",i);
   return i;  
}

 
int  ProcessExceptionTab(struct methodblock* mbp,struct CINFO* cinfo)
{
   register int n,o;
   #ifdef DEBUG
   char* excclassname;
   #endif
   ClassClass *class=mbp->fb.clazz;
   dprintf(stderr,"Exception handler of method %s  = %ld\n",
	   mbp->fb.name,mbp->exception_table_length);
   for (n=0;n<mbp->exception_table_length;n++)
     {
	if ((o=mbp->exception_table[n].catchType))
	  {
	     if (!ResolveClassConstantFromClass(class,o,cinfo->ee,(unsigned)-1))
		return 0;
	     cinfo->exclazz[n]=( ClassClass *) unha11(class)->constantpool[o].p;
	     #ifdef DEBUG
	     excclassname= unha11(cinfo->exclazz[n])->name;
	     #endif
	  }
	else
	  {
	     cinfo->exclazz[n]=NULL;
	     #ifdef DEBUG
	     excclassname="";
	     #endif
	  }
	#ifdef DEBUG
	dprintf(stderr,"Exc tab from %ld to %ld, handler %ld  %p %s\n",
		mbp->exception_table[n].start_pc,
		mbp->exception_table[n].end_pc,
	        mbp->exception_table[n].handler_pc,
		cinfo->exclazz[n], excclassname);
	#endif
     }
   dflush(stderr);
   return 1;
}

void BackPatchJumpDists(struct CINFO* cinfo)
{
   int k,l,diff;
   for (k=0;k<cinfo->backcnt;k++)
   {   
      diff =cinfo->backp[k].javadist>0 ? 1:-1;		// jump forward or backward
      for (l=cinfo->backp[k].currcnt;;l+=diff)
	{  
	     if ((cinfo->backp[k].java+cinfo->backp[k].javadist) ==cinfo->iptab[l].java)
	     {
		int dist = cinfo->iptab[l].x86-cinfo->backp[k].x86-4;
		// dist -4 is because the x86 jump itself is counted out
		// .. ..  jj  | xx xx xx xx  | op op op op .. ..
		// jmpopcode  | patchaddress | destinationX
		//
		// for example: distance between destinationX and patchadress is 4!
		//              but we patch 0, for "jmp 0" as jump to next instruction
		*(int*)cinfo->backp[k].x86= dist;              
		cinfo->iptab[l].isdest=TRUE;
		break;
             }
	}
   }
}

int ExtendCodeSpace(struct CINFO *cinfo)
{
   int relocate,n;
   unsigned char *temp=cinfo->codebase;
   cinfo->codebase=sysRealloc(cinfo->codebase,MAXCOMPILEDSIZE);
   cinfo->maxspace=MAXCOMPILEDSIZE;	// set new space limit
   // adjust all helper data for code we have already compiled:
   if ((relocate=cinfo->codebase-temp))
     {
	for (n=0;n<cinfo->mb->exception_table_length;n++)
	  {
	     if (cinfo->start[n])
	       cinfo->start[n]+=relocate;
	     if (cinfo->end[n])
	       cinfo->end[n]+=relocate;
	     if (cinfo->handler[n])
	       cinfo->handler[n]+=relocate;
	   }
	for (n=0;n<cinfo->ipcnt;n++)
	  cinfo->iptab[n].x86+=relocate;
	for (n=0;n<cinfo->backcnt;n++)
	  cinfo->backp[n].x86+=relocate;
	cinfo->cptr+=relocate;
     }
  dprintf(stderr,"code space extended (moved +%x byte)\n",relocate);
  return relocate;
}
					  

		 
int  CompiliereMethode(struct methodblock* mb, struct CINFO *cinfo,ExecEnv *ee)
{
   Classjava_lang_Class *klass=unha11(mb->fb.clazz);
   register int j,n;
   int erg=0,zz;
   unsigned char *compex;
   int relocate=0;

   size_t  l_BlockSize;
   size_t l_ExceptionTableLength = sizeof(void *)   * mb->exception_table_length;
   size_t l_IpTransLength   = sizeof(struct iptrans)* mb->code_length;
   size_t l_BackLength    = sizeof(struct back) * mb->code_length;
   void  * l_Block;
 
   if (!JitCompCode)
       return -1;
#ifdef VERBOSE_ASM86   
   lprintf("%%%% START JITCOMP: %s.%s ( %s )%%%%\n",unha11(mb->fb.clazz)->name,mb->fb.name,mb->fb.signature);
#endif
   //printHexDump(mb->code,mb->code_length,"Byte code");
  
   l_BlockSize  = 4 * l_ExceptionTableLength + l_IpTransLength + l_BackLength;
   l_Block = sysMalloc(l_BlockSize);

   if (!l_Block)
     {
	lprintf("*************** not enough memory ***************\n");
	JitCompCode=0;
	return -1;
     }
   cinfo->start = l_Block;
   cinfo->end  = l_Block + l_ExceptionTableLength;
   cinfo->handler = l_Block + l_ExceptionTableLength * 2;
   cinfo->exclazz = l_Block + l_ExceptionTableLength * 3;
   cinfo->iptab = l_Block + l_ExceptionTableLength * 4;
   cinfo->backp = l_Block + l_ExceptionTableLength * 4 + l_IpTransLength;
 
   cinfo->ee  = ee;
   cinfo->isinline = 0;
   cinfo->ipcnt = 0;
   cinfo->backcnt = 0;
   cinfo->wide  = FALSE;
   cinfo->inlineerr = mb->exception_table_length!=0;
   // don't inline if there are catchframes on caller side

   
   if (!ProcessExceptionTab(mb ,cinfo))
     {
      sysFree(l_Block);
      lprintf("ProcessExceptionTab aborted!\n");
      return -1;
     }
   
   cinfo->codebase=cinfo->cptr=sysMalloc(DEFCOMPILEDSIZE);
   if (!cinfo->codebase)
     {
	sysFree(l_Block);
	JitCompCode=0;
	lprintf("*************** not enough memory 2 ***************\n");
	return -1;
     }
   // our JIT compilate..
   cinfo->bptr=(unsigned char*)mb->code;
   cinfo->mb=mb;
   cinfo->maxspace=DEFCOMPILEDSIZE;
   //
   cinfo->resspace= (mb->exception_table_length * 60 + 60) + 150 + 64 ;
   //  max size for exception_handler2 + one opcode + startup (cmp: tyaexc.c,tyarecode.c)

   compex=CompExceptionHandlerPart1(cinfo);
   //
   dprintf(stderr,"soc= %d\n",cinfo->cptr-cinfo->codebase);   
   while (cinfo->cptr-cinfo->codebase < ENTRYPOINT-4)
     CB(NOP);		// get aligned
   CL(0);		// RESERVED2
   //
   CB(PUSHBX);
   CB(PUSHSI);      
   CB(PUSHDI);
   CB(PUSHBP);
   CW(MOV_BPSP);
#ifndef NOCOMPSYNC
   if (cinfo->mb->CompiledCodeInfo == invokeSynchronizedJavaMethod)
   {
      if (cinfo->mb->fb.access & ACC_STATIC)
        {
	   CB(PUSHLONG);
	   CL(cinfo->mb->fb.clazz);
        }
        else
	{
           Comp_PUSH_LocalVar(0,cinfo);
	   CB(PUSHAX);
	}  
      CB(MOV_BX);
      CL(monitorEnter);
      CW(CALL_EBX);
      CB(POPAX);
   }
#endif
   // outer compilation loop
   for (j=0;j<mb->code_length ;)
     {
       for (n=0;n<mb->exception_table_length;n++)
       {
 	if (j == mb->exception_table[n].start_pc)
	  cinfo->start[n]=cinfo->cptr;
	if (j == mb->exception_table[n].end_pc)
	  cinfo->end[n]=cinfo->cptr;
	if (j == mb->exception_table[n].handler_pc)
	  cinfo->handler[n]=cinfo->cptr;
       }
       erg=recode(j,klass,cinfo);
#ifdef INLINING
       if (erg==INLINE_ERROR)
       {
         lprintf("TYA: 2nd try: not compiling INLINEs\n");
	 cinfo->inlineerr = TRUE;
	 j=0;		// try again, but do not use INLINING
	 continue;	// == a 'goto' to a second try...
       }
#endif
       if (erg==NOSPACE_ERROR && cinfo->maxspace < MAXCOMPILEDSIZE)
       {
	  erg=0;
	  relocate=ExtendCodeSpace(cinfo);
	  continue;
       }
       if (erg<=0)
       {
         lprintf("TYA: recode aborted!  %s   (at %d)\n",mb->fb.name,cinfo->cptr - cinfo->codebase);
         break;
       }
       else
        j+=erg;
     }
   if (cinfo->maxspace!=DEFCOMPILEDSIZE)
      lprintf("TYA:  %d  #### extended code space #### for %s.%s (%s)\n",cinfo->cptr - cinfo->codebase,
	      unha11(mb->fb.clazz)->name,mb->fb.name,mb->fb.signature);
   if (erg>0)
   {
      dprintf(stderr,"translated commands: %d\n",cinfo->ipcnt);
      BackPatchJumpDists(cinfo);
      if (compex)
	{
	   compex+=relocate;
	   *((int*)compex)=(int)cinfo->cptr;	// backpatch start of part2
           CompExceptionHandlerPart2(cinfo);
	}
      zz=cinfo->cptr - cinfo->codebase;	// produced byte
#ifdef VERBOSE
      totalCompByte+=zz;
#endif
      cinfo->cptr=cinfo->codebase;
      TinyPeepHoleOpt(cinfo,zz);
      mb->CompiledCode=sysRealloc(cinfo->codebase,zz);
      //printHexDump(mb->CompiledCode,zz,"i386 code");
#ifdef VERBOSE_ASM86   
      lprintf("%%%% END JITCOMP: %s.%s ( %s )%%%%\n",unha11(mb->fb.clazz)->name,mb->fb.name,mb->fb.signature);
#endif
      dprintf(stderr,"compiled %d byte realloc to %p   for %s.%s\n",
           zz,mb->CompiledCode,unha11(mb->fb.clazz)->name,mb->fb.name  );
      dflush(stderr);
      
      mb->CompiledCode+=ENTRYPOINT;
      mb->fb.access |= ACC_MACHINE_COMPILED;
      mb->invoker=invokeCompiledMethod;
   } 
   else		// error during compilation
   {
      sysFree(cinfo->codebase);
      dprintf(stderr,"    --------> method could not be compiled\n");	 
      // could be: java.lang.IncompatibleClassChangeError: ......: 
      //           "method ..... did not used to be static" 
      //           and maybe more such stuff
   }
   sysFree(l_Block);
   return erg;
}

// here we have a shell around CompiliereMethode()
//
bool_t JITCompileMethod(struct methodblock *mb, struct execenv *ee)
{
#ifdef VERBOSE
   static int 	s_Level			= 0;
   static int 	s_HyperFastCount	= 0;
   static long	l_TotalJitTime 		= 0;
   long 	l_StartTime 		= 0;
   long		l_EndTime		= 0;
#endif
   JavaFrame * l_Tmp;
   struct CINFO cinfo;
   register int i;
   JavaFrame *jf;

   // FYI: in mb->CompiledCodeInfo we store the original invoker
   if (!(mb->CompiledCodeInfo == invokeJavaMethod ||
         mb->CompiledCodeInfo == invokeSynchronizedJavaMethod))
     return FALSE;
#ifdef VERBOSE
	if (! s_Level++)
		l_StartTime = now();
	else
		iprintf("Recursif call of JITCompileMethod\n");
#endif
   dprintf(stderr,"----------start JITCompileMethod- METHOD=%s.%s\n",unha11(mb->fb.clazz)->name,mb->fb.name);

   #define OSTACK_SPACE 100	// perhaps too much, but shouldn't harm
   jf=alloca(sizeof(JavaFrame) + OSTACK_SPACE);
   l_Tmp = ee->current_frame;
   memcpy(jf,ee->current_frame,sizeof(JavaFrame) + OSTACK_SPACE);
   jf->optop=jf->ostack;
   ee->current_frame = jf;
   i = CompiliereMethode(mb,&cinfo,ee);
   ee->current_frame = l_Tmp;
#ifdef VERBOSE
	if (! --s_Level)
	{
		l_EndTime = now();
		l_TotalJitTime += l_EndTime - l_StartTime;
		if ((l_EndTime - l_StartTime) == 0)
			s_HyperFastCount ++;
		
		lprintf("JitCompiled %s.%s in %ldms (total: %ldms (+ %d / 2) / %dbyte)\n",
				unha11(mb->fb.clazz)->name,mb->fb.name,
				(l_EndTime-l_StartTime), l_TotalJitTime,s_HyperFastCount, totalCompByte);
	}	
#endif
   if (i<=0)
   {
     lprintf("TYA: !!! Can't Compile class %s !!!!!\n",unha11(mb->fb.clazz)->name);
     lock_classes();
     // if an error occured: so we exclude this method from machine code execution
#ifdef DEBUG_INV
     mb->invoker= InvokeNonCompiledMethod_Hook;
#else
     if (mb->CompiledCodeInfo)
	{
	   mb->invoker=mb->CompiledCodeInfo;
	   mb->CompiledCodeInfo=NULL;
	}
#endif      
     mb->CompiledCode=NULL;
     unlock_classes();
//     // not interested in handling any exceptions, because we have aborted
//     ee->exceptionKind=0;	
//     ee->exception.exc=NULL;
     return FALSE; 
   }
   else
     return TRUE;
}


bool_t MYInvokeCompiledMethod(JHandle *thiso, struct methodblock *mb, int args_size, struct execenv *ee)
{
   JITCompileMethod(mb,ee);
   dprintf(stderr,"----------start MYInvokeCompiledMethod- METHOD=%s.%s\n",unha11(mb->fb.clazz)->name,mb->fb.name);
   return mb->invoker(thiso, mb, args_size, ee);
}

   
//-------------------------------------------------------------------
// hook #6
// called by java-VM
// also called by InitializeForCompiler_Hook(), CompileClasses_Hook, user's program
//
long CompileClass_Hook(ClassClass *class)
{
 int i,m;
  char j;
 void* inv;
 Classjava_lang_Class *klass=unha11(class);

#ifdef DEBUG   
 char* invName="unknown";
#endif
 if (!JitCompCode)
   return 1;
 dprintf(stderr,"----------CompileClass_Hook----------------- classname: %s\n",unha11(class)->name);

  for (i=0;i<klass->methods_count;i++)
     {  
	inv=klass->methods[i].invoker;
#ifdef DEBUG	
	if (inv==invokeJavaMethod)
	  invName="invokeJavaMethod";
	else
	  if (inv==invokeSynchronizedJavaMethod)
	    invName="invokeSynchronizedJavaMethod";
	else
	  if (inv==invokeAbstractMethod)
	    invName="invokeAbstractMethod";
	else
	  if (inv==invokeLazyNativeMethod)
	    invName="invokeLazyNativeMethod";
	else
	  if (inv==invokeSynchronizedNativeMethod)
	    invName="invokeSynchronizedNativeMethod";
	else
	  if (inv==invokeCompiledMethod)
	    invName="invokeCompiledMethod";
	dprintf(stderr,"%d.\tClass.Meth: %s.%s\n",i,klass->name,klass->methods[i].fb.name);
	dprintf(stderr,"\tSig: %s   Invoker: %s ",klass->methods[i].fb.signature,invName);
#endif	
	if (inv==invokeCompiledMethod)
	{    
	     dprintf(stderr,"\t<<<<< IS ALREADY COMPILED.\n");
	     continue;	
	}
#ifndef NOCOMPSYNC
        if (invokeJavaMethod !=inv && invokeSynchronizedJavaMethod !=inv)
#else
        if (invokeJavaMethod !=inv)
#endif        
	  {
	     dprintf(stderr,"\t<<<<< NOT TO COMPILE.\n");
	     continue;
	  }
	  else
	     dprintf(stderr,"\n");
#if 0
	// for testing purpose: do NOT compile this class.method
	// if  ( !strcmp(unha11(class)->name,"java/.../...")
	//   &&  !strcmp(unha11(class)->methods[i].fb.name,".......")  )
	  {
          dprintf(stderr,"NEVER compiling: %s.%s\n",klass->name,klass->methods[i].fb.name);
#ifdef DEBUG_INV
	  klass->methods[i].CompiledCodeInfo=klass->methods[i].invoker;
          klass->methods[i].invoker= InvokeNonCompiledMethod_Hook;
          klass->methods[i].CompiledCode=NULL;
#endif
          continue;
	  }
#endif
	klass->methods[i].CompiledCodeInfo=klass->methods[i].invoker;
	// store a copy of original invoker
        klass->methods[i].invoker=MYInvokeCompiledMethod;
	
	// some shortcuts for result type: faster but not neccessary
	// using ACC_DOCED here is a temp. misuse / FIXME FIXME FIXME FIXME
	m=0;
	while (klass->methods[i].fb.signature[m]!=SIGNATURE_ENDFUNC)
  	 m++;
	m++;
	j=klass->methods[i].fb.signature[ m ];
	
	if (j=='D' || j=='J')
          klass->methods[i].fb.access |= ACC_XXUNUSED3;	    // pseudo result type 64bit
	else
	  {
	  if (j=='V')
	    klass->methods[i].fb.access |= ACC_DOCED;	    // void result
	  else
	    klass->methods[i].fb.access &= ((short)~ACC_DOCED);
	  klass->methods[i].fb.access &= ((short)~ACC_XXUNUSED3);
	  }
     }
  dprintf(stderr,"---------------END CompileClass_Hook-----------------------\n");
  return 1;		
  // 0 if error
}

			     
void InitializeForCompiler_Hook(ClassClass *class)
{
 dprintf(stderr,"----------InitializeForCompiler_Hook----------- name: %s\n",unha11(class)->name);
 dprintf(stderr,"LOADED: ClassName = %s  SuperClass = %s  Sourcefile= %s\n",
	 unha11(class)->name,unha11(class)->super_name,unha11(class)->source_name);
 if (unha11(class)->access & ACC_INTERFACE)
      dprintf(stderr,"Interface class: no compilation\n");
 else  
 {
    if (unha11(class)->access & ACC_ABSTRACT)
      dprintf(stderr,"Abstract class\n");
    else
      dprintf(stderr,"\n");
    CompileClass_Hook(class);	// prepare compilation of all methods of this class
 }
 dprintf(stderr,"----------END InitializeForCompiler_Hook--- name: %s\n",unha11(class)->name);
}

#if 0
// unused
unsigned int get87precision(void)
{
  unsigned int cword87;
  __asm__ ("fstcw %0" : "=m" (cword87) );
  return (cword87 & 0x300) >>8;
}
#endif
