/***************************************************************************
**    xIrcServerQuery.cpp  $Revision: 1.11 $ - $Name: V1-17B $ 
**    Dialog box to get server name
**
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#include <stdio.h>
#include <qmsgbox.h>
#include "xIrcServerQuery.h"
#include "xDefaults.h"

static int dbg = 0;
                    
extern xDefaults Defaults;

xServerQuery::xServerQuery(xWidgetResInfo *pPRes, QWidget *pParent,
                           const char *pName) :
               xDialog(wdtRes = new xWidgetResInfo(pPRes, QString("serverdialog"),
                                                   QString("ServerDialog")),
                       pParent, pName, TRUE)
{
   setDefPallet(this, wdtRes);
   setDefFont(this, wdtRes);

   initClass(pName);
}

void xServerQuery::initClass(const char *pName)
{
   char *cp;

   if (dbg) fprintf(stdout, "xinitClass::xinitClass():Enter\n\r");
   if (dbg) fflush(stdout); 
   if (pName)
      setCaption(pName);
      
   setAcceptFocus(TRUE);   
   pServer = new xComboBox(wdtRes, this);
   pServer->setMargins(5, 5);
   pServer->setFrameStyle(QFrame::Panel | QFrame::Raised);
   if (dbg) fprintf(stdout, "xinitClass::xinitClass():Setting Label text\n\r");
   if (dbg) fflush(stdout); 
   pServer->setLabel("Enter Server or Query");
   if ((cp = (char *)Defaults.get("SERVERS")) == NULL || strlen(cp) == 0)
      cp = "undernet.org";
   pServer->insertItems(cp);
   pServer->setCurrentItem(0);
   
   pPort = new xLineEdit(wdtRes, this);
   pPort->setFrameStyle(QFrame::Panel | QFrame::Raised);
   if ((cp = (char *)Defaults.get("TCPPORT")) == NULL || strlen(cp) == 0)
      cp = "6667";
   pPort->setText(cp);

   if (dbg) fprintf(stdout, "xinitClass::xinitClass():Setting Label text\n\r");
   if (dbg) fflush(stdout); 
   pPort->setLabel("Enter Port Number");
   
   pButtons = new xPshBtnFrame(wdtRes, this);
   pButtons->setFrameStyle(QFrame::Panel | QFrame::Raised);
   pButtons->setAlignment(xALIGN_Horz);
   pButtons->addButton("OK",     xServerQuery::Accepted);
   pButtons->addButton("Disconnect",  xServerQuery::Disconnect);
   pButtons->addButton("Clear",  xServerQuery::Clear);
   pButtons->addButton("Cancel", xServerQuery::Rejected);

   addWidget(pServer);
   addWidget(pPort);
   addWidget(pButtons);
   setMargins(0,0);
   setWidgetSpacing(0);
   initFrame();
   
   connect(pServer, SIGNAL(gotEntry(const char *)),
           this, SLOT(gotReturnFromServer(const char *)));
   connect(pPort, SIGNAL(returnPressed()),
           this, SLOT(gotReturn()));
   connect(pButtons, SIGNAL(clicked(int)), this, SLOT(gotButton(int)));
   if (dbg) fprintf(stdout, "xinitClass::xinitClass():Exit\n\r");
   if (dbg) fflush(stdout); 
}

void xServerQuery::gotButton(int btn)
{
   QString tmpStr;
   int idx;

   if (dbg) fprintf(stdout, "xServerQuery::gotButton(%d):Enter\n\r", btn);
   switch((QryResults)btn)
   {
      case Disconnect:
         if (dbg) fprintf(stdout, "xServerQuery::gotButton():Disconnecting??\n\r");
         done(btn);
         break;

      case Clear:
         if (dbg) fprintf(stdout, "xServerQuery::gotButton():Clearing??\n\r");
         pServer->setText("");                                               
         break;                                                              

      case Accepted:                                                         
         if (dbg) fprintf(stdout, "xServerQuery::gotButton():Accepting??\n\r");
         if (strlen(pServer->text()) == 0)
         {
            if ((idx = pServer->currentItem()) == -1)
            {
               QMessageBox::message("Error:", "No Server Specified");
               return;
            }
            pServer->setText(pServer->string(idx));
         }
         accept();                                                           
         break;                                                              

      case Rejected:                                                         
         if (dbg) fprintf(stdout, "xServerQuery::gotButton():Rejecting??\n\r");
         reject();
         break;
   }
   if (dbg) fprintf(stdout, "xServerQuery::gotButton():Exit\n\r");
}

void xServerQuery::accept()
{
   QDialog::accept();
}

void xServerQuery::reject()
{
   QDialog::reject();
}

void xServerQuery::gotReturn()
{
   int idx;

   if (dbg) fprintf(stdout, "xServerQuery::gotReturn():Enter\n\r");
   if (strlen(pServer->text()) == 0)
   {
      if ((idx = pServer->currentItem()) == -1)
      {
         QMessageBox::message("Error:", "No Server Specified");
         return;
      }
      pServer->setText(pServer->string(idx));
   }
   QDialog::accept();
   if (dbg) fprintf(stdout, "xServerQuery::gotReturn():Exit\n\r");
}

void xServerQuery::gotReturnFromServer(const char *)
{
   int idx;

   if (dbg) fprintf(stdout, "xServerQuery::gotReturnFromServer():Enter\n\r");
   if (strlen(pServer->text()) == 0)
   {
      if ((idx = pServer->currentItem()) == -1)
      {
         QMessageBox::message("Error:", "No Server Specified");
         return;
      }
      pServer->setText(pServer->string(idx));
   }
   QDialog::accept();
   if (dbg) fprintf(stdout, "xServerQuery::gotReturnFromServer():Exit\n\r");
}

/*
void xServerQuery::gotTabFromServer()
{
   if (dbg) fprintf(stdout, "xServerQuery::gotReturn():Enter\n\r");
   pPort->setFocus();
   if (dbg) fprintf(stdout, "xServerQuery::Exit():Enter\n\r");
}

void xServerQuery::gotTabFromPort()
{
   if (dbg) fprintf(stdout, "xServerQuery::gotReturn():Enter\n\r");
   pServer->setFocus();
   if (dbg) fprintf(stdout, "xServerQuery::Exit():Enter\n\r");
}
*/

xServerQuery::~xServerQuery()
{
   if (pServer)
   {
      if (dbg) fprintf(stdout, "xServerQuery::~xServerQuery():Deleting pServer\n");
      if (dbg) fflush(stdout);
      delete pServer;
   }
   if (pPort)
   {
      if (dbg) fprintf(stdout, "xServerQuery::~xServerQuery():Deleting pPort\n");
      if (dbg) fflush(stdout);
      delete pPort;
   }
   if(pButtons)
   {
      if (dbg) fprintf(stdout, "xServerQuery::~xServerQuery():Deleting pButtons\n");
      if (dbg) fflush(stdout);
      delete pButtons;
   }
   if (dbg) fprintf(stdout, "xServerQuery::~xServerQuery():Done!\n");
   if (dbg) fflush(stdout);
//   disconnect(this);
}

#include "xIrcServerQuery.moc"
