
/* remfloodout.c V1.0 - Copyright (C) 1993/94/95/96 Jim Geuther */

/*
 *
 * Function:	Remove border by flooding to outside of image.
 * Author: 	Jim GEUTHER
 * Date:    	17-May-96
 * Environment: Personal Power System 850 + AIX V4.1.3.0
 *
 * This Gimp plugin will remove borders (rectangles) from the inside to
 * the outside of an image. This is usefull for images which have two 
 * borders around them; one a border of a single color, followed by a
 * border of many colors.
 *
 * This filters uses the upper left corner established with the rectangle
 *							        =========
 * tool as the starting point.
 * ====
 *
 * This filter works on colormap indexed images and rgb images.
 *
 * Processing options:
 *
 * Use selected rectangle - this will cause a flood out to the outside
 * of the image, leaving the selected rectangle intact.
 *
 * color difference - Always used for RGB images, optional for colormap
 * indexed images. When active the difference between two colors will be
 * used to determine the edges of the border, otherwise absolute color 
 * values will be used.
 *
 * Fill color - Can be used to select the color with which the image
 * should be flooded. This can be either black, white or blue. If an
 * exact match is not available in the image's palette this program will 
 * attempt to find the closest match.
 *
 *
 *
 *
 * History:
 * V1.00	Jim GEUTHER, ported from ImageKnife (Amiga) to Gimp (AIX)
 *
 */
 
/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "gimp.h"
#include "types.h"
#include "macros.h"
#include "cmap_palette.h"
#include "cmap_funcs.h"

/* #define	_DEBUG */

#ifdef	_DEBUG
#define	NULLP()	printf("%s.%ld: NULLPOINTER\n",__FILE__,__LINE__)
#define	DPRINTF(x) printf("%s.%ld: %s",__FILE__,__LINE__,x)
#else
#define	NULLP()	
#define	DPRINTF(x)
#endif

/* Declare a local function.
 */
static void item_callback (int, void *, void *);
static void radio_callback (int, void *, void *);
static void toggle_callback(int item_ID, void *client_data, void *call_data);

static void ok_callback (int, void *, void *);
static void cancel_callback (int, void *, void *);
static void autoremove(Image, Image,long userect,long usediff,long fillcolor);

static char *prog_name;
static long fillmethod=0;
int dialog_ID;

int
main (argc, argv)
     int argc;
     char **argv;
{

Image input, output;
int 	group_ID, frame_ID, radio_ID, process_ID, diff_ID, black_ID, white_ID, blue_ID;
long	process, diff;
long	type;
void	*data;
static int one=1;

 /* Save the program name so we can use it later in reporting errors
   */
  prog_name = argv[0];

  /* Call 'gimp_init' to initialize this filter.
   * 'gimp_init' makes sure that the filter was properly called and
   *  it opens pipes for reading and writing.
   */
  if (gimp_init (argc, argv))
    {
      input = output = 0;
      /* This is a regular filter. What that means is that it operates
       *  on the input image. Output is put into the ouput image. The
       *  filter should not worry, or even care where these images come
       *  from. The only guarantee is that they are the same size and
       *  depth.
       */
      input = gimp_get_input_image (0);

      /* If input image is available and the input is color, then do some
       *  work. (Bleed). Then update the output image.
       */
      if (input)
	{
		type = gimp_image_type( input );
	  switch ( type )
	    {

    	    case GRAY_IMAGE:
	      gimp_message("remfloodout: can not operate on gray images");
	      break;
	      
	    case RGB_IMAGE:
	    case INDEXED_IMAGE:

	      	dialog_ID = gimp_new_dialog ("FloodOut");
	      	group_ID = gimp_new_row_group( dialog_ID, DEFAULT, NORMAL, "" );
	      	
	      	frame_ID = gimp_new_frame( dialog_ID, group_ID, "Processing" );
		radio_ID = gimp_new_row_group( dialog_ID, frame_ID, NORMAL, "" );
		process_ID = gimp_new_check_button( dialog_ID, radio_ID, "Use rectangle" );
		gimp_change_item( dialog_ID, process_ID, sizeof(process), &process);
		
		if( type == INDEXED_IMAGE ) {
			frame_ID = gimp_new_frame( dialog_ID, group_ID, "Edging" );
			radio_ID = gimp_new_row_group( dialog_ID, frame_ID, NORMAL, "" );
			diff_ID = gimp_new_check_button( dialog_ID, radio_ID, "Use colordifference" );
			gimp_change_item( dialog_ID, diff_ID, sizeof( diff ), &diff );		
		}
			
		frame_ID = gimp_new_frame( dialog_ID, group_ID, "Fill color" );
		radio_ID = gimp_new_row_group( dialog_ID, frame_ID, RADIO, "" );
		black_ID = gimp_new_radio_button( dialog_ID, radio_ID, "Black" );
		white_ID = gimp_new_radio_button( dialog_ID, radio_ID, "White" );
		blue_ID = gimp_new_radio_button( dialog_ID, radio_ID, "Blue" );
		gimp_change_item( dialog_ID, black_ID, sizeof( one ), &one );		
		
		gimp_add_callback( dialog_ID, black_ID, radio_callback, (void *)1 );
		gimp_add_callback( dialog_ID, white_ID, radio_callback, (void *)2 );
		gimp_add_callback( dialog_ID, blue_ID, radio_callback, (void *)3 );
				
		gimp_add_callback( dialog_ID, process_ID, toggle_callback, &process);
		if( type == INDEXED_IMAGE ) gimp_add_callback( dialog_ID, diff_ID, toggle_callback, &diff );
		
	      	gimp_add_callback (dialog_ID, gimp_ok_item_id (dialog_ID), ok_callback, 0);
	      	gimp_add_callback (dialog_ID, gimp_cancel_item_id (dialog_ID), cancel_callback, 0);
	      
	      if (gimp_show_dialog (dialog_ID))
		{

		  if( output = gimp_new_image( 0, gimp_image_width(input),
		  		gimp_image_height(input), gimp_image_type(input) ) ) {
		      gimp_set_image_colors(output,gimp_image_cmap(input),
		      				gimp_image_colors(input));

				
			if(!fillmethod) fillmethod=1;
		      	gimp_display_image( output );
		      	autoremove(input, output,process,diff,fillmethod);
		      	gimp_update_image (output);
		    }

		}

	      break;
	    default:
	      gimp_message ("remfloodout: cannot operate on unknown image types");
	      break;
	    }
	}

      /* Free both images.
       */
      if (input)
	gimp_free_image (input);
      if (output)
	gimp_free_image (output);

      /* Quit
       */
      gimp_quit ();
    }

  return 0;
}

static void toggle_callback(
int item_ID, void *client_data, void *call_data)
{
  *((int *) client_data) = *((long *) call_data);

}
static void
radio_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
 
 fillmethod=(int)client_data; 

}

static void
item_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  *((long*) client_data) = *((long*) call_data);
}

static void
ok_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 1);
}

static void
cancel_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 0);
}


static void
autoremove(input, output, userect, usediff, fillcolor)
     Image input, output;
     long userect, usediff, fillcolor;
{
  long width, height;
  long channels, rowstride, colors;
  unsigned char *src_row, *dest_row;
  unsigned char *src, *dest, *cmap, *cptr;

int	i;
short row, col;
int x1, y1, x2, y2, ix;
int allsame=FALSE;
int	fill=0;
int	img24=FALSE;
int	use_color_difference=FALSE;  
struct gws_rgb		rgb1, rgb2;
struct ColourTriplet	triplet;
struct ColourTriplet	triplet2;
struct ColourTriplet	*triplets=NULL;
u_long	diff,threshold;
long	type;
int	r,g,b;

#ifdef	_DEBUG
printf("%s.%ld: rect=%ld, diff=%ld, fill=%ld\n",__FILE__,__LINE__,userect,usediff,fillcolor);
#endif

  /* Get the input area. This is the bounding box of the selection in 
   *  the image (or the entire image if there is no selection). Only
   *  operating on the input area is simply an optimization. It doesn't
   *  need to be done for correct operation. (It simply makes it go
   *  faster, since fewer pixels need to be operated on).
   *
   * This filter will use only x1 and y1 as starting coordinates.
   *
   */
gimp_image_area (input, &x1, &y1, &x2, &y2);

if( gimp_image_type( input ) == RGB_IMAGE ) {
	img24 = TRUE;
	use_color_difference = TRUE;
}	

/* Get the size of the input image. (This will/must be the same
 *  as the size of the output image.
 */
colors   = gimp_image_colors( input ); 
cmap	 = gimp_image_cmap( input );
width    = gimp_image_width (input);
height   = gimp_image_height (input);
channels = gimp_image_channels (input);
type	 = gimp_image_type( input );
if( channels > 3 ) printf("remfloodout image has too many channels\n");

rowstride = width * channels;

if( type == INDEXED_IMAGE ) {
	DPRINTF("Build colormap lookup table\n");
	if( triplets = calloc( 256*sizeof( struct ColourTriplet ), 1 ) ) {
		triplets[0].Red = triplets[0].Green = triplets[0].Blue = 0;
		triplets[1].Red = triplets[1].Green = triplets[1].Blue = 63;
		threshold = truecolourdifference( &triplets[ 0 ], &triplets[ 1 ] );
		for( row = 0, cptr = cmap; row < colors; row++ ) {
			triplets[ row ].Red   = *cptr++;
			triplets[ row ].Green = *cptr++;
			triplets[ row ].Blue  = *cptr++;
		}
	} else NULLP();
}	


/* Find the index nr for desired fill color (if it exists) */
if( type == INDEXED_IMAGE ) {
	long	tdist,mdist=BIG_DISTANCE;

	fill = 256;

	/* Try to find exact match */
	for( ix = 0; ix < colors; ix++ ) {
		switch(fillcolor) {
		case 1 :	/* Black */
			if( (triplets[ix].Red == 0) 
			&&  (triplets[ix].Green==0)
			&&  (triplets[ix].Blue==0)) {
				fill=ix;
				break;
			}
			break;
		case 2 :	/* White */
			if( (triplets[ix].Red == 255) 
			&&  (triplets[ix].Green==255)
			&&  (triplets[ix].Blue==255)) {
				fill=ix;
				break;
			}
			break;
		case 3 : 	/* Blue */
			if( (triplets[ix].Red == 0) 
			&&  (triplets[ix].Green==0)
			&&  (triplets[ix].Blue==255)) {
				fill=ix;
				break;
			}
			break;
		default:
			DPRINTF("Internal error\n");
			break;
		}
	}

	if( fill > 255 ) {
		/* Color not found, find close match */
		switch(fillcolor) {
		case 1 : /* black */ 
			r=g=b=0;
			break;
		case 2 : /* white */
			r=g=b=255;
			break;
		case 3 : /* blue */
			r=g=0;
			b=255;
			break;
		default :
			DPRINTF("Internal error\n");
			break;
		}
		for(ix=0;ix<colors;ix++) {
			tdist=DIST(r,g,b,triplets[ix].Red,triplets[ix].Green,
				   triplets[ix].Blue);
			if(tdist<mdist) {
				mdist=tdist;
				fill=ix;
			}
		}
	}
#ifdef	_DEBUG
	printf("%s.%ld: fillpen=%ld\n",__FILE__,__LINE__,fill);	
#endif	

} else {
	switch(fillcolor) {
	case 1 : r=g=b=0;
		break;
	case 2 : r=g=b=255;
		break;
	case 3 : r=g=0;
		b=255;
		break;
	default :
		NULLP();
		break;
	}
}


src_row = gimp_image_data (input);
dest_row = gimp_image_data (output);
if( !userect ) {
	/* Copy entire source to destination image */
	for( row = 0; row < height; row++ , src_row += rowstride,
				   dest_row += rowstride ) 	
		for( col = 0, src = src_row, dest=dest_row; col < width; col++ ) 
			for( i=0; i < channels; i++ ) *dest++=*src++;
} else {
	/* Set entire image to fill color */
	if( type == INDEXED_IMAGE ) {
		for( row = 0; row < height; row++ , src_row += rowstride,
				   dest_row += rowstride ) 	
		for( col = 0, src = src_row, dest=dest_row; col < width; col++ ) 
			for( i=0; i < channels; i++ ) *dest++=fill;
	} else {
		for( row = 0; row < height; row++ , src_row += rowstride,
				   dest_row += rowstride ) 	
		for( col = 0, src = src_row, dest=dest_row; col < width; col++ ) {
				*dest++=r;
				*dest++=g;
				*dest++=b;
			}
		}
	/* Copy desired rectangle */
	src_row = gimp_image_data (input);
	src_row += (rowstride * y1) + (x1 * channels);
	dest_row = gimp_image_data (output);
	dest_row += (rowstride * y1) + (x1 * channels);	
	for(row=y1;row<y2;row++) {
		src=src_row;
		dest=dest_row;
		for(col=x1;col<x2;col++) 
			for(ix=0;ix<channels;ix++) *dest++=*src++;
		src_row+=rowstride;
		dest_row+=rowstride;
	}
	return; /* Get out of here */
}

		
/* Get reference color */
if( img24 ) {
	DPRINTF("Get reference color\n");
	src_row = gimp_image_data( input );
	src = src_row + (rowstride * y1) + (x1 * channels);
	triplet.Red   = *src++;
	triplet.Green = *src++;
	triplet.Blue  = *src++;

	triplet2.Red=MIN( triplet.Red+33, 255 );
	triplet2.Green=MIN( triplet.Green+33, 255 );
	triplet2.Blue=MIN( triplet.Blue+33, 255 );

	threshold=truecolourdifference(&triplet,&triplet2);

#ifdef	_DEBUG
	if(!threshold) {
		fprintf(stderr,"%s.%ld zero threshold\n",__FILE__,__LINE__);
	}
#endif

	src_row = gimp_image_data( input );
	src = src_row + (rowstride * y1) + (x1 * channels);
	for( col = x1; col < width; col++ ) {
		triplet2.Red   = *src++;
		triplet2.Green = *src++;
		triplet2.Blue  = *src++;
		diff=truecolourdifference(&triplet,&triplet2);
		if(diff>threshold) {
			x2=col;
			break;
		}
	}
} else {
	/* Get reference color for colormap indexed images 	*/
	/* Assume channel is one				*/	
	DPRINTF("Get reference color for cmap\n");
	src_row = gimp_image_data( input );
	src = src_row + (rowstride * y1) + (x1 * channels);
	rgb1.r = *src;	/* mis-use rgb1.r */
	if( !use_color_difference ) {
		DPRINTF("Use color difference\n");
		src++;
		rgb2.r = *src;	/* mis-use rgb2.r */
		/*
		 * Scan for a second color
		 */
		 DPRINTF("Scan for second color\n");
		if( rgb1.r == rgb2.r ) {
			src_row = gimp_image_data( input );
			src = src_row + (rowstride * y1) + ((x1+2) * channels);
			for( col = x1+2; col < width; col++, src++ ) {
				if( rgb1.r != *src ) {
					rgb2.r = *src;
					break;
				}
			}
		}
	} else {
		DPRINTF("Use treshold value\n");
		src_row 	= gimp_image_data( input );
		src 		= src_row + (rowstride * y1) + (x1 * channels);
		triplet.Red	= *src++;
		triplet.Green	= *src++;
		triplet.Blue	= *src++;

		/*
		 * Scan for a second color
		 */
		src_row 	= gimp_image_data( input );
		src 		= src_row + (rowstride * y1) + ((x1+1) * channels);
		for( col = x1 + 1; col < width; col++, src++ ) {
			diff=truecolourdifference(&triplet,
						  &triplets[*src]);
				if(diff>threshold)
				{
					rgb2.r = *src;
					x2=col;
					break;
				}
			}
		}
}


/*
 * Determine X2
 */
if( !img24 ) {
	DPRINTF("Determining start column right border\n");
	/* Scan from current x-position to right, until we hit
	 * a different color.
	 */
	src_row = gimp_image_data( input );
	src = src_row + (rowstride * y1) + ((x1) * channels);
	for( col = x1; col < width; col++, src++ ) {
		if( !use_color_difference ) {
			if( ( rgb1.r != *src ) && ( rgb2.r != *src ) ) {
				break;
			}
		} else {
			col=x1;
			DPRINTF("colordiff used\n");
			break;
		}
	}
	x2 = col;
#ifdef	_DEBUG
	fprintf(stderr,"%s.%ld: col1=%ld col2=%ld col3=%ld, x2=%ld\n",
		__FILE__,__LINE__,rgb1.r,rgb2.r,*src,x2);	
#endif
}
#ifdef	_DEBUG
	if(!img24)
	{
		fprintf(stderr,"%s.%ld: rgb1.r=%ld, rgb2.r=%ld, \n",
			__FILE__,__LINE__,rgb1.r,rgb2.r);
	}
#endif
/*	
 * Determine Y2
 */
DPRINTF("Determining Y2\n");
src_row = gimp_image_data( input );
src = src_row + (rowstride * y1) + ((x1) * channels);
if( use_color_difference && (!img24) ) {
	triplet.Red   = triplets[*src].Red;
	triplet.Green = triplets[*src].Green;
	triplet.Blue  = triplets[*src].Blue;
} else {
	triplet.Red   = *src++;
	triplet.Green = *src++;
	triplet.Blue  = *src++;
}

src_row = gimp_image_data( input );
src_row += (rowstride * y1) + ((x1) * channels);
for( row = y1; row < height; row++ ) {
	src = src_row;
	if( img24 ) {
		triplet2.Red   = *src++;
		triplet2.Green = *src++;
		triplet2.Blue  = *src++;
		diff=truecolourdifference(&triplet,&triplet2);
		if( diff > threshold ) {
			break;
		}
	} else if( !use_color_difference ) {
			if( ( rgb1.r != *src )
			&&( rgb2.r != *src ) ) {
				break;
			}
		} else {
			/*
			 * Scan for a second color
			 */
			diff=truecolourdifference(&triplet,
						  &triplets[ *src++ ]);
			if(diff>threshold) {
				break;
			}
		}
	src_row += rowstride;
}
#ifdef	_DEBUG
	fprintf(stderr,"%s.%ld: r1=%ld, g1=%ld, b1=%ld, r2=%ld, g2=%ld, b2=%ld, "
		"diff=%ld, thresh=%ld\n", __FILE__,__LINE__,triplet.Red, triplet.Green,
		triplet.Blue, triplet2.Red, triplet2.Green, triplet2.Blue,
		diff, threshold );
	fprintf(stderr,"%s.%ld: col1=%ld col2=%ld col3=%ld, y2=%ld\n",
		__FILE__,__LINE__,rgb1.r,rgb2.r,*src,row);	
#endif		
y2=row;

/*
 * Now whipe-out to top (top border)
 */
#ifdef	_DEBUG
	fprintf( stderr, "%s.%ld: floodout top border ystart=%ld, width=%ld\n",
		__FILE__, __LINE__, y1, width );
#endif			 

dest_row = gimp_image_data( output );
dest_row += ( rowstride * y1 ) ;
for( row = y1; row >= 0; row--) {
	dest = dest_row;
	for( col = 0; col < width; col++ ) {
		if( type == INDEXED_IMAGE ) {
			for( ix = 0; ix < channels; ix++ ) *dest++ = fill;
		} else {			
			*dest++=r;
			*dest++=g;
			*dest++=b;
		}
	}
	dest_row -= rowstride;
}


/*
 * Whipe out right border
 */
#ifdef	_DEBUG
	fprintf( stderr, "%s.%ld: floodout right border xstart=%ld, height=%ld\n",
		__FILE__, __LINE__, x2, height );
#endif		

dest_row = gimp_image_data( output );
dest_row += ((x2) * channels);
for( row = 0; row < height; row++ ) {
	dest = dest_row;
	for( col = x2; col < width; col++ ) {
		if( type == INDEXED_IMAGE ) {
			for( ix = 0; ix < channels; ix++ ) *dest++ = fill;
		} else {
			*dest++=r;
			*dest++=g;
			*dest++=b;
		}
	}
	dest_row += rowstride;
}


		
/*
 * Whipe out bottom border
 */
#ifdef	_DEBUG
	fprintf( stderr, "%s.%ld: floodout bottom border ystart=%ld, width=%ld\n",
		__FILE__, __LINE__, y2, width );
#endif			 

dest_row = gimp_image_data( output );
dest = dest_row + (rowstride * y2) + ((0) * channels);
for( row = y2; row < height; row++ ) 
	for( col = 0; col < width; col++ )
		if(type==INDEXED_IMAGE) {
			for( ix = 0; ix < channels; ix++) *dest++ = fill;
		} else {
			*dest++=r;
			*dest++=g;
			*dest++=b;
		}


		
/*
 * Whipe out left border
 */
#ifdef	_DEBUG
	fprintf( stderr, "%s.%ld: floodout left border xend=%ld, height=%ld\n",
		__FILE__, __LINE__, x1, height );
#endif
dest_row = gimp_image_data( output );
for( row = 0; row < height; row++ ) {
	dest = dest_row;
	for( col = 0; col < x1; col++ )
		if(type==INDEXED_IMAGE) { /* Is your compiler smart enough to move this outside the loop? */
			for( ix = 0; ix < channels; ix++) *dest++ = fill;
		} else {
			*dest++=r;
			*dest++=g;
			*dest++=b;
		}
	dest_row += rowstride;
}		

if( triplets ) free( triplets );

return;    	
}

/* Agree, I don't like my coding style? either 	*/
/* Feel free to optimize this code!		*/





