
/* remcols.c V1.0 - Copyright (C) 1993/94/95/96 Jim Geuther */

/*
 *
 * Function:	Remove columns
 * Author: 	Jim GEUTHER
 * Date:    	16-May-96
 * Environment: Personal Power System 850 + AIX V4.1.3.0
 *
 * This Gimp plugin is used to remove columns from colormap indexed
 * image. 
 *
 * The usefullness of this plugin is that in combination with remrows
 * in can be used to remove "borders" from images which consist (collage)
 * of other images.
 *
 *
 * The new image is deliberately not resized to match the cropped image. This
 * allows you to blend-in a new border if you wish.
 * If you want to resize the new image use the autocrop function.
 *
 * Practice has shown that in most cases a threshold value of 12
 * gives good results.
 *
 *
 * History:
 * V1.00	Jim GEUTHER, ported from ImageKnife (Amiga) to Gimp (AIX)
 *
 */
 
/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "gimp.h"
#include "types.h"

#ifdef	_DEBUG
#define	NULLP()	printf("%s.%ld: NULLPOINTER\n",__FILE__,__LINE__)
#define	DPRINTF(x) printf("%s.%ld: %s",__FILE__,__LINE__,x)
#else
#define	NULLP()	
#define	DPRINTF(x)
#endif

/* Declare a local function.
 */
static void scale_callback (int, void *, void *);
static void ok_callback (int, void *, void *);
static void cancel_callback (int, void *, void *);
static void autoremove(Image, Image);

static char *prog_name;

/*  threshold of remcols  */
static long threshold = 12;
int dialog_ID;

int
main (argc, argv)
     int argc;
     char **argv;
{

Image input, output;
int scale_ID;

void	*data;

 /* Save the program name so we can use it later in reporting errors
   */
  prog_name = argv[0];

  /* Call 'gimp_init' to initialize this filter.
   * 'gimp_init' makes sure that the filter was properly called and
   *  it opens pipes for reading and writing.
   */
  if (gimp_init (argc, argv))
    {
      input = output = 0;
	data = gimp_get_params();
	if( data ) 
		threshold = ((int *)data)[0];
      /* This is a regular filter. What that means is that it operates
       *  on the input image. Output is put into the ouput image. The
       *  filter should not worry, or even care where these images come
       *  from. The only guarantee is that they are the same size and
       *  depth.
       */
      input = gimp_get_input_image (0);

      /* If input image is available and the input is color, then do some
       *  work. (Bleed). Then update the output image.
       */
      if (input)
	{
	  switch (gimp_image_type (input))
	    {
	    case RGB_IMAGE:
	    case GRAY_IMAGE:	    
	      gimp_message("remcols: can operate only on indexed images");
	      break;
	    case INDEXED_IMAGE:
	      dialog_ID = gimp_new_dialog ("Remove Border");
	      scale_ID = gimp_new_scale (dialog_ID, DEFAULT, 1, 255, threshold, 0);
	      gimp_add_callback (dialog_ID, scale_ID, scale_callback, &threshold);
	      gimp_add_callback (dialog_ID, gimp_ok_item_id (dialog_ID), ok_callback, 0);
	      gimp_add_callback (dialog_ID, gimp_cancel_item_id (dialog_ID), cancel_callback, 0);
	      
	      if (gimp_show_dialog (dialog_ID))
		{
			gimp_set_params(sizeof(int), &threshold);
#ifdef	OBSOLETE		
		  if( output = gimp_new_image( 0, gimp_image_width(input),
		  		gimp_image_height(input), INDEXED_IMAGE ) ) {
		      gimp_set_image_colors(output,gimp_image_cmap(input),
		      				gimp_image_colors(input));
#else
		if( output = gimp_get_output_image( 0 ) ) {
#endif				      				
		      gimp_display_image( output );
		      autoremove(input, output);
		      gimp_update_image (output);
		    }
		}
	      break;
	    default:
	      gimp_message ("remcols: cannot operate on unknown image types");
	      break;
	    }
	}

      /* Free both images.
       */
      if (input)
	gimp_free_image (input);
      if (output)
	gimp_free_image (output);

      /* Quit
       */
      gimp_quit ();
    }

  return 0;
}

static void
scale_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  *((long*) client_data) = *((long*) call_data);
}

static void
ok_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 1);
}

static void
cancel_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 0);
}

static long colorspercol(
unsigned char	*dest_row,
int		channels,
int		rowstride,
int		row_start,
int		row_end,
int		col
)
{
/*
** Determine number of different colors per column
*/
int	*pens;
int	colors = 256 + 1;
int	ix;
unsigned char	*dest;

if( pens = calloc( 256 * sizeof(long), 1) ) {
	for( ; row_start < row_end; row_start++ ) {
		/* How fast is your integer processor??? */
		dest = dest_row + rowstride * row_start + ( col * channels ); 
   		pens[ *dest ] += 1;
	}
	for( ix=0, colors=0; ix < 256; ix++ ) if( pens[ ix ] > 0 )colors+=1;
	free( pens );
} else NULLP();



return(colors);
}

static void
autoremove(input, output)
     Image input, output;
{
  long width, height;
  long channels, rowstride;
  unsigned char *src_row, *dest_row,*start_image;
  unsigned char *src, *dest;

int	i;
short row, col;
int x1, y1, x2, y2;
int allsame=FALSE;
  
  /* Get the input area. This is the bounding box of the selection in 
   *  the image (or the entire image if there is no selection). Only
   *  operating on the input area is simply an optimization. It doesn't
   *  need to be done for correct operation. (It simply makes it go
   *  faster, since fewer pixels need to be operated on).
   */
gimp_image_area (input, &x1, &y1, &x2, &y2);

/* Get the size of the input image. (This will/must be the same
 *  as the size of the output image.
 */
width = gimp_image_width (input);
height = gimp_image_height (input);
channels = gimp_image_channels (input);
rowstride = width * channels;

src_row = gimp_image_data (input);
dest_row = gimp_image_data (output);

/* Copy entire source to destination image */
for( row = 0; row < height; row++ , src_row += rowstride,
				   dest_row += rowstride ) 	
	for( col = 0, src = src_row, dest=dest_row; col < width; col++ ) 
		for( i=0; i < channels; i++ ) *dest++=*src++;

allsame=TRUE;

dest_row = gimp_image_data (output);
dest_row += rowstride * y1 + (x1 * channels);
	
allsame = TRUE;
dest_row = gimp_image_data (output);
	
for( col = x1 ;	col < x2; col++ ) {
	allsame = FALSE;
	if( colorspercol( dest_row, channels, rowstride, y1, y2, col ) < threshold ) allsame = TRUE;
	if( allsame ) {
		for( row = y1; row< y2; row++ ) {
			dest = dest_row + rowstride * row + ( col * channels ); /* This hurts, hopefully your compiler will optimize this */
			*dest = 0;
		}
	}
}

return;    	
}






