
/* colormap bias filter for the Gimp
 * Jim GEUTHER
 *
 * V1.00
 *
 * This filter bias the colormap to a selected color.
 *
 * For best results, you should first remap the colormap from 
 * dark to light before using this function.
 *
 */


#include "gimp.h"

static void radio_callback (int, void *, void *);
static void ok_callback (int, void *, void *);
static void cancel_callback (int, void *, void *);

static char *prog_name;
static long amount = 9;
static int dialog_ID;
static int bias=0;

int
main (argc, argv)
     int argc;
     char *argv[];
{
Image	input,output;
long red_ID,green_ID,blue_ID,cyan_ID,magenta_ID,yellow_ID,group_ID;
static int one=1;
  /* Save the program name so we can use it later in reporting errors
   */
  prog_name = argv[0];

  /* Call 'gimp_init' to initialize this filter.
   * 'gimp_init' makes sure that the filter was properly called and
   *  it opens pipes for reading and writing.
   */
  if (gimp_init (argc, argv))
    {
	if(input=gimp_get_input_image(0)) {
		switch(gimp_image_type(input)) {
		case INDEXED_IMAGE :
			dialog_ID = gimp_new_dialog("Bias");
			group_ID=gimp_new_row_group(dialog_ID,DEFAULT,RADIO,"");
			red_ID=gimp_new_radio_button(dialog_ID,group_ID,"Red");
			green_ID=gimp_new_radio_button(dialog_ID,group_ID,"Green");
			blue_ID=gimp_new_radio_button(dialog_ID,group_ID,"Blue");		
			cyan_ID=gimp_new_radio_button(dialog_ID,group_ID,"Cyan");
			magenta_ID=gimp_new_radio_button(dialog_ID,group_ID,"Magenta");
			yellow_ID=gimp_new_radio_button(dialog_ID,group_ID,"Yellow");	
		      	gimp_change_item(dialog_ID, red_ID, sizeof (one), &one);
		      	gimp_add_callback(dialog_ID,red_ID,radio_callback,(void *)0);
		      	gimp_add_callback(dialog_ID,green_ID,radio_callback,(void *)1);
		      	gimp_add_callback(dialog_ID,blue_ID,radio_callback,(void *)2);
		      	gimp_add_callback(dialog_ID,cyan_ID,radio_callback,(void *)3);
		      	gimp_add_callback(dialog_ID,magenta_ID,radio_callback,(void *)4);
		      	gimp_add_callback(dialog_ID,yellow_ID,radio_callback,(void *)5);		      	
		      			      			      			      			      	
		      	gimp_add_callback (dialog_ID, gimp_ok_item_id (dialog_ID), ok_callback, 0);
			gimp_add_callback (dialog_ID, gimp_cancel_item_id (dialog_ID), cancel_callback, 0);
		  	if(gimp_show_dialog(dialog_ID)) {    	
				/* A new output image is created, to ensure the
				   image is displayed correctly. */
				if(output=gimp_new_image(0,gimp_image_width(input),
						gimp_image_height(input),
						INDEXED_IMAGE)) {
						req_palette(input,output,bias);
					gimp_display_image(output);
					gimp_update_image(output);
					gimp_free_image(output);
				} else printf("%s: get output image failed\n",prog_name);
			}
			break;
		default :
			gimp_message("cmapanal: can only operate on indexed color images");
			break;
		}
		gimp_free_image(input);
	}			
       /* Quit
       */
      gimp_quit ();
    }

  return 0;
}


static void
radio_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
#ifdef	OBSOLETE
  *((long*) client_data) = *((long*) call_data);
#endif  
 bias=(int)client_data; 

}

static void
ok_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 1);
}

static void
cancel_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 0);
}



