/*
 *  Printer - the OffiX print manager
 *  Copyright (c) 1996 Andr Hentz
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <OffiX/DragAndDrop.h>
#include "Util.h"
#include "Icon.h"
#include "Error.h"

static String fallback_resources[] = {
#include "Printer.ad.h"
NULL
};

#ifndef XawChainTop  /* X11R4 */
#define XawChainTop XtChainTop
#define XawChainLeft XtChainLeft
#define XawChainRight XtChainRight
#define XawChainBottom XtChainBottom
#define XtSetLanguageProc(x,y,z)  /* nothing */
#endif

/*-------------- Public variables --------------*/
List 		*Printers;
ListEntry 	*CurrentPrinter;
List 		*Jobs;
char		**JobsArray;
Widget 		JobsList;
XtAppContext 	app;
Widget		toplevel,form;
Widget	WarningArea;
/*-------------- Private variables --------------*/
Widget  PrintersButton, PrintersMenu,RemoveButton,PrintButton;
Widget	UpdateButton,QuitButton;
Atom 	WM_DELETE_WINDOW;
/*-------------- Private variables --------------*/
void CreatePrintersMenu(Widget parent);
void PrintersMenuCb(Widget w, XtPointer client_data, XtPointer call_data);
void UpdateButtonCb(Widget w, XtPointer client_data, XtPointer call_data);
void RemoveButtonCb(Widget w, XtPointer client_data, XtPointer call_data);
void QuitButtonCb(Widget w, XtPointer client_data, XtPointer call_data);
void JobsListCb(Widget w, XtPointer client_data, XtPointer call_data);
void DestroyCb(Widget w, XtPointer client_data, XtPointer call_data);
void WMDeleteHandler(Widget widget,XtPointer data,XEvent *event,Boolean *b);
void DropEventHandler(Widget w,XtPointer data,XEvent *event,Boolean *b);
void CreateButtonBar(Widget parent);
void Exiting();


void main(int argc, char* argv[])
{
	int i;
	Dimension AppWidth,Dist,height;
        XtSetLanguageProc(NULL,NULL,NULL);
	
	Printers = NewList();

	JobsArray = (char**)calloc( 10,sizeof(char*));
	JobsArray[0] = strdup("No available printers");
	for (i=1;i<9;JobsArray[i++]=strdup(""));
	JobsArray[9] = NULL;
	
	toplevel=XtVaAppInitialize(&app,"Printer",NULL,0,
				   &argc,argv,fallback_resources,
				   NULL);
	DndInitialize(toplevel);
	DndRegisterOtherDrop(DropEventHandler);
	DndRegisterIconDrop(DropEventHandler);
	
	XtVaSetValues(toplevel, XtNtitle, "No Printer", NULL);

	form=XtVaCreateManagedWidget("Form",
		formWidgetClass, toplevel,
		XtNborderWidth, 0,
		NULL);
	
	CreateButtonBar(form);
	
	JobsList=XtVaCreateManagedWidget("JobsList",
		listWidgetClass, form,
                XtNleft, XawChainLeft,
                XtNright, XawChainRight,
		XtNtop, XawChainTop,
		XtNborderWidth, 1, 
		XtNdefaultColumns, 1,		
		XtNlist, JobsArray,
		XtNforceColumns, True,
		XtNfromHoriz, PrintersButton,
		XtNnumberStrings, 9, 
		XtNwidth, 350,
		XtNheight, 150,
		NULL);
   	XtAddCallback(JobsList, XtNcallback,
		        (XtCallbackProc) JobsListCb,
			NULL );		
	/* This is necessary for the icon management */
	DndRegisterDropWidget(JobsList,DropEventHandler,NULL);

	WarningArea=XtVaCreateManagedWidget("Warnings",
		asciiTextWidgetClass, form,
 		XtNleft, XawChainLeft,
		XtNright, XawChainRight,
		XtNbottom, XawChainBottom,
		XtNborderWidth, 1,
		XtNfromVert, JobsList,
#ifndef HAVE_X11R6
                XtNfromHoriz, PrintersButton,
                XtNwidth, 350,
#endif
                XtNresize, True,
		XtNscrollVertical, XawtextScrollAlways,
		XtNwrap, XawtextWrapLine,
		NULL);
	XtVaGetValues(WarningArea, XtNheight, &height, NULL);
	XtVaSetValues(WarningArea, XtNheight, 2*height-2, NULL);
	
	ResetTimer();	
	XtRealizeWidget(toplevel);
	
	/* set up the icons */
	ReadIcons();

	CreatePrintersMenu(PrintersButton);
	
	/* set the correct size of JobsList and WarningArea*/
#ifdef linux    
	XtVaGetValues(form,XtNwidth,&AppWidth, XtNdefaultDistance,&Dist,NULL);
#else	
	XtVaGetValues(toplevel,XtNwidth,&AppWidth, XtNdefaultDistance,&Dist,NULL);
#endif
        XtVaSetValues(WarningArea, XtNresizable,True, NULL);
	XtVaSetValues(WarningArea,
		      XtNwidth,AppWidth-2*Dist-2,
		      XtNresize, False, 
		      NULL);
	/*	XtVaSetValues(JobsList,XtNresizable,True,NULL);
	XtVaSetValues(JobsList,XtNwidth,AppWidth-2*Dist-2, NULL);
	*/
	WM_DELETE_WINDOW=XInternAtom(XtDisplay(toplevel),"WM_DELETE_WINDOW",False);
	XSetWMProtocols(XtDisplay(toplevel),XtWindow(toplevel),&WM_DELETE_WINDOW,1);
	XtAddEventHandler(toplevel,NoEventMask,True,WMDeleteHandler,NULL);

	XtAppMainLoop(app);
}

void CreateButtonBar(Widget parent)
{
	Dimension Dist, BtnWidth;
	PrintersButton=XtVaCreateManagedWidget("PrintersButton",
		menuButtonWidgetClass, parent,
		XtNmenuName, "PrintersMenu",
		XtNleft, XawChainLeft,
		XtNright, XawChainLeft,
		XtNbottom, XawChainTop,
		XtNtop, XawChainTop,
		XtNlabel, "Printers", NULL);	

	RemoveButton=XtVaCreateManagedWidget("RemoveButton",
		commandWidgetClass, parent,
		XtNlabel, "Remove",
		XtNleft, XawChainLeft,
		XtNright, XawChainLeft,
		XtNbottom, XawChainTop,
		XtNtop, XawChainTop,
		XtNfromVert, PrintersButton,
		NULL);

	UpdateButton=XtVaCreateManagedWidget("UpdateButton",
		commandWidgetClass, parent,
		XtNlabel, "Update",
		XtNleft, XawChainLeft,
		XtNright, XawChainLeft,
		XtNbottom, XawChainTop,
		XtNtop, XawChainTop,
		XtNfromVert, RemoveButton,
		NULL);

	QuitButton=XtVaCreateManagedWidget("QuitButton",
		commandWidgetClass, parent,
		XtNlabel, "Quit",
		XtNleft, XawChainLeft,
		XtNright, XawChainLeft,
		XtNbottom, XawChainTop,
		XtNtop, XawChainTop,
		XtNfromVert,UpdateButton,
		NULL);

	XtVaGetValues(RemoveButton,XtNwidth,&BtnWidth, 
		      XtNdefaultDistance,&Dist,NULL);
	XtVaSetValues(PrintersButton,XtNwidth,BtnWidth, 
		      XtNdefaultDistance,Dist,NULL);
	XtVaSetValues(UpdateButton,XtNwidth,BtnWidth, 
		      XtNdefaultDistance,Dist,NULL);
	XtVaSetValues(QuitButton,XtNwidth,BtnWidth, 
		      XtNdefaultDistance,Dist,NULL);
	
	/* Add Callbacks */
	XtAddCallback(RemoveButton, XtNcallback,
		        (XtCallbackProc) RemoveButtonCb,
			NULL );
   	XtAddCallback(UpdateButton, XtNcallback,
		         (XtCallbackProc) UpdateButtonCb,
				 NULL );
   	XtAddCallback(QuitButton, XtNcallback,
		        (XtCallbackProc) QuitButtonCb,
			NULL );
}

void CreatePrintersMenu(Widget parent)
{
	Widget item_widget;
	ListEntry *printer;
	char DefaultPrinter[100], *tmp;
	
	tmp = getenv("PRINTER");
	if(tmp)
		strcpy(DefaultPrinter, tmp);
	else
		strcpy(DefaultPrinter, "lp");

	PrintersMenu = XtCreatePopupShell("PrintersMenu", 
				simpleMenuWidgetClass, parent, 
				NULL, 0 );
	GetPrinters(Printers);
	printer = Printers->first;
	if(!printer)
	{	/* no printcap file */
	 	item_widget = XtVaCreateManagedWidget("No Printers",
				      smeBSBObjectClass, PrintersMenu,
				      XtNlabel, "No Printers",
				      NULL);
		return;
	}
	
	while(printer)
	{

		if(!strcmp(DefaultPrinter, printer->string))
		  	CurrentPrinter = printer;

	 	item_widget = XtVaCreateManagedWidget(printer->string,
				      smeBSBObjectClass, PrintersMenu,
				      XtNlabel, printer->string,
				      NULL);
      		XtAddCallback(item_widget, XtNcallback,
		        (XtCallbackProc) PrintersMenuCb,
			(XtPointer)printer->string );
		printer = printer->next;
	}
	if (!CurrentPrinter)
		CurrentPrinter = Printers->first;	
	UpdateJobsList(CurrentPrinter->string);
}

void PrintersMenuCb(Widget w, XtPointer client_data, XtPointer call_data)
{
	UpdateJobsList((char*)client_data);
}

void UpdateButtonCb(Widget w, XtPointer client_data, XtPointer call_data)
{
	UpdateJobsList(CurrentPrinter->string);
}


void RemoveButtonCb(Widget w, XtPointer client_data, XtPointer call_data)
{
	XawListReturnStruct *list_data;
	int i;
	ListEntry *job;
	char header[200];
	
	if (!Jobs) return;

	list_data = XawListShowCurrent(JobsList);
	i = list_data->list_index;
	if (i == XAW_LIST_NONE)
		return;
	job = Jobs->first;
	while(i--)
	{	  
	  if (IsTopLine(job->string))
		  strcpy(header, job->string);
	  job = job->next;
	}	
	if (IsJobLine(job->string))				  
	{	
		ClearErrorMessages(1);
		RemoveJob(CurrentPrinter->string, GetJobNumber(header, job->string));
		ShowWarnings();
		if (IsThereError())
			ShowError();
		UpdateJobsList(CurrentPrinter->string);
	}
}

void QuitButtonCb(Widget w, XtPointer client_data, XtPointer call_data)
{
	Exiting();
}

void JobsListCb(Widget w, XtPointer client_data, XtPointer call_data)
{	
#ifdef VERBOSE
	int i = ((XawListReturnStruct*)call_data)->list_index;
	ListEntry *job;
	if (!Jobs) return;
	job = Jobs->first;
	while(job && i--)
	  job = job->next;
	
	if (job && IsJobLine(job->string))
	  printf("Item selected\n");
#endif
}


void WMDeleteHandler(Widget widget,XtPointer data,XEvent *event,Boolean *b)
{
	if(event->type != ClientMessage)	return;
	if(event->xclient.format != 32)		return;
	if(event->xclient.data.l[0] != WM_DELETE_WINDOW) return;
	
	Exiting();
}

void DropEventHandler(Widget w,XtPointer data,XEvent *event,Boolean *b)
{
	unsigned char *Data;
	unsigned long DataSize;
	char *filename;
	
	int Type=DndDataType(event);
	DndGetData(&Data,&DataSize);	
	
	switch(Type)
	{ 
		case DndFile:
			ClearErrorMessages(1);	
			PrintSingleFile((char*)Data);
			ShowWarnings();
			if(IsThereError())
			  	ShowError();
			break;
		case DndFiles:
			ClearErrorMessages(1);	
			filename = (char*)Data;
			while (filename[0] != '\0')
			{
				PrintSingleFile(filename);
				filename = filename + strlen(filename) + 1;
				if(IsThereError())
				{					
				  	ShowError();
					break;
				}				
			}	
			ShowWarnings();
			break;
		case DndRawData:
		case DndText:
			ClearErrorMessages(1);	
			PrintData((char*)Data, DataSize);
			ShowWarnings();
			if(IsThereError())
			  	ShowError();
			break;
		default:
			ShowErrorPopup("Don't know how to handle this drop!");
			return;
	}	
	sleep(1);  /* just to wait for things to settle down */
	UpdateJobsList(CurrentPrinter->string);
}

void Exiting()
{												
 	FreeList(Printers);
	exit(0);
}
