/* snarf, the Simple Non-interactive All-purpose Resource Fetcher
** Copyright (C) 1995 Zachary Beane
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public LIcense as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is dsitributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILIY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** The author of this program may be reached via email at
** xach@phoenix.umeres.maine.edu or via USPS at 17 Talmadge Rd., Waite,
** ME 04492, USA.
*/
/* ftp.c, just a stub right now */
#include <stdio.h>
#include <stdlib.h>
#include "ftplib.h"
#include "url.h"



int ftp_get(struct url u, char *outfile)
{
  char *outputfile;
  ftplib_debug = 0;
  ftpInit();
  if(!ftpOpen((char *)u.u_host)){
    fprintf(stderr, "%s: unable to connect to host\n", u.u_host);
    return(0);
  }
  if(!ftpLogin("anonymous", "snarf@")){
    fprintf(stderr, "%s: anonymous access denied\n", u.u_host);
    return(0);
  }

  if(!ftpChdir((char *)u.u_path)){
    fprintf(stderr, "%s: unable to chdir to %s\n", u.u_host, u.u_path);
    return(0);
  }

  switch(outfile[0]){
  case '-':
    outputfile = NULL;
    break;
  default:
    outputfile = outfile;
    break;
      }

  if(strlen(u.u_file) < 1){
    if(!ftpDir(outputfile, NULL)){
      fprintf(stderr, "%s: directory list unavailable\n");
      return(0);
    }
  }
  else {
    if(!ftpGet(outputfile, u.u_file, 'I')){
      fprintf(stderr, "%s: unable to get file %s\n", u.u_host, u.u_file);
      return(0);
    }
  }
  return(1);
}
