#!/usr/bin/perl
#

die "Usage: $0 device-path\n" unless (@ARGV == 1);

($disk) = @ARGV;

format STDOUT_TOP =
 # Partition Type                HFS Volume Name                Start    Length
-------------------------------------------------------------------------------
.

format STDOUT =
@# @<<<<<<<<<<<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<<<<<<<<<< @####### @########
$bnum, $pmParType, $drVN, $pmPyPartStart, $pmPartBlkCnt
.

open(DISK, $disk) || die "$disk: $!\n";

$bnum = 1;

do {
    seek(DISK, 512 * $bnum, 0) || die "seek: $!\n";
    read(DISK, $block, 512) || die "read: $!\n";

    ($pmSig, $pmMapBlkCnt, $pmPyPartStart, $pmPartBlkCnt, $pmParType) =
	(unpack('n2 N3 A32 A32 N10 A16', $block))[0, 2..4, 6];

    die "$disk: unsupported partition map\n" if ($pmSig == 0x5453);
    die "$disk: no partition map\n" unless ($pmSig == 0x504d);

    if ($pmParType eq 'Apple_HFS') {
	seek(DISK, 512 * ($pmPyPartStart + 2), 0) || die "seek: $!\n";
	read(DISK, $block, 512) || die "read: $!\n";

	($len, $drVN) = (unpack('n N2 n5 N2 n N n c A27', $block))[13, 14];
	$drVN = substr($drVN, 0, $len);
    } else {
	$drVN = '';
    }

    write;
} while ($bnum++ < $pmMapBlkCnt);

close(DISK);
