#ifndef vms
#if HAVE_SYS_NDIR_H || HAVE_SYS_DIR_H || HAVE_NDIR_H
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#else
# include <dirent.h>
# define NAMLEN(dirent) Extent((dirent)->d_name)
#endif
#include <pwd.h>
#else
#include "vms.h"
#endif

#ifndef S_ISDIR
#define S_ISDIR(mode) (((mode) & S_IFMT) == S_IFDIR)
#endif

/*
  Utility define declarations.
*/
#if !defined(vms) && !defined(__MWERKS__)
#define IsGlob(text) \
  ((strchr(text,'*') != (char *) NULL) || \
   (strchr(text,'?') != (char *) NULL) || \
   (strchr(text,'{') != (char *) NULL) || \
   (strchr(text,'}') != (char *) NULL) || \
   (strchr(text,'[') != (char *) NULL) || \
   (strchr(text,']') != (char *) NULL))
#define BasenameSeparator  "/"
#define DirectorySeparator  "/"
#define SystemCommand(command)  system(command)
#define TemporaryDirectory  "/tmp"
#define TemporaryTemplate  "%s/magickXXXXXX"
#else
#if defined(vms)
#define IsGlob(text) \
  ((strchr(text,'*') != (char *) NULL) || \
   (strchr(text,'?') != (char *) NULL) || \
   (strchr(text,'{') != (char *) NULL) || \
   (strchr(text,'}') != (char *) NULL))
#define BasenameSeparator  "]"
#define DirectorySeparator  ""
#define SystemCommand(command)  (!system(command))
#define TemporaryDirectory  "SYS$Disk:[]"
#define TemporaryTemplate  "%smagickXXXXXX.tmp"
#else
#define IsGlob(text) \
  ((strchr(text,'*') != (char *) NULL) || \
   (strchr(text,'?') != (char *) NULL) || \
   (strchr(text,'{') != (char *) NULL) || \
   (strchr(text,'}') != (char *) NULL) || \
   (strchr(text,'[') != (char *) NULL) || \
   (strchr(text,']') != (char *) NULL))
#define BasenameSeparator  ":"
#define DirectorySeparator  ""
#define SystemCommand(command)  system(command)
#define TemporaryDirectory  ""
#define TemporaryTemplate  "%smagickXXXXXX"
#endif
#endif

/*
  Utilities routines.
*/
extern char
  *ClientName(const char *),
  **ListColors(const char *,int *),
  **ListFiles(char *,const char *,int *),
  *PostscriptGeometry(const char *),
  **StringToList(char *);

extern int
  GlobExpression(char *,const char *),
  MultilineCensus(const char *),
  ReadDataBlock(char *,FILE *);

extern unsigned int
  IsAccessible(const char *),
  ReadData(char *,const unsigned int,const unsigned int,FILE *);

extern unsigned long
  LSBFirstReadLong(FILE *),
  MSBFirstReadLong(FILE *);

extern unsigned short
  LSBFirstReadShort(FILE *),
  MSBFirstReadShort(FILE *);

extern void
  AppendImageFormat(const char *,char *),
  ExpandFilename(char *),
  ExpandFilenames(int *,char ***),
  LocaleFilename(char *),
  LSBFirstWriteLong(const unsigned long,FILE *),
  LSBFirstWriteShort(const unsigned int,FILE *),
  MSBFirstOrderLong(char *,const unsigned int),
  MSBFirstOrderShort(char *,const unsigned int),
  MSBFirstWriteLong(const unsigned long,FILE *),
  MSBFirstWriteShort(const unsigned int,FILE *),
  Strip(char *),
  TemporaryFilename(char *);
