/* ap_error.c
 *$Header: /al/acs/src/RCS/ap_error.cc,v 9.21 95/10/21 18:08:45 al Exp $
 * Error handler.
 */
#include "ap.h"
#include "error.h"
#include "io.h"
#include "u_opt.h"
/*--------------------------------------------------------------------------*/
//	void	CS::check(int i);
//	void	CS::warn(int i,int c);
/*--------------------------------------------------------------------------*/
/* syntax_check: handle syntax errors
 * called on parsing an input string when nothing else matches.
 * if the rest of the line is nothing, just return
 * if comment, increment *cnt, so what is left is a valid comment string
 * otherwise, it is an error (the arrow pointing at the offending word)
 */
void CS::check(int badness)
{
  switch (more()){
  case '\'':
    skip();
  case '\0':
    break;
  default:
    warn(badness);
    break;
  }
}
/*--------------------------------------------------------------------------*/
/* syntax_msg: print syntax error message
 * echo a portion of the input with an arrow pointing to the current place
 */
void CS::warn(int badness, int spot)
{
  if (badness >= OPT::picky){
    if (spot < 20){
      mprintf(IO::mstderr, "%.40s\n", cmd);
      mtab(spot, IO::mstderr);
      error(badness,"^ ?\n");
    }else{
      mprintf(IO::mstderr, "... %.36s\n", &cmd[spot-16]);
      mtab(20, IO::mstderr);
      error(badness,"^ ?\n");
    }
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
