#include "wily.h"
#include "key.h"

/* Copy the data from 'e' to the window or output directory
 * corresponding to 'k'
 */
static void
outmsg(Key*k, Event *e)
{
	char *s = e->data;
	int n = e->n;

	if(k->v)
		view_append(k->v, &k->first, s, n);
	else
		noutput(k->dir, s, n);
}

/* Accept the connection we're told about in 'e' */
static void
ex_accept(Event *e)
{
	char *s = e->data;
	int n = e->n;
	int	fd = wily_connect(s,n);
	ulong	key;

	if(fd<0)
		return;

	if (!(key= estart(0,fd,0))){
		perror("couldn't estart");
		close(fd);
	} else {
		key_new(key, fd, Kmsg);
	} 
}

/* Copy the data from 'e' into 'k', possibly act on the message */
static void
partialmsg(Key *k, Event *e)
{
	char *s = e->data;
	int n = e->n;
	char	*ptr;
	int	left;

	/* copy to k->buf */
	SETSIZE(k->buf, k->alloced, k->n + n);
	memcpy(k->buf + k->n, s, n);
	k->n += n;

	/* process any whole messages */
	ptr = k->buf;
	left = k->n;
	while (FULLMSG(ptr,left)) {
		Msg		m;
		int	eaten = msg_bufsize(ptr);

		if(msg_init(&m, ptr)){
			perror("closing msg connection");
			key_del(k);
			return;
		}
		ptr += eaten;
		left -= eaten;
		msg_process(&m, k->fd);
	}

	/* move any incomplete messages to front of k->buf */
	if (left && left != k->n)
		memmove(k->buf, ptr, left);
	k->n = left;
}

/* Handle an event which isn't a mouse, keyboard or timer. */
void
dofd(ulong key, Event *e)
{
	Key	*k = key_find(key);

	if(!e->n) {
		key_del(k);
		return;
	}

	switch(k->t){
	case Klisten:	ex_accept(e);		break;
	case Kmsg:	partialmsg(k, e);	break;
	case Kout:	outmsg(k,e);		break;
	default:		error("bad key type %d", k->t);		break;
	}
}

