/*
 * tixCompat.c --
 *
 *	Some compatibility functions for Tix.
 *
 * Copyright (c) 1996, Expert Interface Technologies
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */
#include <tkPort.h>
#include <tkInt.h>
#include <tixInt.h>

#ifdef NO_STRDUP

/* strdup not a POSIX call */

char * tixStrDup(char * s)
{
    size_t len = strlen(s)+1;
    char * new_string;

    new_string = (char*)ckalloc(len);
    strcpy(new_string, s);

    return new_string;
}

#endif /* NO_STRDUP */


#ifdef NO_STRCASECMP

int tixStrCaseCmp(a, b)
    CONST char * a;
    CONST char * b;
{
    while (1) {
	if (*a== 0 && *b==0) {
	    return 0;
	}
	if (*a==0) {
	    return (1);
	}
	if (*b==0) {
	    return (-1);
	}
	if (tolower(*a)>tolower(*b)) {
	    return (-1);
	}
	if (tolower(*b)>tolower(*a)) {
	    return (1);
	}
	a++; b++;
    }
}

#endif /* NO_STRCASECMP */
