/**
 *
 * $Id: DebugUtil.h,v 1.3 1996/02/12 00:52:37 u27113 Exp $
 * 
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef XM_DEBUGUTIL_H
#define XM_DEBUGUTIL_H

#include <LTconfig.h>
#include <Xm/Xm.h>

#ifdef STDC_HEADERS
#include <stdarg.h>
#define Va_start(a,b) va_start(a,b)
#else /* ! STDC_HEADERS */
#include <varargs.h>
#define Va_start(a,b) va_start(a)
#endif

void XdbPrintTree(Widget w);
void XdbPrintCompleteTree(Widget w);
char *XdbGeometryResult2String(XtGeometryResult r);
char *XdbAttachment2String(int i);
void XdbDebug(char *fn, Widget w, char *fmt, ...);
void XdbDebug2(char *fn, Widget w, Widget c, char *fmt, ...);
void XdbDebug0(char *fn, Widget w, char *fmt, ...);

#ifdef	LESSTIF_PRODUCTION
#define	XdbInDebug(x, y)	False
#else
Boolean XdbInDebug(char *fn, Widget w);
#endif

#endif /* XM_DEBUGUTIL_H */
