/*
 *  cs_internal.h 1.8 1996/08/06 03:11:28 (David Hinds)
 */

#ifndef _LINUX_CS_INTERNAL_H
#define _LINUX_CS_INTERNAL_H

typedef struct erase_busy_t {
    eraseq_entry_t	*erase;
    client_handle_t	client;
    struct timer_list	timeout;
    struct erase_busy_t	*prev, *next;
} erase_busy_t;

#define ERASEQ_MAGIC	0xFA67
typedef struct eraseq_t {
    u_short		eraseq_magic;
    client_handle_t	handle;
    int			count;
    eraseq_entry_t	*entry;
} eraseq_t;

#define CLIENT_MAGIC 	0x51E6
typedef struct client_t {
    u_short		client_magic;
    socket_t		Socket;
    u_char		Function;
    dev_info_t		*dev_info;
    u_long		Attributes;
    u_long		state;
    u_long		EventMask, PendingEvents;
    int (*event_handler)(event_t event, int priority,
			 event_callback_args_t *);
    event_callback_args_t event_callback_args;
    struct client_t 	*next;
    u_long		mtd_count;
    struct wait_queue	*mtd_req;
    erase_busy_t	erase_busy;
} client_t;

/* Flags in client state */
#define CLIENT_CONFIG_LOCKED	0x001
#define CLIENT_IRQ_REQ		0x002
#define CLIENT_IO_REQ		0x004
#define CLIENT_UNBOUND		0x008
#define CLIENT_STALE		0x010
#define CLIENT_WIN_REQ(i)	(0x20<<(i))

typedef struct io_window_t {
    u_long		Attributes;
    ioaddr_t		BasePort, NumPorts;
    ioaddr_t		InUse, Config;
} io_window_t;

#define WINDOW_MAGIC	0xB35C
typedef struct window_t {
    u_short		magic;
    u_short		index;
    client_handle_t	handle;
    struct socket_info_t *sock;
    u_long		base;
    u_long		size;
    pcmcia_mem_map	ctl;
} window_t;

#define REGION_MAGIC	0xE3C9
typedef struct region_t {
    u_short		region_magic;
    u_short		state;
    dev_info_t		*dev_info;
    client_handle_t	mtd;
    u_long		MediaID;
    region_info_t	info;
} region_t;

#define REGION_STALE	0x01

/* Each card function gets one of these guys */
typedef struct config_t {
    u_long		state;
    u_long		Attributes;
    u_long		Vcc, Vpp1, Vpp2;
    u_long		IntType;
    u_long		ConfigBase;
    u_char		Status, Pin, Copy, Option, ExtStatus;
    u_long		Present;
    u_long		CardValues;
    io_req_t		io;
    struct {
	u_long		Attributes;
    } irq;
} config_t;

/* Maximum number of IO windows per socket */
#define MAX_IO_WIN 2

/* Maximum number of memory windows per socket */
#define MAX_WIN 4

/* The size of the CIS cache */
#define MAX_CIS_TABLE	64
#define MAX_CIS_DATA	512

typedef struct socket_info_t {
    ss_entry_t		ss_entry;
    u_int		sock;
    socket_state_t	socket;
    socket_cap_t	cap;
    u_long		state;
    u_short		functions;
    u_short		lock_count;
    client_handle_t	clients;
    client_handle_t	reset_handle;
    struct timer_list	setup, shutdown, unreset;
    u_long		unreset_timeout;
    pcmcia_mem_map	cis_mem;
    config_t		*config;
    struct {
	u_long		AssignedIRQ;
	u_long		Config;
    } irq;
    io_window_t		io[MAX_IO_WIN];
    window_t		win[MAX_WIN];
    region_t		*c_region, *a_region;
    struct wait_queue	*mtd_ready;
    erase_busy_t	erase_busy;
    int			cis_used;
    struct {
	long		addr;
	u_short		len;
	u_short		attr;
    }			cis_table[MAX_CIS_TABLE];
    char		cis_cache[MAX_CIS_DATA];
} socket_info_t;

/* Flags in config state */
#define CONFIG_LOCKED		0x01
#define CONFIG_IRQ_REQ		0x02
#define CONFIG_IO_REQ		0x04

/* Flags in socket state */
#define SOCKET_PRESENT		0x08
#define SOCKET_SETUP_PENDING	0x10
#define SOCKET_SHUTDOWN_PENDING	0x20
#define SOCKET_RESET_PENDING	0x40
#define SOCKET_SUSPEND		0x80
#define SOCKET_WIN_REQ(i)	(0x100<<(i))
#define SOCKET_IO_REQ(i)	(0x1000<<(i))
#define SOCKET_REGION_INFO	0x4000

#define CHECK_HANDLE(h) \
    (((h) == NULL) || ((h)->client_magic != CLIENT_MAGIC))

#define CHECK_SOCKET(s) \
    (((s) >= sockets) || (socket_table[s]->ss_entry == NULL))

#define SOCKET(h) (socket_table[(h)->Socket])
#define CONFIG(h) (&socket_table[(h)->Socket]->config[(h)->Function])

#define CHECK_REGION(r) \
    (((r) == NULL) || ((r)->region_magic != REGION_MAGIC))

#define CHECK_ERASEQ(q) \
    (((q) == NULL) || ((q)->eraseq_magic != ERASEQ_MAGIC))

#define EVENT(h, e, p) \
    ((h)->event_handler((e), (p), &(h)->event_callback_args))

#define MAX_SOCK 8
extern socket_t sockets;
extern socket_info_t *socket_table[MAX_SOCK];

#ifdef PCMCIA_DEBUG
extern int pc_debug;
#endif

#endif /* _LINUX_CS_INTERNAL_H */
