

/*
 * $Id: prfp.frag,v 1.8 96/01/11 12:56:35 abe Exp $
 */


/*
 * process_file() - process file
 */

void
process_file(fp)
	struct file *fp;		/* kernel file structure address */
{
	struct file f;
	int flag;

	if (kread((KA_T)fp, (char *)&f, sizeof(f))) {
		(void) sprintf(Namech, "can't read file struct from %#x", fp);
		enter_nm(Namech);
		return;
	}
	Lf->off = (unsigned long)f.f_offset;

	if (f.f_count) {

	/*
	 * Construct access code.
	 */
		if ((flag = (f.f_flag & (FREAD | FWRITE))) == FREAD)
			Lf->access = 'r';
		else if (flag == FWRITE)
			Lf->access = 'w';
		else if (flag == (FREAD | FWRITE))
			Lf->access = 'u';
	/*
	 * Process structure by its type.
	 */
		switch (f.f_type) {

#if	defined(DTYPE_GNODE)
		case DTYPE_GNODE:
#endif

#if	defined(DTYPE_INODE)
		case DTYPE_INODE:
#endif

#if	defined(DTYPE_PIPE)
		case DTYPE_PIPE:
#endif

#if	defined(DTYPE_PORT)
		case DTYPE_PORT:
#endif

#if	defined(DTYPE_VNODE)
		case DTYPE_VNODE:
#endif

			process_node(f.f_data);
			return;
		case DTYPE_SOCKET:
			process_socket((caddr_t)f.f_data);
			return;
		default:
			if (f.f_type != 0 || f.f_ops != NULL) {
				(void) sprintf(Namech,
					"%#x file struct, ty=%#x, op=%#x",
					fp, f.f_type, f.f_ops);
				enter_nm(Namech);
				return;
			}
		}
	}
	enter_nm("no more information");
}
