/* 
 * AFM ibmpc encoding.
 * Copyright (c) 1995 Markku Rossi.
 *
 * Author: Markku Rossi <mtr@iki.fi>
 */

/*
 * This file is part of the AFM library.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "afmint.h"

AFMEncodingTable afm_ibmpc_encoding[] =
{
  {0x00, AFM_ENC_NONE},
  {0x01, AFM_ENC_NON_EXISTENT},
  {0x02, AFM_ENC_NON_EXISTENT},
  {0x03, "heart"},
  {0x04, "diamond"},
  {0x05, "club"},
  {0x06, "spade"},
  {0x07, AFM_ENC_NONE},
  {0x08, AFM_ENC_NONE},
  {0x09, AFM_ENC_NONE},
  {0x0a, AFM_ENC_NONE},
  {0x0b, AFM_ENC_NONE},
  {0x0c, AFM_ENC_NONE},
  {0x0d, AFM_ENC_NONE},
  {0x0e, AFM_ENC_NONE},
  {0x0f, AFM_ENC_NONE},
  {0x10, AFM_ENC_NON_EXISTENT},
  {0x11, AFM_ENC_NON_EXISTENT},
  {0x12, AFM_ENC_NON_EXISTENT},
  {0x13, AFM_ENC_NON_EXISTENT},
  {0x14, "paragraph"},
  {0x15, "section"},
  {0x16, AFM_ENC_NON_EXISTENT},
  {0x17, AFM_ENC_NON_EXISTENT},
  {0x18, "arrowup"},
  {0x19, "arrowdown"},
  {0x1a, AFM_ENC_NONE},
  {0x1b, AFM_ENC_NONE},
  {0x1c, AFM_ENC_NON_EXISTENT},
  {0x1d, "arrowboth"},
  {0x1e, AFM_ENC_NON_EXISTENT},
  {0x1f, AFM_ENC_NON_EXISTENT},
  {0x20, "space"},
  {0x21, "exclam"},
  {0x22, "quotedbl"},
  {0x23, "numbersign"},
  {0x24, "dollar"},
  {0x25, "percent"},
  {0x26, "ampersand"},
  {0x27, "quoteright"},
  {0x28, "parenleft"},
  {0x29, "parenright"},
  {0x2a, "asterisk"},
  {0x2b, "plus"},
  {0x2c, "comma"},
  {0x2d, "minus"},
  {0x2e, "period"},
  {0x2f, "slash"},
  {0x30, "zero"},
  {0x31, "one"},
  {0x32, "two"},
  {0x33, "three"},
  {0x34, "four"},
  {0x35, "five"},
  {0x36, "six"},
  {0x37, "seven"},
  {0x38, "eight"},
  {0x39, "nine"},
  {0x3a, "colon"},
  {0x3b, "semicolon"},
  {0x3c, "less"},
  {0x3d, "equal"},
  {0x3e, "greater"},
  {0x3f, "question"},
  {0x40, "at"},
  {0x41, "A"},
  {0x42, "B"},
  {0x43, "C"},
  {0x44, "D"},
  {0x45, "E"},
  {0x46, "F"},
  {0x47, "G"},
  {0x48, "H"},
  {0x49, "I"},
  {0x4a, "J"},
  {0x4b, "K"},
  {0x4c, "L"},
  {0x4d, "M"},
  {0x4e, "N"},
  {0x4f, "O"},
  {0x50, "P"},
  {0x51, "Q"},
  {0x52, "R"},
  {0x53, "S"},
  {0x54, "T"},
  {0x55, "U"},
  {0x56, "V"},
  {0x57, "W"},
  {0x58, "X"},
  {0x59, "Y"},
  {0x5a, "Z"},
  {0x5b, "bracketleft"},
  {0x5c, "backslash"},
  {0x5d, "bracketright"},
  {0x5e, "asciicircum"},
  {0x5f, "underscore"},
  {0x60, "quoteleft"},
  {0x61, "a"},
  {0x62, "b"},
  {0x63, "c"},
  {0x64, "d"},
  {0x65, "e"},
  {0x66, "f"},
  {0x67, "g"},
  {0x68, "h"},
  {0x69, "i"},
  {0x6a, "j"},
  {0x6b, "k"},
  {0x6c, "l"},
  {0x6d, "m"},
  {0x6e, "n"},
  {0x6f, "o"},
  {0x70, "p"},
  {0x71, "q"},
  {0x72, "r"},
  {0x73, "s"},
  {0x74, "t"},
  {0x75, "u"},
  {0x76, "v"},
  {0x77, "w"},
  {0x78, "x"},
  {0x79, "y"},
  {0x7a, "z"},
  {0x7b, "braceleft"},
  {0x7c, "bar"},
  {0x7d, "braceright"},
  {0x7e, "tilde"},
  {0x7f, AFM_ENC_NON_EXISTENT},
  {0x80, "Ccedilla"},
  {0x81, "udieresis"},
  {0x82, "eacute"},
  {0x83, "acircumflex"},
  {0x84, "adieresis"},
  {0x85, "agrave"},
  {0x86, "aring"},
  {0x87, "ccedilla"},
  {0x88, "ecircumflex"},
  {0x89, "edieresis"},
  {0x8a, "egrave"},
  {0x8b, "idieresis"},
  {0x8c, "icircumflex"},
  {0x8d, "igrave"},
  {0x8e, "Adieresis"},
  {0x8f, "Aring"},
  {0x90, "Eacute"},
  {0x91, "ae"},
  {0x92, "AE"},
  {0x93, "ocircumflex"},
  {0x94, "odieresis"},
  {0x95, "ograve"},
  {0x96, "ucircumflex"},
  {0x97, "ugrave"},
  {0x98, "ydieresis"},
  {0x99, "Odieresis"},
  {0x9a, "Udieresis"},
  {0x9b, "cent"},
  {0x9c, "sterling"},
  {0x9d, "yen"},
  {0x9e, AFM_ENC_NON_EXISTENT},
  {0x9f, "florin"},
  {0xa0, "aacute"},
  {0xa1, "iacute"},
  {0xa2, "oacute"},
  {0xa3, "uacute"},
  {0xa4, "ntilde"},
  {0xa5, "Ntilde"},
  {0xa6, "ordfeminine"},
  {0xa7, "degree"},
  {0xa8, "questiondown"},
  {0xa9, AFM_ENC_NON_EXISTENT},
  {0xaa, "logicalnot"},
  {0xab, "onehalf"},
  {0xac, "onequarter"},
  {0xad, "exclamdown"},
  {0xae, "guillemotleft"},
  {0xaf, "guillemotright"},
  {0xb0, AFM_ENC_NON_EXISTENT},
  {0xb1, AFM_ENC_NON_EXISTENT},
  {0xb2, AFM_ENC_NON_EXISTENT},
  {0xb3, AFM_ENC_NON_EXISTENT},
  {0xb4, AFM_ENC_NON_EXISTENT},
  {0xb5, AFM_ENC_NON_EXISTENT},
  {0xb6, AFM_ENC_NON_EXISTENT},
  {0xb7, AFM_ENC_NON_EXISTENT},
  {0xb8, AFM_ENC_NON_EXISTENT},
  {0xb9, AFM_ENC_NON_EXISTENT},
  {0xba, AFM_ENC_NON_EXISTENT},
  {0xbb, AFM_ENC_NON_EXISTENT},
  {0xbc, AFM_ENC_NON_EXISTENT},
  {0xbd, AFM_ENC_NON_EXISTENT},
  {0xbe, AFM_ENC_NON_EXISTENT},
  {0xbf, AFM_ENC_NON_EXISTENT},
  {0xc0, AFM_ENC_NON_EXISTENT},
  {0xc1, AFM_ENC_NON_EXISTENT},
  {0xc2, AFM_ENC_NON_EXISTENT},
  {0xc3, AFM_ENC_NON_EXISTENT},
  {0xc4, AFM_ENC_NON_EXISTENT},
  {0xc5, AFM_ENC_NON_EXISTENT},
  {0xc6, AFM_ENC_NON_EXISTENT},
  {0xc7, AFM_ENC_NON_EXISTENT},
  {0xc8, AFM_ENC_NON_EXISTENT},
  {0xc9, AFM_ENC_NON_EXISTENT},
  {0xca, AFM_ENC_NON_EXISTENT},
  {0xcb, AFM_ENC_NON_EXISTENT},
  {0xcc, AFM_ENC_NON_EXISTENT},
  {0xcd, AFM_ENC_NON_EXISTENT},
  {0xce, AFM_ENC_NON_EXISTENT},
  {0xcf, AFM_ENC_NON_EXISTENT},
  {0xd0, AFM_ENC_NON_EXISTENT},
  {0xd1, AFM_ENC_NON_EXISTENT},
  {0xd2, AFM_ENC_NON_EXISTENT},
  {0xd3, AFM_ENC_NON_EXISTENT},
  {0xd4, AFM_ENC_NON_EXISTENT},
  {0xd5, AFM_ENC_NON_EXISTENT},
  {0xd6, AFM_ENC_NON_EXISTENT},
  {0xd7, AFM_ENC_NON_EXISTENT},
  {0xd8, AFM_ENC_NON_EXISTENT},
  {0xd9, AFM_ENC_NON_EXISTENT},
  {0xda, AFM_ENC_NON_EXISTENT},
  {0xdb, AFM_ENC_NON_EXISTENT},
  {0xdc, AFM_ENC_NON_EXISTENT},
  {0xdd, AFM_ENC_NON_EXISTENT},
  {0xde, AFM_ENC_NON_EXISTENT},
  {0xdf, AFM_ENC_NON_EXISTENT},
  {0xe0, "alpha"},
  {0xe1, "germandbls"},
  {0xe2, "Gamma"},
  {0xe3, "pi"},
  {0xe4, "Sigma"},
  {0xe5, "sigma"},
  {0xe6, "mu"},
  {0xe7, "tau"},
  {0xe8, "phi"},
  {0xe9, "theta"},
  {0xea, "Omega"},
  {0xeb, "delta"},
  {0xec, "infinity"},
  {0xed, "oslash"},
  {0xee, "epsilon"},
  {0xef, "intersection"},
  {0xf0, "equivalence"},
  {0xf1, "plusminus"},
  {0xf2, "greaterequal"},
  {0xf3, "lessequal"},
  {0xf4, "integraltp"},
  {0xf5, "integralbt"},
  {0xf6, "divide"},
  {0xf7, "approxequal"},
  {0xf8, "degree"},
  {0xf9, "dotaccent"},
  {0xfa, "dotaccent"},
  {0xfb, "radical"},
  {0xfc, AFM_ENC_NON_EXISTENT},
  {0xfd, "twosuperior"},
  {0xfe, AFM_ENC_NON_EXISTENT},
  {0xff, AFM_ENC_NON_EXISTENT},
  {-1,   NULL},
};
