// -*- C++ -*-
/*
	figinset.h - Figure inset header - part of LyX project
	(C)1996 by Ivan Schreter
*/

#ifndef _FIGINSET_H
#define _FIGINSET_H

#include "form1.h"
#include "buffer.h"


/* the rest is figure stuff */

struct Figref;

class InsetFig: public Inset {
private:
   
public:
  FD_Figure *form;	/* form for user input */
  int wid, hgh;		/* width and height in pixels on screen */

  int pswid, pshgh;	/* width and height in postscript units (1/72 inch) */
  int psx, psy;		/* x and y coordinate in ps units */

  char *fname;		/* .eps file name */
  bool changedfname;	/* changed filename -> for recompute */
  int wtype, htype;	/* width and height types: 0-default, 1-cm, 2-in, 3-%of page */
  float xwid, xhgh;	/* width and height */
  float angle;		/* rotation angle */
  char *cmd;		/* epsfig command, latex version */
  char *extra;		/* extra epsfig parameters */
  char *label;		/* figure label */
  int flags;		/* various flags */
  Figref *figure;	/* figure reference */
  int twtype, thtype;	/* temporary w and h type */
  int pflags;		/* temporary flags */

  Buffer *cbuffer;	/* buffer, where this figure is on */

  ~InsetFig();
  InsetFig(int tmpx, int tmpy);
  int Ascent(LyXFont font);
  int Descent(LyXFont font);
  int Width(LyXFont font);
  void Draw(LyXFont font, unsigned long  pm, int baseline, float &x);
  void Write(FILE *file);
  void Read(FILE *file);
  int Latex(FILE *file);
  void Edit(int, int);
  char Editable();
  char Deletable();
  char LyxCode();
  Inset* Clone();

  void CallbackFig(long arg);
  void Preview(const char *p);
  void BrowseFile();	/* browse for file */

private:
  void RestoreForm();	/* restore values on the form */
  void Recompute();	/* recompute screen params */
  void Regenerate();	/* regenerate \epsfig{} command */
  void TempRegenerate();/* regenerate \epsfig{} command in temporary buffer */
  void GetPSSizes();	/* get sizes from .eps file */
};

struct figdata {
	Pixmap bitmap;	/* bitmap data */
	int ref;	/* reference count for this bitmap */
	int wid, hgh;	/* width and height on screen */
	char *fname;	/* pointer to file name */
	char flags;	/* type; 0-none, 1-B/W, 2-Grayscale, 3-Color */
	bool reading;	/* reading request is pending on this figure */
	bool broken;	/* could not read it, because it's broken */
	bool gsdone;	/* when gs was killed, this says that image is ok */
	int gspid;	/* gs pid for reading */
};

struct Figref {
	figdata *data;	/* figure data (image) */
	InsetFig *inset;/* inset of this figure */
};

#endif
