// -*- C++ -*-
/* This file is part of
 * ======================================================
 * 
 *           LyX, the High Level Word Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *
 *======================================================*/
#ifndef _DEFINITIONS_H
#define _DEFINITIONS_H

// This defines the different debug levels. They can be used almost
// as you want them. Max debug level is still (1 << 16).
// Add debugging levels as necessary. To use several debugging levels
// at once, just add the values together. ex. level 10 is INIT and TOOLBAR.
enum debug_levels {
	DEBUG_INFO =       (1),        // 1
	DEBUG_INIT =       (1 << 1),   // 2
	DEBUG_KEY =        (1 << 2),   // 4
	DEBUG_TOOLBAR =    (1 << 3),   // 8
	DEBUG_LEX_PARSER = (1 << 4),   // 16
	DEBUG_LYXRC =      (1 << 5),   // 32
	DEBUG_ALL =        (65535)     // 2^16-1
};
extern debug_levels lyx_debug_level;

#include "config.h"
#include "lyxfont.h"
#include <stdio.h>

#define LYX_UNCHANGED 0
#define LYX_NEED_LITTLE_REFRESH 1
#define LYX_NEED_MORE_REFRESH 2
#define LYX_NEED_VERY_LITTLE_REFRESH 3

/* the footnoteflag */ 
#define LYX_NO_FOOTNOTE 0
#define LYX_OPEN_FOOTNOTE 1
#define LYX_CLOSED_FOOTNOTE 2

/* the footnotekinds */ 
#define LYX_FOOTNOTE 0
#define LYX_MARGIN 1
#define LYX_FIG 2
#define LYX_TAB 3

// #define LYX_ROMAN_FAMILY 0
// #define LYX_SANS_FAMILY 1
// #define LYX_TYPEWRITER_FAMILY 2
// #define LYX_MODERN_FAMILY 3	       /* obsolete */
// #define LYX_SYMBOL_FAMILY 4

enum font_family {
	LYX_ROMAN_FAMILY      = 0,
	LYX_SANS_FAMILY       = 1,
	LYX_TYPEWRITER_FAMILY = 2,
	LYX_MODERN_FAMILY     = 3,	       /* obsolete */
	LYX_SYMBOL_FAMILY     = 4
};

// #define LYX_MEDIUM_SERIES 0
// #define LYX_BOLD_SERIES 1
// #define LYX_UP_SHAPE 0
// #define LYX_ITALIC_SHAPE 1
// #define LYX_SMALLCAPS_SHAPE 2
// #define LYX_NO_FONT_CHANGE 98
// #define LYX_LAYOUT_DEFAULT 99

enum font_series {
	LYX_MEDIUM_SERIES = 0,
	LYX_BOLD_SERIES   = 1
};

enum font_shape {
	LYX_UP_SHAPE        = 0,
	LYX_ITALIC_SHAPE    = 1,
	LYX_SMALLCAPS_SHAPE = 2
};

enum { // no good name for this
	LYX_NO_FONT_CHANGE = 98,
	LYX_LAYOUT_DEFAULT = 99
};

// #define LYX_SIZE_TINY 0
// #define LYX_SIZE_SMALL 1
// #define LYX_SIZE_NORMAL 2
// #define LYX_SIZE_LARGE 3
// #define LYX_SIZE_LARGER 4
// #define LYX_SIZE_LARGEST 5
// #define LYX_SIZE_HUGE 6
// #define LYX_SIZE_GIANT 7

enum font_size {
	LYX_SIZE_TINY    = 0,
	LYX_SIZE_SMALL   = 1,
	LYX_SIZE_NORMAL  = 2,
	LYX_SIZE_LARGE   = 3,
	LYX_SIZE_LARGER  = 4,
	LYX_SIZE_LARGEST = 5,
	LYX_SIZE_HUGE    = 6,
	LYX_SIZE_GIANT   = 7
};

// #define LYX_NO_BAR 0
// #define LYX_UNDER_BAR 1

enum font_bar {
	LYX_NO_BAR = 0,
	LYX_UNDER_BAR = 1
};

#define LYX_NO_LATEX 0
#define LYX_LATEX 1
#define LYX_FORMULA_LATEX 2
#define LYX_PROTECTED_LATEX 3 // unused ?!
#define LYX_PROTECTED_FORMULA_LATEX 4 // unused ?!  Matthias

#define LYX_SMALL_ZOOM 0
#define LYX_NORMAL_ZOOM 1
#define LYX_LARGE_ZOOM 2

#define LYX_META_FOOTNOTE 1
#define LYX_META_MARGIN 2
#define LYX_META_FIG 3
#define LYX_META_TAB 4
#define LYX_META_HFILL 5
#define LYX_META_NEWLINE 6
#define LYX_META_PROTECTED_SEPARATOR 7
#define LYX_META_INSET 8

#define LYX_ALIGN_BLOCK 1
#define LYX_ALIGN_LEFT 2
#define LYX_ALIGN_RIGHT 4
#define LYX_ALIGN_CENTER 8
#define LYX_ALIGN_FORMULA 16
#define LYX_ALIGN_LAYOUT 32

#define LYX_DUMMY_LAYOUT 99


#define LYX_PARSEP_INDENT 0
#define LYX_PARSEP_SKIP 1


#define PAPER_A4PAPER 0
#define PAPER_A4 1
#define PAPER_A4WIDE 2
#define PAPER_WIDEMARGINSA4 3
#define PAPER_USLETTER 4
#define PAPER_A5PAPER 5
#define PAPER_B5PAPER 6
#define PAPER_EXECUTIVEPAPER 7
#define PAPER_LEGALPAPER 8

#define MODE_FINAL 0
#define MODE_DRAFT 1

#define ORIENTATION_PORTRAIT 0
#define ORIENTATION_LANDSCAPE 1

#define PAGESTYLE_PLAIN 0
#define PAGESTYLE_HEADINGS 1
#define PAGESTYLE_EMPTY 2

#define GERMAN 0
#define ENGLISH 1
#define FRENCH 2

/* LyX code for Insets */
#define LYX_NO_CODE 0
#define LYX_TOC_CODE 1
#define LYX_QUOTE_CODE 2
#define LYX_MARK_CODE 3
#define LYX_REF_CODE 4
#define LYX_URL_CODE 5
#define LYX_HTMLURL_CODE 6
#define LYX_SEPARATOR_CODE 7
#define LYX_ENDING_CODE 8
#define LYX_LABEL_CODE 9
#define LYX_IGNORE_CODE 10
#define LYX_ACCENT_CODE 11
#define LYX_MATH_CODE 12

void SetZoom(char new_zoom);
char GetZoom();

/* load a style-file, still VERY dump */ 
void LyXSetStyle(const char *path);

char* date();


/*
 * Inlined Functions
 */

inline
int Maximum(int a, int b)
{
#ifdef __GNUG__
	return (a >? b);
#else
	return ((a>b) ? a : b);
#endif
}


inline
int Minimum(int a, int b)
{
#ifdef __GNUG__
	return (a <? b);
#else
	return ((a<b) ? a : b);
#endif
}


inline
bool StringEqual(const char* a, const char* b)
{
	int i;
	if (a == b) return true;
	
	if (!a || !b) return false;
	
	for (i=0;a[i] && b[i] && a[i]==b[i];i++);
	
	return (a[i]==b[i]);
}


inline
char* StringCopy(const char* a)
{
	if (!a) return NULL;

	int i,n;
	for (n=0; a[n]; n++);
	char* new_string = new char[n+2];
	for (i=0; i<=n; i++)
		new_string[i] = a[i];
	return new_string;
}


inline
char* StringReplace (char *b, const char* a)
//a function to delete b and retrun a new string to replace it
//we should really have a string class but that's too slow
{
	//if (!a) return NULL; // then b will not be deleted

	if (b) delete b;
	// but how should we delete it? Can we assume
	// that StringCopy has been used?

        return StringCopy(a);
}
#endif
