#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/Notice.tcl,v $
# $Date: 1996/03/21 13:02:18 $
# $Revision: 1.16.1.13 $
#
set defNotice {}
#
proc Notice {name args} {
    if [string match {::} $name] {
	set op [lindex $args 0]
	if {[info procs Notice_$op] != {}} {
	    return [eval Notice_$op [lrange $args 1 end] ]
	}
	return [eval Channel_$op [lrange $args 1 end] ]
    }
    if {[set id [Notice :: find $name]] == {nil}} { set id [makeNotice $name] }
    if {$args != {}} { eval $id configure $args }
    return $id
}
#
proc notice_call {this op args} {
    switch $op {
    default {
	    if {[info procs notice_$op] == {}} {
		eval channel_call $this $op $args
	    } {
		eval notice_$op $this $args
	    }
	}
    }
}
#
proc makeNotice {chan} {
    global NTO defNotice defChan
    set this [objName Notice]
    proc $this {args} " eval notice_call $this \$args "
    initObj $this Channel
    set lchan [string tolower $chan]
    upvar #0 $this ndata
    if {$lchan != {*default*}} { [User :: make $lchan] join $this }
    if [string match {} [set def $defNotice]] {
	set def $defChan
	set b 0
	set d 0
    } {
	set b [$def buttons]
	set d [$def draw]
    }
    array set ndata [uplevel #0 array get $def]
    set ndata(keep) 0
    set ndata(buttons) $b
    set ndata(draw) $d
    set ndata(name) $chan
    set ndata(lname) $lchan
    set NTO($lchan) $this
    return $this
}
#
proc notice_delete {this} { mcnDelete $this NTO }
#
proc Notice_make {nk} {
    global NTO
    set usr [User :: make $nk]
    set ln [string tolower $nk]
    if [info exists NTO($ln)] { set id $NTO($ln) } { set id [Notice $nk] }
    $id configure -crypt [$usr crypt]
    $id show -nofocus
    $id addUser $usr 0 0
    return $id
}
#
proc Notice_find {nk} {
    global NTO
    set ln [string tolower $nk]
    return [expr {[info exists NTO($ln)] ? $NTO($ln) : {nil}}]
}
#
proc Notice_save {desc} {
    global defNotice
    $defNotice save $desc
}
#
proc notice_save {this desc} {
    global defNotice
    set ln [mncSave $this $desc $defNotice]
    foreach op {logfile icon} {
	if {[set v [$this $op]] != {}} { append ln " -$op {$v}"	}
    }
    puts $desc $ln
    foreach  b [$this bindings] {
	puts $desc "zbind [$this name] [lindex $b 0] {[lindex $b 1]}"
    }
}
