package autoupdate::general;  # $Date: 2003/06/12 $

use strict;
# warnings causes problems under 5.005
#use warnings;
use POSIX;

BEGIN {
	use Exporter   ();
	use vars qw($VERSION $DEBUG @ISA @EXPORT @EXPORT_OK);

	# set the version for version checking
	$VERSION     = "1.0.1";
	@ISA         = qw(Exporter);
	@EXPORT      = qw( VersionCompare IsElement Strip_Dir );
	@EXPORT_OK   = qw();
}
END {};

###############################
# Compares two version strings
###############################

sub VersionCompare
{
	my $a= shift;
	my $b= shift;

	return 0 if ($a eq $b);

	# Rename pre1.0 -> 1.0pre
	if ( $a =~ /^pre(.+)$/) {
		$a= $1 . "pre";
	}
	if ( $b =~ /^pre(.+)$/) {
		$b= $1 . "pre";
	}

	# Split off equal parts first
	my ($a1,$b1);
	while ($a ne "" and $b ne "") {
		($a1,$b1)= ("","");
		if ($a =~ /^(\d+)(.*)$/) {
			$a = $2;
			$a1 = $1;
		}
		if ($b =~ /^(\d+)(.*)$/) {
			$b = $2;
			$b1 = $1;
		}
		unless ($a1 eq $b1) {
			$a= $a1 . $a;
			$b= $b1 . $b;
			last;
		}
		($a1,$b1)= ("","");
		if ($a =~ /^(\D+)(.*)$/) {
			$a = $2;
			$a1 = $1;
		}
		if ($b =~ /^(\D+)(.*)$/) {
			$b = $2;
			$b1 = $1;
		}
		unless ($a1 eq $b1) {
			$a= $a1 . $a;
			$b= $b1 . $b;
			last;
		}
	}


	# Split off everything after a dot
	if ( $a=~/^([^.]+)/ ) {
		$a= $1;
	}
	if ( $b=~/^([^.]+)/ ) {
		$b= $1;
	}
	# Treat the case if first char is a dot
	if ( $a=~/^\.(.*)$/) {
		return 1;
	}
	if ( $b=~/^\.(.*)$/) {
		return -1;
	}

	# Now do the actual comparison

	($a1,$b1)= ("", "");
	# First compare the numeric part
	if ( $a=~/^(\d+)(.*)$/ ) {
		($a1, $a)= ($1, $2);
	}
	if ( $b=~/^(\d+)(.*)$/ ) {
		($b1, $b)= ($1, $2);
	}

	if (("$a1$b1" ne '') and ($a1 ne $b1)) {
		# 0 is newer than a
		if ( ($a1 eq '') and ($b1 ne '') ) { return -1; };
		if ( ($a1 ne '') and ($b1 eq '') ) { return 1; };
		# 1 is newer than 01
		if ($a1 =~ /^0/ or $b1 =~ /^0/) {
			if ($a1 ne $b1) { return ($a1 cmp $b1); }
		}
		# standard case
		return ($a1 <=> $b1);
	}

	# Now compare the non-numeric part
	($a1,$b1)= ("", "");
	if ( $a=~/^(\D+)(.*)$/ ) {
		($a1, $a)= ($1, $2);
	}
	if ( $b=~/^(\D+)(.*)$/ ) {
		($b1, $b)= ($1, $2);
	}
	$a1 =~ s/[_-](pre|alpha|beta|rc|final)/$1/i;
	$b1 =~ s/[_-](pre|alpha|beta|rc|final)/$1/i;
	$a1 =~ s/final//i;
	$b1 =~ s/final//i;

	# 1.0xxx is newer than 1.0alpha
	if ( $b1 =~/^alpha/i ) { return 1 };
	if ( $a1 =~/^alpha/i ) { return -1 };
	# 1.0xxx is newer than 1.0beta
	if ( $b1 =~/^beta/i ) { return 1 };
	if ( $a1 =~/^beta/i ) { return -1 };
	# 1.0xxx is newer than 1.0pre
	if ( $b1 =~/^pre/i ) { return 1 };
	if ( $a1 =~/^pre/i ) { return -1 };
	# 1.0xxx is newer than 1.0rc
	if ( $b1 =~/^rc/i ) { return 1 };
	if ( $a1 =~/^rc/i ) { return -1 };


	# 1.0 is newer than 1.0a1
	if ( ($a1 eq '') and ("$b1$b"=~/^[ab]\d/i) ) { return 1 };
	if ( ("$a1$a"=~/^[ab]\d/i) and ($b1 eq '') ) { return -1 };
	# 1.0a is newer than 1.0
	if ( ($a1 eq '') and ($b1 ne '') ) { return -1 };
	if ( ($a1 ne '') and ($b1 eq '') ) { return 1 };

	# otherwise try regular string comparison
	return ($a1 cmp $b1);
}

###############################
# Checks if item is in an array
###############################

sub IsElement
{
	my $element= shift;
	foreach my $item (@_) {
		return 1 if ($item eq $element);
	}
	return 0;
}

######################
# Strips unwanted stuff from a directory
######################

sub Strip_Dir
{
	my $old;
	do {
		$old=$_[0];
		$_[0] =~ s/\/[^\/]+\/\.\.$//g;
		$_[0] =~ s/^[^\/]+\/\.\.$/./g;
		$_[0] =~ s/\/[^\/]+\/\.\.\//\//g;
		$_[0] =~ s/\/\.?\//\//g;
		$_[0] =~ s/^\/\.\.\//\//g;
	} while ($_[0] ne $old);
	# Strip / from end if second argument is present
	if ($_[1] and $_[0] =~ /^(.*)\/\.?$/) {
		$_[0] = $1;
	}
}

1;

__END__

=head1 NAME

autoupdate::general

=head1 SYNOPSIS

 &IsElement($item, @array)
 &StripDir($path [, 1])

=head1 DESCRIPTION

This package contains some subs used by autoupdate.

=head1 FUNCTIONS

 &VersionCompare($va, $vb)  Compares two version strings. Returns -1, 0, or 1 depending on
                            whether $va is oder than, equal to, or newer than $vb.
 &IsElement($item, @array)  Tests if $item is element of @array.
 &StripDir($path)           Strips unwanted stuff from a directory.
 &StripDir($path, 1)        Strip also / from end.

=head1 SEE ALSO

autoupdate(8)

=head1 AUTHOR

Gerald Teschl

=head1 LICENSE

GPL

=cut
