#!/bin/sh
# Try to figure out the version of linux we are using.
# Takes no arguments and outputs the version of the
# linux distribution.

# If we have lsb_release, use it
[ -x /usr/bin/lsb_release -o -x /bin/lsb_release ] && exec lsb_release -sr

# Safe fallback
for dist in redhat-release fedora-release mandrake-release turbolinux-release linuxppc-release yellowdog-release aurora-release redhat-release-as redhat-release-aw redhat-release-es redhat-release-ws 
do
	if rpm -q $dist >/dev/null 2>&1
	then
		rpm -q --queryformat "%{version}\n" $dist
		exit 0
	fi
done

if [ -f /etc/SuSE-release ]
then
	# SuSE
	egrep -i "^VERSION =" /etc/SuSE-release |cut -d" " -f3
	exit 0
fi

if [ -f /etc/.issue ]
then
	# Caldera
	egrep -i "^Version " /etc/.issue |cut -d" " -f2
	exit 0
fi

echo 0
exit 1
