#!/bin/sh
# Try to figure out the version of linux we are using.
# Takes no arguments and outputs the version of the
# linux distribution.

# If we have lsb_release, use it
[ -x /usr/bin/lsb_release -o -x /bin/lsb_release ] && exec lsb_release -si

# Safe fallback
for dist in Fedora-release Mandrake-release TurboLinux-release Linuxppc-release YellowDog-release Aurora-release RedHat-release-as RedHat-release-aw RedHat-release-es RedHat-release-ws RedHat-release 
do
	distlc=`echo $dist| tr A-Z a-z`
	if [ -f /etc/$distlc ]
	then
		echo $dist | sed 's/-release//'
		exit 0
	fi
done

if [ -f /etc/SuSE-release ]
then
	echo SuSE
	exit 0
elif [ -f /etc/.issue ]
then
	echo Caldera
	exit 0
fi

echo "unknown"
exit 1
