<?php
/**
 * Class to set a vacation notice via ftp.
 */
 
    class vacation {

    /** file pointer to the tmp file we create containing the forwarding
        and/or vacation message information */
    var $fp;

    /** The error string returned to the user if an error occurs. */
    var $err_str;

/**
 *
 * Create a temporary file and write some data to it.
 *
 * @param   $contents    What to write into the file.
 *
 * @return  mixed        False if file creation failed for any reason,
 *                       the file specification created on success.
 */

function write_temp_file($contents)
{

        $conf = &$GLOBALS['conf'];

        $oldUmask = umask(0077);
        $myTempFile = tempnam(@$conf['tmpdir'], "vacation");

        if ($myTempFile == false) {
            $this->err_str = _("tempnam() failed!");
            return false;
        } 
        if (!($fileHandle = fopen($myTempFile, "w"))) {
            $this->err_str = _("Could not create file");
            return false;
        }
        if (!(fputs($fileHandle, $contents))) {
            $this->err_str = _("Could not write to file");
            return false;
        }
        fclose($fileHandle);
        umask($oldUmask);
        return $myTempFile;
}

/**
 * Delete a file via ftp.
 *
 * @param   $user    The username to login as via ftp.
 * @param   $realm   The realm (domain) of the user if any.
 * @param   $pass    The password to login with via ftp.
 * @param   $file    The file specification to delete on the remote machine.
 *
 * @return  boolean  True or False depending on the success of the delete.
 */

function ftp_delete_file($user, $realm, $pass, $file)
{
        if (!($ftpConnection = @ftp_connect($this->get_server($realm),
                                            $this->get_port($realm)))) {
            $this->err_str = _("Server connection failed");
            return false;
        }

        if (!(@ftp_login($ftpConnection, $user, $pass))) {
            $this->err_str = _("Could not login - check password!");
            @ftp_quit($ftpConnection);
            return false;
        }
        // should probably do a cwd to their home, but we don't...
        //ftp_chdir($ftpConnection, "/home/eric/");
        if (!(@ftp_delete($ftpConnection, $file))) {
            $this->err_str = "Error deleting $file file -- Maybe you didn't have a vacation notice installed?";
            @ftp_quit($ftpConnection);
            return false;
        }
        @ftp_quit($ftpConnection);
        return true;
}

/**
 * Copy a file between two machines via ftp.
 *
 * @param   $user    The username to login as via ftp.
 * @param   $realm   The realm (domain) of the user if any.
 * @param   $pass    The password to login with via ftp.
 * @param   $src     The source file specification to copy.
 * @param   $dst     The destination file specification to write.
 * @param   $mode    The ftp transfer mode (binary or text).
 *
 * @return  boolean  True or False depending on success of the copy.
 */

function ftp_copy_file($user, $realm, $pass, $src, $dst, $mode=FTP_ASCII)
{
        if (!($ftpConnection = @ftp_connect($this->get_server($realm),
                                            $this->get_port($realm)))) {
            $this->err_str = _("Server connection failed");
            return false;
        }

        if (!(@ftp_login($ftpConnection, $user, $pass))) {
            $this->err_str = _("Could not login -- check password!");
            @ftp_quit($ftpConnection);
            return false;
        }
        // should probably do a cwd to their home, but we don't...
        //ftp_chdir($ftpConnection, "/home/eric/");
        // ftp_put won't overwrite existing file, so nuke it unconditionally
        @ftp_delete($ftpConnection, $dst);
        if (!(@ftp_put($ftpConnection, $dst, $src, $mode))) {
            $this->err_str = _("Could not set forwarding!");
            @ftp_quit($ftpConnection);
            return false;
        }
        @ftp_quit($ftpConnection);
        return true;
}

/**
 * Get the server name for a particular realm from the config variables.
 *
 * @param   $realm     The realm for which to get the server.
 *
 * @return  string     The server address for the passed or default realm.
 */


     function get_server($realm) {
         $conf = &$GLOBALS['conf'];
         $server = @$conf['server']['default']['host'];
         if ( isset($realm) && $realm != "" ) {
            if (isset($conf['server'][$realm]['host']) )
               $server = $conf['server'][$realm]['host'];
         }
         if ( $server == "") {
            $this->err_str = _("Warning: Module not properly configured! Assuming localhost");
            $server = "localhost";
         }
        return $server;
     }

/**
 * Get the server port number for a particular realm from the config variables.
 *
 * @param   $realm     The realm for which to get the server port.
 *
 * @return  string     The server port for the passed or default realm.
 */

     function get_port($realm) {
         $conf = &$GLOBALS['conf'];
         $port = @$conf['server']['default']['port'];
         if ( isset($realm) && $realm != "" ) {
            if (isset($conf['server'][$realm]['port']) )
               $port = $conf['server'][$realm]['port'];
         }
         if ( $port == "") {
            $port = "21";
         }
        return $port;
     }


/**
 * Set the vacation notice up.
 */

    function set_vacation($user, $realm, $pass, $message) {
        $conf = &$GLOBALS['conf'];
        $myFile = $this->write_temp_file($message);
        if (!file_exists($myFile)) return false;
        $status = $this->ftp_copy_file($user, $realm, $pass, $myFile, ".vacation.msg");
        unlink($myFile);
        if (!$status) return false;
        if (! $this->ftp_copy_file($user, $realm, $pass, "/dev/null", ".vacation.pag") )
             return false;
        if (! $this->ftp_copy_file($user, $realm, $pass, "/dev/null", ".vacation.dir") )
             return false;
        if (! $this->ftp_copy_file($user, $realm, $pass, "/dev/null", ".vacation.db") )
             return false;
        $myFile = $this->write_temp_file("\\$user, \"|" . $conf['vacation']['path'] . " $user\"");
        if (!file_exists($myFile)) return false;
        if (! $this->ftp_copy_file($user, $realm, $pass, $myFile, ".forward") )
             return false;
        unlink($myFile);
        return true;
    }

/**
 * Remove any existing vacation notices.
 */

    function unset_vacation($user, $realm, $pass) {
        if (! $this->ftp_delete_file($user, $realm, $pass, ".forward") )
             return false;
        if (! $this->ftp_delete_file($user, $realm, $pass, ".vacation.msg") ) 
            return false;
        // we could, but don't, check for errors on these...
        // they are more-or-less harmless without the above two files...
        $this->ftp_delete_file($user, $realm, $pass, ".vacation.pag");
        $this->ftp_delete_file($user, $realm, $pass, ".vacation.dir");
        $this->ftp_delete_file($user, $realm, $pass, ".vacation.db");
        return true;
    }

}

?>
