<?php
/* $Horde: vacation/lib/Driver/forwards.php,v 1.5.2.1 2002/10/09 05:34:58 ericr Exp $
 *
 * Vacation_Driver_forwards:: implements the Vacation_Driver API for ftp driven
 * dot-forward compliant mail servers.
 *
 * @author  Eric Rostetter <eric.rostetter@physics.utexas.edu>
 * @version $Revision: 1.5.2.1 $
 * @package Vacation
 */

class Vacation_Driver_forwards extends Vacation_Driver {

    /** file pointer to the tmp file we create containing the forwarding
        and/or vacation message information */
    var $fp;

    /** The error string returned to the user if an error occurs. */
    var $err_str;

    /** Hash containing configuration data. */
    var $params;

/**
 * Constructs a new ftp dot-forward Vacation_Driber object.
 *
 * @param array  $params    A hash containing connection parameters.
 */
function Vacation_Driver_forwards($params = array())
{
    $this->params = $params;
}


/**
 *
 * Create a temporary file and write some data to it.
 *
 * @param   $contents    What to write into the file.
 *
 * @return  mixed        False if file creation failed for any reason,
 *                       the file specification created on success.
 */

function _writeTempFile($contents)
{
        $conf = &$GLOBALS['conf'];

        $oldUmask = umask(0077);
        $myTempFile = tempnam(@$conf['tmpdir'], "vacation");

        if ($myTempFile == false) {
            $this->err_str = _("tempnam() failed!");
            return false;
        }
        if (!($fileHandle = fopen($myTempFile, "w"))) {
            $this->err_str = _("Could not create file");
            return false;
        }
        if (!(fputs($fileHandle, $contents))) {
            $this->err_str = _("Could not write to file");
            return false;
        }
        fclose($fileHandle);
        umask($oldUmask);
        return $myTempFile;
}

/**
 * Delete a file via ftp.
 *
 * @param   $user    The username to login as via ftp.
 * @param   $realm   The realm (domain) of the user if any.
 * @param   $pass    The password to login with via ftp.
 * @param   $file    The file specification to delete on the remote machine.
 *
 * @return  boolean  True or False depending on the success of the delete.
 */

function _ftpDelete($user, $realm, $pass, $file)
{
        if (!($ftpConnection = @ftp_connect($this->params[$realm]['host'],
                                            $this->params[$realm]['port']))) {
            $this->err_str = _("Server connection failed");
            return false;
        }

        if (!(@ftp_login($ftpConnection, $user, $pass))) {
            $this->err_str = _("Could not login - check password!");
            @ftp_quit($ftpConnection);
            return false;
        }
        // should probably do a cwd to their home, but we don't...
        //ftp_chdir($ftpConnection, "/home/eric/");
        if (!(@ftp_delete($ftpConnection, $file))) {
            $this->err_str = "Error deleting $file file -- Maybe you didn't have a vacation notice installed?";
            @ftp_quit($ftpConnection);
            return false;
        }
        @ftp_quit($ftpConnection);
        return true;
}

/**
 * Copy a file between two machines via ftp.
 *
 * @param   $user    The username to login as via ftp.
 * @param   $realm   The realm (domain) of the user if any.
 * @param   $pass    The password to login with via ftp.
 * @param   $src     The source file specification to copy.
 * @param   $dst     The destination file specification to write.
 * @param   $mode    The ftp transfer mode (binary or text).
 *
 * @return  boolean  True or False depending on success of the copy.
 */

function _ftpCopy($user, $realm, $pass, $src, $dst, $mode=FTP_ASCII)
{
        if (!($ftpConnection = @ftp_connect($this->params[$realm]['host'],
                                            $this->params[$realm]['port']))) {
            $this->err_str = _("Server connection failed");
            return false;
        }

        if (!(@ftp_login($ftpConnection, $user, $pass))) {
            $this->err_str = _("Could not login -- check password!");
            @ftp_quit($ftpConnection);
            return false;
        }
        // should probably do a cwd to their home, but we don't...
        //ftp_chdir($ftpConnection, "/home/eric/");
        // ftp_put won't overwrite existing file, so nuke it unconditionally
        @ftp_delete($ftpConnection, $dst);
        if (!(@ftp_put($ftpConnection, $dst, $src, $mode))) {
            $this->err_str = _("Could not set forwarding!");
            @ftp_quit($ftpConnection);
            return false;
        }
        @ftp_quit($ftpConnection);
        return true;
}

/**
 * Check if the realm has a specific configuration.  If not, try to fall
 * back on the default configuration.  If still not a valid configuration
 * then exit with an error.
 *
 * @param string    $realm      The realm of the user, or "default" if none.
 *                              Note: passed by reference so we can change
 *                              it's value!
 *
 */

function check_config(&$realm) {

    // If no realm passed in, or no host config for the realm passed in,
    // then we fall back to the default realm

    if ( empty($realm) || empty($this->params[$realm]['host']) ) {
       $realm = "default";
    }

    // If still no host/port, then we have a misconfigured module
    if (empty($this->params[$realm]['host']) ||
        empty($this->params[$realm]['port']) ) {
            $this->err_str = _("The module is not properly configured!");
            return false;
    }
    return true;
}

/**
 * Set the vacation notice up.
 * @param string    $user       The username to enable vacation for.
 * @param string    $realm      The realm of the user.
 * @param string    $target     The message to install.
 * @return boolean  Returns true on success, false on error.
 */

    function set_vacation($user, $realm, $pass, $message) {
        if (!$this->check_config($realm)) return false;

        $conf = &$GLOBALS['conf'];
        $dbfile = VACATION_BASE . "/files/empty." .
                  $this->params['dbtype'] . ".bin";

        $myFile = $this->_writeTempFile($message);
        if (!file_exists($myFile)) return false;
        $status = $this->_ftpCopy($user, $realm, $pass, $myFile,
                ".vacation.msg", FTP_ASCII);
        unlink($myFile);
        if (!$status) return false;
        if (! $this->_ftpCopy($user, $realm, $pass, $dbfile,
                ".vacation.pag", FTP_BINARY) )
             return false;
        if (! $this->_ftpCopy($user, $realm, $pass, $dbfile,
                ".vacation.dir", FTP_BINARY) )
             return false;
        if (! $this->_ftpCopy($user, $realm, $pass, $dbfile,
                ".vacation.db", FTP_BINARY) )
             return false;
        $contents = "\\$user, \"|" . $conf['vacation']['path'] . " $user\"";
        $myFile = $this->_writeTempFile($contents);
        if (!file_exists($myFile)) return false;
        if (! $this->_ftpCopy($user, $realm, $pass, $myFile,
                ".forward", FTP_ASCII) )
             return false;
        unlink($myFile);
        return true;
    }

/**
 * Remove any existing vacation notices.
 *
 * @param string    $user       The user to disable vacation notices for.
 * @param string    $realm      The realm of the user.
 * @param string    $pass       The password of the user.
 *
 * @return boolean  Returns true on success, false on error.
 */

    function unset_vacation($user, $realm, $pass) {
        if ( !$this->check_config($realm) ) return false;

        if (! $this->_ftpDelete($user, $realm, $pass, ".forward") )
             return false;
        if (! $this->_ftpDelete($user, $realm, $pass, ".vacation.msg") )
            return false;
        // we could, but don't, check for errors on these...
        // they are more-or-less harmless without the above two files...
        $this->_ftpDelete($user, $realm, $pass, ".vacation.pag");
        $this->_ftpDelete($user, $realm, $pass, ".vacation.dir");
        $this->_ftpDelete($user, $realm, $pass, ".vacation.db");
        return true;
    }

}

?>
