<?php
    
define('VACATION_BASE', dirname(__FILE__));
include_once VACATION_BASE . '/lib/base.php';
require_once VACATION_BASE . '/config/conf.php';
include  $registry->getTemplatePath() . '/common-header.inc';
include_once $registry->getTemplatePath('horde') . '/javascript/open_help_win.js';

 
$submit=Horde::getFormData('submit', false);

if ( $submit ) {
    print '<p><font size="+3" color="#CC0000">';
    $error = false;
    $userid=Horde::getFormData('userid', false);
    if (!$userid ) {
        Horde::raiseMessage(_("You must give your userid"),HORDE_WARNING);
        $error = true;
    }
    if ($userid != Auth::getAuth() ) {
        Horde::raiseMessage(_("You can not set vacation notices for other user"),
                            HORDE_ERROR);
        $error = true;
    }
    $splitted = split("@", $userid);
    $userid = @$splitted[0]; $realm = @$splitted[1];
    if (in_array($userid, $conf['user']['refused'])) {
        $msg=sprintf (_("You can't change vacation notice for user %s"),$userid);
        Horde::raiseMessage($msg,HORDE_ERROR);
        $error = true;
    }
    $oldpassword=Horde::getFormData('oldpassword', false);
    if (!$oldpassword) {
        Horde::raiseMessage(_("You must give your password"),HORDE_WARNING);
        $error = true;
    }
    $vacationmsg=Horde::getFormData('mess', false);
    if (!$vacationmsg) {
        Horde::raiseMessage(_("You must give a vacation message"),HORDE_WARNING);
        $error = true;
    }
    $vacationmode=Horde::getFormData('mode', false);
    if (!$vacationmode) {
        Horde::raiseMessage(_("You must specify the mode"),
                            HORDE_WARNING);
        $error = true;
    }

    if ($error == false) switch ($mode) {
    case "set":
        require VACATION_BASE . "/vacation.php";
        $daemon = new vacation;
        if ($daemon->set_vacation($userid, $realm, $oldpassword, $mess)) {
            Horde::raiseMessage(_("Vacation notice set!"),HORDE_SUCCESS);
        } else {
            Horde::raiseMessage( _("Failure in modifying vacation notice: ") . 
                    $daemon->err_str, HORDE_ERROR);
        }
        break;
    case "unset":
        require("vacation.php");
        $daemon = new vacation;
        if ($daemon->unset_vacation($userid, $realm, $oldpassword)) {
            Horde::raiseMessage(_("Vacation notice removed!"),HORDE_SUCCESS);
        } else {
            Horde::raiseMessage( _("Failure in removing vacation notice: ") . 
                    $daemon->err_str, HORDE_ERROR);
        }
        break;
    default:
        break;
    }
    print "</font></p>";
  }
?>
<?php
    require $registry->getFileRoot() . '/status.php';
    include  $registry->getTemplatePath() . '/main.inc';
    include VACATION_BASE . '/templates/common-footer.inc';

?>
