<?php
/*
 * $Horde: troll/threadoverview.php,v 1.15 2002/05/12 18:57:19 thierry Exp $
 *
 * Copyright 2000 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 2000, 2001 Jon Parise <jon@horde.org>
 * Copyright 2000 Anil Madhavapeddy <avsm@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('TROLL_BASE', dirname(__FILE__));
require_once TROLL_BASE . '/lib/base.php';
require_once HORDE_BASE . '/config/html.php';
require_once TROLL_BASE . '/config/html.php';

$title = _("Thread Overview");
$js_onLoad = null;
require TROLL_TEMPLATES . '/common-header.inc';
require TROLL_BASE . '/menu.php';
$notification->notify();

$thread  = Horde::getFormData('thread');
$article = Horde::getFormData('article');
$group   = Horde::getFormData('group');

if (strlen($thread) == 0) {
    if (empty($tdc_groups)) $tdc_groups = '';
    parse_str($tdc_groups);
}

$montha['Jan']=1;    $montha['Feb']=2;
$montha['Mar']=3;    $montha['Apr']=4;
$montha['May']=5;    $montha['Jun']=6;
$montha['Jul']=7;    $montha['Aug']=8;
$montha['Sep']=9;    $montha['Oct']=10;
$montha['Nov']=11;   $montha['Dec']=12;

$maxresults = $prefs->getValue('max_articles');
$curresults = 0;
$nodhtml = 1;
$entry = $article;

// ---------------------------------------------------------------------

$stream = OpenStream($group);

$articles = @imap_search($stream, " ALL ", SE_UID);
if (!$articles) {
    Horde::logMessage("Error on imap_search: " . imap_last_error(), __FILE__, __LINE__, LOG_NOTICE);
    $articles = array();
} else {
    sort($articles);
}

$last_read = 0;
$max = (!empty($showtree)) ? ($maxresults * 2) : ($maxresults * 6);
$last = !empty($end) ? $end : ImapLast();
if (!empty($only_new)) {
    $first = $last_read + 1;
} else {
    $first = ($last > $max) ? ($last - $max) : 0;
}
$end = $last;
if ($first < 1) {
    $first = 1;
}

$firstprinted = $last;
$lastprinted = $first;

$msgid = Horde::getFormData('msgid');
if (empty($msgid)) {
    $headers = @imap_headerinfo($stream, imap_msgno($stream, $article));
        if (!$headers) {
            Horde::fatal(new PEAR_Error("Error on imap_headerinfo: " . imap_last_error()), __FILE__, __LINE__, true);
        }
    $msgid = $headers->message_id;
}

$overview = @imap_fetch_overview($stream, implode(',', $articles), FT_UID);
if (!$overview) {
    Horde::fatal(new PEAR_Error("Error on imap_fetch_overview: " . imap_last_error()), __FILE__, __LINE__, true);
}

if (is_array($overview)) {
    reset($overview);
    while (list($key, $value) = each($overview)) {
        $messageid  = $value->message_id;
        $value->references = isset($value->references) ? $value->references : '';

        if (($messageid != $msgid) && (!strstr($value->references, $msgid))) {    // Not in thread
            continue;
        }

        $messagenum = $value->uid;

        $keytonum[$key]        = $messagenum;
        $numtokey[$messagenum] = $key;
        $idtonum [$messageid]  = $messagenum;
        $numtoid [$messagenum] = $messageid;
        $haskids [$messagenum] = 0;

        $parent = chop(strrchr($value->references, '<'));        // Parent M-ID

        if (strlen($parent) > 0 && $thread) {
            $x = IntVal($idtonum[$parent]);
            if ($x == 0) {
                $indentlevel[$messagenum] = 0;
                $kids[$messagenum] = 0;
            } else {
                $article_parent[$messagenum] = $x;
                $article_kids[$x][] = $messagenum;
                $indentlevel[$messagenum] = $indentlevel[$x] + 1;
            }

            if ($messagenum > $last_read) {
                $root = $messagenum;
                while ($indentlevel[$root] != 0 && $root > 0) {
                    if ($root > 0) {
                        $totalexpand[$root] = 1;
                    }
                    $root = $article_parent[$root];
                }
                if ($root > 0) {
                    $totalexpand[$root] = 1;
                }
            }
        } else {
            $indentlevel[$messagenum] = 0;
            $kids[$messagenum] = 0;
        }
    }
}

$t_last  = ImapLast();
$t_first = ImapFirst();
$t_new = $last_read;
if ($t_new < $t_first) {
    $t_new = $t_first;
}

$a_old = $t_new - $t_first;
$a_new = $t_last - $t_new;
if (IntVal($thread) == 1) {
    $yes = "(" . _("Yes") . ")";
    $no  = _("No");
} else {
    $yes = _("Yes");
    $no  = "(" . _("No") . ")";
}

$emsgid = RawUrlEncode($msgid);
$thread_url = "threadoverview.php?group=$group&&msgid=$emsgid&article=$article";
$return_url = "article_frames.php?group=$group";

if (IntVal($thread) == 0) {
    require TROLL_TEMPLATES . '/threadoverview/header.inc';
    require TROLL_TEMPLATES . '/threadoverview/navbar.inc';
    require TROLL_TEMPLATES . '/threadoverview/article-header.inc';
    FlatThreadOverview($article);
    require TROLL_TEMPLATES . '/threadoverview/article-footer.inc';
    require TROLL_TEMPLATES . '/threadoverview/footer.inc';
    require TROLL_TEMPLATES . '/article/headers.inc';
    FlatThreadTree();
    require TROLL_TEMPLATES . '/article/footers.inc';
} else {
    reset($overview);
    while (list($i, $value) = each($overview)) {
        if (isset($keytonum[$i]) && ($indentlevel[$keytonum[$i]] == 0)) {
            require TROLL_TEMPLATES . '/threadoverview/header.inc';
            require TROLL_TEMPLATES . '/threadoverview/navbar.inc';
            require TROLL_TEMPLATES . '/threadoverview/article-header.inc';
            PrintThreadOverview($keytonum[$i]);
            require TROLL_TEMPLATES . '/threadoverview/article-footer.inc';
            require TROLL_TEMPLATES . '/threadoverview/footer.inc';
            require TROLL_TEMPLATES . '/article/headers.inc';
            PrintThreadTree($keytonum[$i]);
            require TROLL_TEMPLATES . '/article/footers.inc';
        }
    }
}

require TROLL_TEMPLATES . '/common-footer.inc';
@imap_close($stream);

?>
