<?php
/*
 * $Horde: troll/prefs.php,v 1.3 2002/05/01 21:25:18 chuck Exp $
 *
 * Copyright 2002 Thierry Thomas <thierry@pompo.net>
 * [from a duplication of imp/prefs.php
 *  Copyright 1999-2002 Charles J. Hagenbuch <chuck@horde.org>
 *  Copyright 1999-2002 Jon Parise <jon@horde.org>]
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

function handle_identityselect($updated)
{
    global $prefs;

    $default_identity = Horde::getFormData('default_identity');
    if (!is_null($default_identity)) {
        $identities = @unserialize($prefs->getValue('identities'));
        if ($identities && count($identities) > 0 && isset($identities[$default_identity])) {
            if (!isset($prefs->prefs['default_identity'])) {
                $acl = 0;
                if ($prefs->isLocked('identities')) {
                    $acl |= _PREF_LOCKED;
                }
                if ($prefs->isShared('identities')) {
                    $acl |= _PREF_SHARED;
                }
                $prefs->add('default_identity', '', $acl);
            }
            $prefs->setValue('default_identity', $default_identity);
            if (!$prefs->isLocked('fullname')) {
                $prefs->setValue('fullname', $identities[$default_identity]['fullname']);
            }
            if (!$prefs->isLocked('from_addr')) {
                $prefs->setValue('from_addr', $identities[$default_identity]['from_addr']);
            }
            if (!$prefs->isLocked('replyto_addr')) {
                $prefs->setValue('replyto_addr', $identities[$default_identity]['replyto_addr']);
            }
            if (!$prefs->isLocked('signature')) {
                $prefs->setValue('signature', $identities[$default_identity]['signature']);
            }
            if (!$prefs->isLocked('sig_dashes')) {
                $prefs->setValue('sig_dashes', $identities[$default_identity]['sig_dashes']);
            }
            if (!$prefs->isLocked('sig_first')) {
                $prefs->setValue('sig_first', $identities[$default_identity]['sig_first']);
            }
            $updated = true;
        }
    }
    return $updated;
}

function handle_initialpageselect($updated)
{
    global $prefs;

    $initial_page = Horde::getFormData('initial_page');
    $prefs->setValue('initial_page', $initial_page);
    return true;
}

function prefs_callback()
{
    global $prefs, $js_onLoad;

    if ($prefs->isDirty('theme') || $prefs->isDirty('language')) {
        $js_onLoad = 'if (window.parent.frames.horde_menu) window.parent.frames.horde_menu.location.reload();';
    }
}

define('TROLL_BASE', dirname(__FILE__));
require_once TROLL_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/PrefsUI.php';
require TROLL_BASE . '/config/servers.php';
require TROLL_BASE . '/config/prefs.php';

/* See if we have a preferences group set. */
$group = Horde::getFormData('group');
$js_onLoad = null;

if (PrefsUI::handleForm($group)) {
    $group = null;
    include TROLL_BASE . '/config/prefs.php';
}

if ($conf['compress_pages']) {
    ob_start('ob_gzhandler');
}

$title = _("User Options");
require TROLL_TEMPLATES . '/common-header.inc';
require TROLL_BASE . '/menu.php';
$notification->notify();

/* Assign variables for select lists. */
// Not yet


/* Show the UI. */
PrefsUI::generateUI($group);

$registry->shutdown();
require TROLL_TEMPLATES . '/common-footer.inc';

?>
