<?php
// $Horde: troll/post.php,v 1.22 2002/05/05 19:36:57 thierry Exp $

define('TROLL_BASE', dirname(__FILE__));
require_once TROLL_BASE . '/lib/base.php';
require_once TROLL_BASE . '/lib/version.php';
require_once HORDE_BASE . '/lib/MIME.php';

// Browser detection library
require_once HORDE_BASE . '/lib/Browser.php';

global $notification, $browser;
$post_error = false;

$group = Horde::getFormData('group');
$supersedes = Horde::getFormData('supersedes', 'n');
$title = $group . " - " . ($supersedes=='y' ? _("Supersedes Article") : _("Post Article"));

require TROLL_TEMPLATES . '/common-header.inc';
require TROLL_TEMPLATES . '/post/javascript.inc';

$frominput = ($registry->allowGuests() || 1 /* fullname pref changeable */);
$emailinput = ($registry->allowGuests() || 0 /* from_addr pref changeable */);
$organization = $prefs->getValue('troll_organization');
$user_agent = "Troll-" . TROLL_VERSION . " (". PHP_OS . ") / " . $browser->agent;
$reply_to = $prefs->getValue('troll_replyto_addr');
$signature = $prefs->getValue('troll_signature');

if (isset($language) && isset($nls['charsets'][$language])) {
    $char_set = $nls['charsets'][$language];
}
else {
    $char_set = $nls['defaults']['charset'];
}

if (isset($from) && strlen($from) > 0) {
    if ($frominput) { 
        $from = stripslashes($from);
    } else {
        $from = Auth::getAuth();  // TO DO: full name here
    }
    if ($emailinput) { 
        $email = stripslashes($email);
    } else {
        $email = $prefs->getValue('troll_from_addr');
    }
}

/* ANJ
?>


<style type="text/css"> 
.navylink  {
 	color : blue;
 	text-decoration : none;
 }
 
<?php if ($browser->isBrowser('msie')) { ?>
 .navylink:hover  {
 	color : navy;
 	text-decoration : underline;
 }

	.SmallSelect  {
  	font-family : verdana,arial;
  	font-size : xx-small;
  	margin : 0px;
  }
 
 .textarea  {
 	font-family : Arial;
 	font-size : 10pt;
 	width : 720;
 	height : 300;
 	border : 1px;
 	border-width : 1px;
 	border-color : black;
 	border-style : solid;
 	padding : 2px;
 }

.input {
 	font-family : Arial;
 	font-size : 10pt;
 	width : 400;
 	border : 1px;
 	border-width : 1px;
 	border-color : black;
 	border-style : solid;
 	padding : 2px;
 }
<?php } ?>
 span.czone {font-family: Verdana,Arial; font-size: 80%; color: white}
 td.cprompt {font-family: Verdana,Arial; font-size: 80%; color: white}
 div.cprforum {font-family: Verdana,Arial; font-weight: bold; text-align: center; color: white; font-size: 150%}
 span.cforum {color: blue}
</style>

<?php
*/
require './config/conf.php';
error_reporting($conf['debug_level']);

require_once TROLL_BASE . '/lib/NNRP.php';
require_once TROLL_BASE . '/lib/Troll.php';

if (($nnrp = nnrp_open($conf['news']['server'])) == -1) {
    echo _("Connect failed");
    exit;
}

$message = Horde::getFormData('message');
if ($frominput) {
    $from = Horde::getFormData('from');
}
if ($emailinput) {
    $email = Horde::getFormData('email');
}
$subject = Horde::getFormData('subject');
$article = Horde::getFormData('article');
if (empty($message)) {
    if (nnrp_group($nnrp, $group) == -1) 
    {
        $notification->push(_("Cannot set current group"), 'horde.error');
    }
    if ($frominput) {
        if (empty($from)) {
            $from = $prefs->getValue('troll_fullname');
        }
    } else {
        $from = Auth::getAuth();  // TO DO: full name here
    }
    
    $email = $prefs->getValue('troll_from_addr');
    
    if (isset($article) && IntVal($article) > 0) {
        $oldsubject = nnrp_xhdr($nnrp, $article, "Subject");
        if ((substr($oldsubject, 0, 4) != "Re: ") && ($supersedes != 'y')) {
            $oldsubject = "Re: " . $oldsubject;
        }
    } else {
        $oldsubject = '';
    }
    
    $from = stripslashes($from);
    $email = stripslashes($email);

    if (empty($orig_group)) {
        $orig_group = $group;
    }

    require TROLL_TEMPLATES . '/post/form.inc';

} else {
?>

<div class="cprforum">
<br /><b>
<?php
    if (($nnrp = nnrp_open($conf['news']['server'])) == -1) {
        $notification->push(_("Connect failed"), 'horde.error');
        $post_error = true;
    }

    $newsgroups = array_unique (explode(",", $group));
    $group = implode(",", $newsgroups);
    $ng = count($newsgroups);
    if (($ng == 0) || (empty($newsgroups[0]))) {
        $notification->push(_("You must select a newsgroup."), 'horde.error');
        $post_error = true;
    }
    $i = $prefs->getValue('max_crosspost');
    if ($ng > $i) {
        $notification->push(sprintf(_("You are not allowed to crosspost to more than %d groups."), $i), 'horde.error');
        $post_error = true;
    }
    foreach ($newsgroups as $grp) {
        if (nnrp_group($nnrp, $grp) == -1) {
            $notification->push(_("Cannot set current group") . " " . $grp, 'horde.error');
            $post_error = true;
        }
    }

    $newsgroups = array_unique (explode(",", $fu2));
    $fu2 = implode(",", $newsgroups);
    $i = count($newsgroups);
    if (($ng > 1) && ($i == 0)) {
        if ($prefs->getValue('must_fu2')) {
            $notification->push(_("You must set a Followup-To when crossposting."), 'horde.error');
            $post_error = true;
        } else {
            $notification->push(_("You should set a Followup-To when crossposting."), 'horde.warning');
        }
    }
    $ng = $prefs->getValue('max_fu2');
    if ($i > $ng) {
        $notification->push(sprintf(_("You are not allowed to set a follow-up to more than %d groups."), $ng), 'horde.error');
        $post_error = true;
    }
    if (($i > 0) && (!empty($newsgroups[0]))) {
        foreach ($newsgroups as $grp) {
            if (nnrp_group($nnrp, $grp) == -1) {
                if ($grp != 'poster') {
                    $notification->push(_("Cannot set current group") . " " . $grp, 'horde.error');
                    $post_error = true;
                } else {
                    if ($i > 1) {
                        $notification->push(_("'poster' cannot be selected with any group."), 'horde.warning');
                        $fu2 = 'poster';
                    }
                }
            }
        }
    }

    if (empty($from)) {
        $notification->push(_("No name (From:)!"), 'horde.error');
        $post_error = true;
    }

    if (empty($email)) {
        $notification->push(_("No email!"), 'horde.error');
        $post_error = true;
    }

    if (empty($message)) {
        $notification->push(_("No message!"), 'horde.error');
        $post_error = true;
    }

    if (empty($subject)) {
        $notification->push(_("No subject!"), 'horde.error');
        $post_error = true;
    }

    $references="";
    $superseded = "";
    if(isset($article) && IntVal($article)>0 && !$post_error)
    {
        $references=nnrp_xhdr($nnrp,$article,"References");
        if(eregi("none",$references)) {
            $references="";
        }
        $oldmsgid = nnrp_xhdr($nnrp, $article, "Message-ID");
        if ($supersedes == 'n') {
            $references = $references . " " . $oldmsgid;
        } else {
            $superseded = $oldmsgid;
        }
    }

    if((strlen($email) > 0) && !$post_error) {
        $from .= " <".$email.">";
    }

    if(strlen($signature) > 0) {
        $message .= "\r\n-- \r\n" . $signature;
    }
    
    //echo "group: " . htmlentities($group) . "<br />\n";
    //echo "email: " . htmlentities($email) . "<br />\n";
    //echo "from: " . htmlentities($from) . "<br />\n";
    //echo "subject: " . htmlentities($subject) . "<br />\n";
    //echo "message: " . htmlentities($message) . "<br />\n";
    //echo "superseded: " . htmlentities($superseded) . "<br />\n";
    if (!$post_error) {
        $ret = nnrp_post($nnrp, $group, $from, $subject, $message, $reply_to, $organization, $fu2, $references, $user_agent, $char_set, $superseded);
    } else {
        $ret = -1;
    }
    if ($ret == -1) {
        $notification->push(_("Sorry, could not post message to") . ' <span class="cforum">' . $group . '</span>', 'horde.error');
        $post_error = true;
    } else {
        $notification->push(_("Message posted to") . ' <span class="cforum">' . $group . '</span>', 'horde.success');

        $last=nnrp_last();
    }
?>
<br />
<a href="article_frames.php?group=<?= $orig_group ?>&article=<?= $last ?>" class="navylink" target="main" onClick='self.close();'><?= _("Go back to") . " " . $orig_group . "." ?>
</a> | <a href="groupoverview.php" class="navylink" target="overview" onClick='self.close();'><?= _("Go to group overview.") ?></a>
</b></div>
<?php

    if (nnrp_close($nnrp) == -1) {
        $notification->push(_("Cannot close connection"), 'horde.error');
    }
}

echo '<br />';
$notification->notify();

// Second chance
if ($post_error) {
    require TROLL_TEMPLATES . '/post/form.inc';
}

$notFrame = true;
require TROLL_TEMPLATES . '/common-footer.inc';
?>
