<?php
/*
 * $Horde: troll/newsgroups.php,v 1.32 2002/05/04 09:08:53 thierry Exp $
 *
 * Copyright 2000 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 2000, 2001 Jon Parise <jon@horde.org>
 * Copyright 2000 Anil Madhavapeddy <avsm@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('NAV_REFRESH_NEVER', -2);
define('NAV_REFRESH_NOW', -1);

define('TROLL_BASE', dirname(__FILE__));
require_once TROLL_BASE . '/lib/base.php';
require_once TROLL_BASE . '/lib/Tree.php';

// Warning: $troll['stream'] is a resource, it is not registered!
if (!isset($_SESSION['troll']) || !is_array($_SESSION['troll'])) {
    $troll = array();
    $_SESSION['troll'] = &$troll;
    session_register('troll');
} else {
    $troll = &$_SESSION['troll'];
}

$troll['stream'] = OpenStream();

$nntptree = new Troll_Tree();

$newsgroupPollList = array();

/* This reinitializes the $nntptree variable and recalculates the
 * newsgroup list */
function initializeTree($showsub = false) {
    global $prefs, $nntptree;
    $nntptree->init($showsub, true);
}

/* Utility function to return a url for the various newsgroup images */
function newsgroupImage($name, $alt, $width , $height ) {
    return Horde::img('newsgroups/' . $name, $alt,
                      '" border="0" width="' . $width . '" height="' . $height . '"');
}

if (isset($troll['nntptree']) && is_array($troll['nntptree'])) {
    $nntptree->unpickle($troll['nntptree']);
} else {
   initializeTree();
}

$refresh_time = false;

/* Run through the action handlers */
$actionID = Horde::getFormData('actionID', NOOP);
$showAll = Horde::getFormData('showAll', true);
switch ($actionID) {
 case TROLL_EXPAND_NEWSGROUP:
     if (!empty($_GET['newsgroup'])) {
         $nntptree->expand($_GET['newsgroup'], true);
     }
     break;

 case TROLL_EXPAND_ALL_NEWSGROUPS:
     $nntptree->expandAllFolders(true);
     break;

 case TROLL_COLLAPSE_NEWSGROUP:
     if (!empty($_GET['newsgroup'])) {
         $nntptree->collapse($_GET['newsgroup'], true);
     }
     break;

 case TROLL_COLLAPSE_ALL_NEWSGROUPS:
     $nntptree->collapseAllFolders(true);
     break;

 case TROLL_REFRESH_NEWSGROUPS:
     initializeTree();
     break;

 case TROLL_TOGGLE_SUBSCRIBED_VIEW:
     if ($prefs->getValue('subscribe')) {
         $showunsub = ($showAll = !$showAll);
     }
     initializeTree(!$showunsub);
     break;

 case TROLL_POLL_NEWSGROUP:
     if (isset($newsgroup_list) && is_array($newsgroup_list) && !$prefs->isLocked('nav_poll')) {
         foreach ($newsgroup_list as $newsgroup) {
             $newsgroupPollList[$newsgroup] = true;
         }
         $prefs->setValue('nav_poll', serialize($newsgroupPollList));
         $prefs->store();
     }
     break;

 case TROLL_NOPOLL_NEWSGROUP:
     if (isset($newsgroup_list) && is_array($newsgroup_list) && !$prefs->isLocked('nav_poll')) {
         foreach ($newsgroup_list as $newsgroup) {
             if (isset($newsgroupPollList[$newsgroup])) {
                 unset($newsgroupPollList[$newsgroup]);
             }
         }
         $prefs->setValue('nav_poll', serialize($newsgroupPollList));
         $prefs->store();
     }
     break;

 case TROLL_SUBSCRIBE_NEWSGROUP:
     if (isset($newsgroup_list) && is_array($newsgroup_list)) {
         foreach ($newsgroup_list as $newsgroup) {
             if (!@imap_subscribe ($troll['stream'], Troll::proxyServerString() . $newsgroup)) {
                 Horde::fatal(new PEAR_Error(imap_last_error()), __FILE__, __LINE__);
             }
         }
     }
     break;

 case TROLL_UNSUBSCRIBE_NEWSGROUP:
     if (isset($newsgroup_list) && is_array($newsgroup_list)) {
         foreach ($newsgroup_list as $newsgroup) {
             if (!@imap_unsubscribe ($troll['stream'], Troll::proxyServerString() . $newsgroup)) {
                 Horde::fatal(new PEAR_Error(imap_last_error()), __FILE__, __LINE__);
             }
         }
     }
     break;
}

/* Display the correct message on the action bar */
$subToggleText = ($showAll) ? _("Hide Unsubscribed") : _("Show all groups");

/* Set the URL to refresh the page too in the META tag */
$refresh_url = Horde::url('newsgroups.php', true);

if ($conf['compress_pages']) {
    ob_start('ob_gzhandler');
}

$title = _("Newsgroup Browser");
$js_onLoad = null;
require TROLL_TEMPLATES . '/common-header.inc';
require TROLL_BASE . '/menu.php';
$notification->notify();

/* Default to the very top of the hierarchy */
if (!isset($pattern)) {
    $pattern = '%';
}

$i = 0;
$nntptree->reset();
$newmsgs = array();
$rowct = false;

require TROLL_TEMPLATES . '/newsgroups/javascript.inc';
require TROLL_TEMPLATES . '/newsgroups/head.inc';
require TROLL_TEMPLATES . '/newsgroups/actions.inc';

/* Always poll the INBOX for new mail */
$nm = $nntptree->updateMessageInfo();
$hd = $nntptree->head();
if (isset($hd['newmsg']) && $hd['newmsg'] > 0) {
    $newmsgs['INBOX'] = $hd['newmsg'];
}

/* Start iterating through the list of mailboxes, displaying them */
$mailbox = $nntptree->head();

while (isset($mailbox) && is_array($mailbox)) {

    $checkable = false;
    /* Determine if we need to poll this mailbox for new messages */
    if (isset($newsgroupPollList[$mailbox['value']])) {
        $updateCache = true;
    } else {
        $updateCache = false;
    }

    /* If we have stale information in the nntptree cache, then zero it */
    if (!$updateCache && isset($mailbox['messages'])) {
        $nntptree->flushMessageInfo();
        $mailbox = $nntptree->current();
    }

    /* If we need message information for this newsgroup, update it now */
    if ($updateCache) {
        $nntptree->updateMessageInfo();
        $mailbox = $nntptree->current();
    }

    /* Highlight mailboxes with unread messages in bold */
    if (isset($mailbox['unseen']) && $mailbox['unseen'] > 0) {
        $mailbox['label'] = '<b>' . $mailbox['label'] . '</b>';
    }

    /* Populate the $newmsgs hash with new msgs since last view of the navigator */
    if (isset($mailbox['newmsg']) && $mailbox['newmsg'] > 0) {
        $newmsgs[$mailbox['value']] = $mailbox['newmsg'];
    }

    if (!($mailbox['attributes'] & LATT_NOSELECT)) {
        $name = Horde::link(Horde::url('article_frames.php?group=' . urlencode($mailbox['value'])),
                _("View messages in ") . Troll::displayNewsgroup($mailbox['value'])) .
                $mailbox['label'] . '</a>';

        $dir2 = newsgroupImage('newsgroup.gif', _("Newsgroup"), 16, 16);
        $checkable = true;
    } else {
        $name = $mailbox['label'];
        if ($nntptree->isOpen($mailbox)) {
            $dir2 = newsgroupImage('newscollection.gif', _("Open Newsgroup"), 16, 16);
        } else {
            $dir2 = newsgroupImage('newscollection.gif', _("Closed Newsgroup"), 16, 16);
        }
    }

    if ($nntptree->hasChildren($mailbox)) {

        if ($nntptree->isOpen($mailbox)) {
            $dir = Horde::link(Horde::url('newsgroups.php?actionID=' . TROLL_COLLAPSE_NEWSGROUP . "&newsgroup=" .
                   urlencode($nntptree->server . $mailbox['value'])), _("Collapse Newsgroup")) .
                   newsgroupImage('expanded.gif', _("Collapse Newsgroup"), 18, 18) . "</a>$dir2";
        } else {
            $dir = Horde::link(Horde::url('newsgroups.php?actionID=' . TROLL_EXPAND_NEWSGROUP . "&newsgroup=" .
                   urlencode($nntptree->server . $mailbox['value'])), _("Expand Newsgroup")) .
                   newsgroupImage('collapsed.gif', _("Expand Newsgroup"), 18, 18) . "</a>$dir2";
        }
    } else {
        $dir = newsgroupImage('empty.gif','', 18, 18) . $dir2;
    }

    /* set up status information */
    if ($name == $mailbox['label']) {
        $msgs = '&nbsp;';
        $new  = '&nbsp;';
    } else {
        if (isset($mailbox['messages'])) {
            $msgs = $mailbox['messages'];
        } else {
            $msgs = '&nbsp;';
        }
        if (isset($mailbox['unseen'])) {
            $new = $mailbox['unseen'];
        } else {
            $new = '&nbsp;';
        }
    }

    if ($showAll && isset($unsubList[$mailbox['value']])) {
        $navclass = 'newsgroupunsub';
    } else {
        $navclass = ($rowct = !$rowct) ? 'list' : 'listlt';
    }

    include TROLL_TEMPLATES . '/newsgroups/row.inc';
    $i++;

    if ($nntptree->isOpen($mailbox)) {
        $mailbox = $nntptree->next();
    } else {
        $mailbox = $nntptree->nextOnLevel();
    }
}

/* Put the tree back into the session object for caching */
$troll['nntptree'] = $nntptree->pickle();
if (isset($troll['stream'])) {
    @imap_close($troll['stream']);
}

require TROLL_TEMPLATES . '/newsgroups/actions.inc';
require TROLL_TEMPLATES . '/newsgroups/foot.inc';
require TROLL_TEMPLATES . '/common-footer.inc';

?>
