<?php
// $Horde: troll/lib/base.php,v 1.22 2002/06/19 02:31:25 chuck Exp $

/*
 * Troll base inclusion file.
 *
 * This file brings in all of the dependencies that every Troll script
 * will need, and sets up objects that all scripts use.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of Troll
@define('TROLL_BASE', dirname(__FILE__) . '/..');

// Registry
require_once TROLL_BASE . '/../lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('troll');
$conf = &$GLOBALS['conf'];
@define('TROLL_TEMPLATES', $registry->getParam('templates'));

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';

// Troll base libraries
require_once TROLL_BASE . '/config/servers.php';
require_once TROLL_BASE . '/lib/Troll.php';
require_once TROLL_BASE . '/lib/NNRP.php';

// Browser detection library
require_once HORDE_BASE . '/lib/Browser.php';
$browser = new Browser();

// Help
require_once HORDE_BASE . '/lib/Help.php';

// Notification sytem
require_once HORDE_BASE . '/lib/Notification.php';
$notification = &Notification::singleton();
$notification->attach('status');

// Don't allow access unless there is a Horde login, or guests are allowed.
if (!(Auth::getAuth() || $registry->allowGuests())) {
    header('Location: ' . Horde::url($registry->getParam('webroot', 'horde') . '/login.php?url=' . urlencode(Horde::selfUrl()), true));
    exit;
}

?>
