<?php
// $Horde: troll/lib/Troll.php,v 1.38 2002/06/10 22:04:25 thierry Exp $

// Troll Constants
define('TROLL_POLL_NEWSGROUP', 101);
define('TROLL_NOPOLL_NEWSGROUP', 102);
define('TROLL_SUBSCRIBE_NEWSGROUP', 103);
define('TROLL_UNSUBSCRIBE_NEWSGROUP', 104);
define('TROLL_EXPAND_NEWSGROUP', 105);
define('TROLL_COLLAPSE_NEWSGROUP', 106);
define('TROLL_EXPAND_ALL_NEWSGROUPS', 107);
define('TROLL_COLLAPSE_ALL_NEWSGROUPS', 108);
define('TROLL_REFRESH_NEWSGROUPS', 109);
define('TROLL_TOGGLE_SUBSCRIBED_VIEW', 110);
define('TROLL_EDIT_PREFS', 111);

/**
 * Troll Base Class
 *
 * @author Chuck Hagenbuch <chuck@horde.org>
 * @author Jon Parise <jon@horde.org>
 * @version $Revision: 1.38 $
 * @package troll
 */
class Troll {

    /**
     * If there is information available to tell us about a prefix in
     * front of mailbox names that shouldn't be displayed to the user,
     * then use it to strip that prefix out.
     *
     * @param string $newsgroup The newsgroup name to display.
     *
     * @return string The newsgroup, with any prefix gone.
     */
    function displayNewsgroup($newsgroup) {
        return $newsgroup;
    }

    function serverString()
    {
        global $conf;
        return '{' . $conf['news']['server'] . ':119/nntp}';
    }

    function proxyServerString()
    {
        global $servers;
        return '{' . $servers['imap']['server'] . ':' . $servers['imap']['port'] . '/' . $servers['imap']['protocol'] . '}' . Troll::serverString();
    }

    function preambleString()
    {
        return '';
    }

}

function ISO88591Decode($line)
{
    $line = chop($line);

    if (substr($line, strlen($line) -1, 1) == '=') {
        $line = substr($line, 0, strlen($line) - 1);
    }

    $newline = eregi_replace("=\n", '', $newline);
    $newline = eregi_replace("=\r", '', $newline);
    $newline = eregi_replace('= ', '', $newline);
    $newline = eregi_replace('=20', ' ', $line);
    $newline = eregi_replace('=3D', '=', $newline);
    return $newline;
}

function PrintMimePlain($article,$boundary,$start)
{
    echo 'PLAIN!';
}

function PrintMimeHTML($article,$boundary,$start)
{
    $i=$start;
    $inheader=true;
    $iso88591=false;
    $startbody=-1;
    $starhtml=-1;
    while($inheader && $i<count($article))
    {
        if(ereg('8859-1',$article[$i]))
        {
            $iso88591=true;
        }

        if(eregi('<HTML>',$article[$i]))
        {
            $starthtml=$i;
        }

        if(eregi('<BODY',$article[$i]))
        {
            $startbody=$i;
        }

        if(eregi('<BODY',$article[$i]))
        {
            $inheader=false;
            $body=true;
        }
        $i++;
    }

    if ($startbody == -1 && $starthtml != -1) {
        $i=$starthtml;
    }

    $c = count($article);
    $inarticle = true;
    while ($inarticle && $i<count($article)) {
        if ($iso88591) {
            echo Iso88591Decode($article[$i]);
        } else {
            echo $article[$i]."\n";
        }
        $i++;
        if(eregi('BODY>',$article[$i]) || eregi('</HTML>',$article[$i]))
        {
            $inarticle=false;
        }
    }
}

function PrintMime($article,$boundary,$plain=false)
{
    $startplain=-1;
    $starthtml=-1;

    for($i=0;$i<count($article);$i++)
    {
        if(eregi('text/plain',$article[$i]))
        {
            $startplain=0;
        }

        if(eregi('text/html',$article[$i]))
        {
            $starthtml=0;
        }

    }

    if($plain==false)
    {
        if($starthtml>=0)
        {
            PrintMimeHTML($article,$boundary,$starthtml);
            return;
        }
    }

    if($starplain>=0)
    {
        echo '(PLAIN)<BR>';
        PrintMimePlain($article,$boundary,$startplain);
        return;
    }

    echo    '<i>' . _('MIME type not recognized') . '</i>';
}

function MakeAuthor($fromline)
{
        if(ereg("(.*) <(.*)>",$fromline,$a)) {
            $r['mail']=$a[2];

            if($a[1][0]=="\"") {
                $a[1]=substr($a[1],1,strlen($a[1])-2);
            }
            $r['name']=$a[1];

            if($r['name']=="") {
                $r['name']="<i>Unknown</i>";
            }

            $email=htmlspecialchars($r['mail']);
            if($email=="your@email.here" || strlen($email)<6) {
                $email="";
                $r['url']="<span class=\"BlueNoUnderLine\">$fromline</span>";
            } else {
                $r['url']="<A HREF=\"mailto:$email\">$r[name]</a>";
                // ("."<A HREF=\"mailto:".$email."\" class=BlueNoUnderLine>"."<i>$email</i></a>)";
            }
            return $r;
        }

        if(ereg("(.*@.*) [(](.*)[)]",$fromline,$a)) {
            $r['mail']=$a[1];
            $r['name']=$a[2];

            if(strlen(chop($r['name']))==0) {
                $r['name']="<i>" . _("Unknown") . "</i>";
            }

            $r['url']="<A HREF=\"mailto:$r[mail]\">$r[name]</a>";
            return $r;
        }

        $r['mail']=$fromline;
        $r['name']=$fromline;
        if(strstr($fromline,"@")) {
            $r['url']="<A HREF=\"mailto:$r[mail]\">$r[name]</a>";
        } else {
            $r['url']="<span class=\"BlueNoUnderLine\">$fromline</span>";
        }
        return $r;
    }

    // --------------------------------------------------------------------------------------------------------------
    function MakeDate($date, $split=false)
    {
        global  $montha, $conf;
        $x = explode(" ", $date);
        if(IntVal($x[2])>1900)
        {
            $day = $x[0];
            $mon = $x[1];
            $yr  = $x[2];
            $hms = explode(":", $x[3]);
            $tz  = $x[4];
        }
        else
        {
            $day = $x[1];
            $mon = $x[2];
            $yr  = $x[3];
            $hms = explode(":",$x[4]);
            $tz  = $x[5];
        }
        $articletime = mktime($hms[0], $hms[1], $hms[2], $montha[$mon], $day, $yr);
        if ($split) {
            if ((date('Y') != @date('Y', $articletime)) ||
                (date('M') != @date('M', $articletime)) ||
                (date('d') != @date('d', $articletime))) {
                $ret = @strftime($conf['misc']['date_format'], $articletime);
            } else {
                $ret = @strftime($conf['misc']['time_format'], $articletime);
            }
        } else {
            $ret = @strftime($conf['misc']['date_format'], $articletime) . ' ' . strftime($conf['misc']['time_format'], $articletime) . '&nbsp;' . $tz;
        }
        return $ret;
    }

function PrintLine($message_id = 0, $indentlevel = 0, $visible = true, $subject = "None", $author = "Anonymous", $date = "none", $size = 0, $newa = true, $unreada = true, $hasreplies = false, $collapsed = false, $articlenumber = 0, $replies = 0, $url = "", $add = "", $plw = "100%")
{
    global $nslines, $nodhtml, $maxresults, $curresults, $group, $articles, $art_anchor;
    global $firstprinted, $lastprinted, $thread, $totalexpand, $edt;
    global $browser, $css;

    if (strlen($subject) <= 1 ) {
        return;
    }

    if(strlen($url) > 0) {
        $usetarget = false;
    } else {
        $usetarget = true;
    }

    if ($visible) {
        $curresults++;
    }

    if($articlenumber > $lastprinted) {
        $lastprinted = $articlenumber;
    }

    if ($articlenumber < IntVal($firstprinted)) {
        $firstprinted = $articlenumber;
    }

    $articles[]   = $articlenumber;
    $art_anchor[] = $message_id;

    $nodhtml = IntVal($nodhtml);

    $date = MakeDate($date, true);

    $a = MakeAuthor($author);
    $author = $a['url'];

    if($indentlevel == -1) {
        $indentlevel = strlen($message_id)/2-1;
    }

    if($nodhtml == 0) {
        if ($browser->isBrowser('msie') || $browser->isBrowser('mozilla')) {
            $x = $visible ? 'block' : 'none';
            echo "\n<div id=\"$message_id\" style=\"display: $x\">\n";
        } else {
            $x = $visible ? 'show' : 'hide';
            echo "\n<div id=\"$message_id\" style=\"position: absolute; visibility: $x;\">\n";
        }
    }

    $a = ($browser->isBrowser('msie')) ? 'middle' : 'baseline';
    echo '<table border="0" width="' . $plw . '" cellspacing="1" cellpadding="0" class="item" summary="item_' . $message_id .'">';
    echo '<tr class="text" onmouseover="javascript:style.backgroundColor=\'' . $css['.text-hi']['background-color'] . '\'" onmouseout="javascript:style.backgroundColor=\'' . $css['.text']['background-color'] . '\'">';
    echo "<td valign=bottom width=2%><img src=\"graphics/blank.gif\" width=\"20\" height=\"1\" alt=\"\" border=\"0\" /></td>\n";
    echo '<td valign="bottom" width="58%">';

    for ($i = 0; $i < $indentlevel; $i++) {
        Horde::pimg('blank.gif', ' ', 'width="9" height="1" align="' . $a . '"');
    }

    if ($hasreplies) {
        $collapsimg = $collapsed ? 'graphics/article_plus2.gif' : 'graphics/article_min2.gif';
    } else {
        $collapsimg = 'graphics/blank.gif';
    }

    if ($nodhtml == 0) {
        echo    "<a href=\"#\" ";
        echo    "onclick=\"return ExpandCollapse('$message_id',false);\" ondblclick=\"return ExpandCollapse('$message_id',true);\"";
        echo    ">";
        $onclick = "onclick=\"MarkRead('$message_id');\"";
    } else {
        $collapsimg = "graphics/blank.gif";
        $onclick = '';
    }

    echo "<img name=\"$message_id"."img\" src=\"$collapsimg\" width=\"9\" height=\"9\" vspace=\"2\" alt=\"\" border=\"0\" align=\"$a\" />";

    if ($nodhtml == 0) {
        echo '</a>';
    }

    $img = $unreada ? "graphics/message_closed.gif" : "graphics/message_open.gif";
    echo "<img name=\"$message_id"."simg\" src=\"$img\" width=\"16\" height=\"13\" alt=\"\" border=\"0\" hspace=\"2\" align=\"$a\" />";

    $article_url = "article.php?group=$group&article=$articlenumber&thread=$thread";
    if(strlen($url) > 0) {
        $article_url = $url;
    }

    if ($usetarget) {
        $target="target=\"article\"";
    } else {
        $target = "";
    }

    $subject = $subject.$add;

    echo    "<a href=\"$article_url\" $target $onclick>";
    if($newa) {
        echo    "<b>".$subject."</b>";
    } else {
        echo    $subject;
    }
    echo    "</a>";

    if(($indentlevel==0 && $thread==1 && $replies>0)) {
        $overviewurl="threadoverview.php?group=$group&article=$articlenumber&thread=$thread";
        echo "&nbsp;&nbsp;[<a target=\"_parent\" href=\"$overviewurl\" class=\"nounderline\">$replies Replies</a>]";
    }

    echo "</td>\n";
    echo "<td valign=bottom width=\"24%\" class=\"NoBreakLine\">$author</td>\n";
    echo "<td valign=bottom width=\"2%\"><img src=\"graphics/blank.gif\" width=\"10\" height=\"1\" alt=\"\" border=\"0\" /></td>\n";
    echo "<td valign=bottom width=\"12%\" class=\"NoBreakLine\">$date</td>\n";
    echo "</tr>\n";
    echo "</table>\n";

    if ($nodhtml == 0)    {
        echo "</div>\n";
        if ($browser->isBrowser('mozilla') && $visible) {
            echo "\n\n<script language=\"JavaScript\" type=\"text/javascript\">arrange();</script>\n\n";
        }
    }
}

function    GroupHeader($group,$description,$t_first,$t_last,$t_new,$c_start,$c_end,$bydate = true,$threaded = true,$desc = false)
    {
        global  $thread,$nodhtml,$showtree;

        if($t_new<$t_first)
        {
            $t_new=$t_first;
        }

        $a_read=$t_new-$t_first;
        $a_new=$t_last-$t_new;
        $a_total=$t_last-$t_first;

        echo "<table summary=\"Group header\">\n";
        echo "<tr>\n";
        echo "<td rowspan=2><img src=\"graphics/blank.gif\" width=\"20\" height=\"1\" alt=\"\" border=\"0\" /></td>\n";
        echo "<td rowspan=2><img src=\"graphics/newspaper.gif\" width=\"44\" height=\"51\" alt=\"\" border=\"0\" /></td>\n";
        echo "<td><font face=\"Arial\" size=\"+1\"><b>" . _("Group:") . " <font color=navy>$group</b></font></font></td>\n";
        echo "</tr>\n";

        echo "<tr>\n";
        echo "<td>\n";
        echo "<font face=\"Verdana,Arial\" size=\"-2\" color=#404040>\n";
//      echo "<b><font color=black>Description:</font></b> $description<br>\n";

        if(!($thread==0 || $showtree==1 || $nodhtml==1))
        {
            $c_start="??";
        }
        else
        {
            $c_start=$c_start-$t_first;
        }
        $c_end=$c_end-$t_first;

        echo "<b><font color=black>" . _("Articles:") . "</font></b> <font color=blue>$a_read</font> Read, <font color=blue>$a_new</font> New, <font color=blue>$a_total</font> Total<br>\n";
        echo "<font color=black><b>Viewing:</b></font> Articles $c_start - $c_end , by date.  ";
        echo "</font>\n";
        echo "</td>\n";
        echo "</tr>\n";
        echo "</table>\n";
    }

// --------------------------------------------------------------------
    function totalkidcount($a)
    {
        global $article_kids;

        if (!isset($article_kids[$a])) {
            return 0;
        }

        $t = 0;
        for ($i = 0; $i < count($article_kids[$a]); $i++) {
            $t = $t + totalkidcount($article_kids[$a][$i]);
        }

        return $t + count($article_kids[$a]);
    }

// ---------------------------------------------------------------------
function CreateId($a)
{
    global  $indentlevel, $article_parent, $article_kids;

    if (empty($indentlevel[$a])) {
        return "a$a";
    } else {
        $parentid = $article_parent[$a];
        for ($i=0; $i < count($article_kids[$parentid]); $i++) {
            if ($article_kids[$parentid][$i] == $a) {
                $i++;
                return  CreateId($parentid) . "a$i";
            }
        }
    }

    return '??';
}

function PrintArticleTree($artuid)
{
    global $indentlevel, $overview, $article_kids, $showtree, $maxresults, $curresults, $totalexpand, $last_read, $numtokey;

    if (!isset($numtokey[$artuid])) {
        return;
    }
    $key = $numtokey[$artuid];
    if (empty($overview[$key])) {
        return;
    }

    $art_header = $overview[$key];
    $artuid = $art_header->uid;

    $id = CreateId($artuid);

    $visible = empty($indentlevel[$artuid]) ? true : false;
    if ($showtree == 1) {
        $visible = true;
    }

    $subject    = $art_header->subject;
    $author     = $art_header->from;
    $size       = $art_header->size;
    $date       = $art_header->date;

    $replies = totalkidcount($artuid);
    $hasreplies = ($replies == 0) ? false : true;
    if ($showtree == 1 || (isset($totalexpand[$artuid]) && $totalexpand[$artuid] == 1)) {
        $collapsed = false;
    } else {
        $collapsed = true;
    }

    if (!empty($totalexpand[$artuid])) {
        $visible = true;
    }

    $art_status = GetArticleStatus($key, $artuid, $last_read);
    $anew = $art_status['Recent'];
    $aunread = $art_status['Unseen'];

    if (($curresults > $maxresults) && IntVal($indentlevel[$artuid]) == 0) {
        return;
    }

    PrintLine($id, $indentlevel[$artuid], $visible, $subject, $author, $date, $size, $anew, $aunread, $hasreplies, $collapsed, $artuid, $replies);

    for ($i = 0; $i < @count($article_kids[$artuid]); $i++) {
        if (strlen($article_kids[$artuid][$i]) > 0) {
            PrintArticleTree($article_kids[$artuid][$i]);
        }
    }
}

function PrintQuoteArticle($nnrp,$number,$supersedes = 'n')
{
    $mime=false;

    if (($data = nnrp_head($nnrp, $number)) == -1) {
        echo _("Cannot retrieve article") . " $number";
        exit;
    }

    if ($supersedes == 'n') {
        $i = 0;
        while ($i < $data["count"]) {
            if (substr($data[$i],0,4)=="From") {
                $author=substr($data[$i],6);
            }

            if (substr($data[$i],0,4)=="Date") {
                $date=substr($data[$i],6);
            }

            if (substr($data[$i],0,7)=="Subject") {
                $subject=substr($data[$i],9);
            }

            if (substr($data[$i],0,12)=="Content-Type") {
                $contenttype=substr($data[$i],14);
                if (eregi("multipart/alternative",$contenttype)) {
                    $i++;
                    $boundary=strstr($data[$i],"\"");
                    $boundary=substr($boundary,1,strlen($boundary)-2);
                    $mime=true;
                }
            }

            $i++;
        }

        $newa=MakeAuthor($author);
        $author=$newa['url'];
    }

    if (($data = nnrp_body($nnrp, $number)) == -1) {
        echo _("Cannot retrieve article") . " $a";
        exit;
    }

    if($mime) {
        echo  _("Cannot quote MIME article!");
    } else {
        if ($supersedes == 'n') {
            if(strlen($newa['mail'])>0) {
                $email="<".$newa['mail'].">";
            } else {
                $email="";
            }

            echo $newa['name'] . " " . $email . " " . _("wrote:") . "\n";
        }
        $i = 0;
        $sigdel = false;
        while (($i < $data["count"]) && !$sigdel) {
            if (strcmp($data[$i], "--") == 0) {
                $sigdel = true;
            }
            else {
                if (substr($data[$i],0,1) == ">" || (($i > 0 && substr($data[$i-1],0,1)==">") && substr($data[$i+1],0,1)==">")) {
                    echo ($supersedes == 'y' ? '> ' : ">> ") . trim(substr($data[$i],1));
                } else {
                    echo ($supersedes == 'y' ? '' : "> ") . trim($data[$i]);
                }
            }
            $i++;
            if ((($supersedes == 'n') || ($i < $data["count"])) && !$sigdel) {
                if (($i != $data["count"]) && (strcmp($data[$i], "--") != 0)) {
                    echo "\r\n";
                }
            }
        }
        if ($supersedes == 'n') {
            echo "\r\n\r\n";
        }
    }
}

function PrintArticle($stream, $number, $indent, $tw = '99%', $myemail = '')
{
    global $group, $edt, $browser, $thread, $prefs, $articles, $art_anchor;

    $mime = false;

    $headers = @imap_headerinfo($stream, imap_msgno($stream, $number));
    if (!$headers) {
        Horde::fatal(new PEAR_Error("Error on imap_headerinfo: " . imap_last_error()), __FILE__, __LINE__, true);
    }

    if ($prefs->getValue('subscribe')) {
        // imap_delete is used to set the article as "read" explicitly.
        if (!@imap_delete($stream, $number, FT_UID)) {
            Horde::logMessage("Error on imap_delete: " . imap_last_error(), __FILE__, __LINE__, LOG_NOTICE);
        }
    }

    $author     = $headers->fromaddress;
    $messageid  = $headers->message_id;
    $date       = $headers->date;
    $subject    = $headers->subject;
    $newsgroups = $headers->newsgroups;

    if (isset($headers->followup_to)) {
        $followup2  = $headers->followup_to;
    }
    if (isset($headers->references)) {
        $references = $headers->references;
        $temp = explode(" ", $references);
        $firstreference = rawurlencode($temp[0]);
    } else {
        $firstreference = '';
    }

    $structure = @imap_fetchstructure($stream, $number, FT_UID);
    if (!$structure) {
        Horde::fatal(new PEAR_Error("Error on imap_fetchstructure: " . imap_last_error()), __FILE__, __LINE__, true);
    }
    if ($structure->type != 0) {
        $mime = true;
    }

    $newa = MakeAuthor($author);
    $author = $newa['url'];
    if($newa['mail'] == $myemail) {
        $edt = 1;
    }

    $ind_art = array_search($number, $articles);

    $w = IntVal($indent*25);

    $post_url = "post.php?article=$number&group=" . htmlspecialchars($group);
    $cancel_url = "cancel.php?id=$messageid&from=" . htmlspecialchars($newa['mail']) . '&groups=' . htmlspecialchars($group);
    include TROLL_TEMPLATES . '/article/article-headers.inc';    

    $body = @imap_body($stream, $number, FT_UID);
    if (!$body) {
        Horde::fatal(new PEAR_Error("Error on imap_body: " . imap_last_error()), __FILE__, __LINE__, true);
    }

    if ($mime) {
// TODO: loop on imap_fetchbody...
//       PrintMime($data,$boundary);
    } else {
        $data = explode("\r\n", $body);
        $i = 0;
        $nbln = count($data);
        while ($i < $nbln) {
            if (substr($data[$i], 0, 1) == '>'
            || (($i > 0 && substr($data[$i - 1], 0, 1) == '>')
             && ($i < ($nbln - 1) && substr($data[$i+1],0,1) == '>'))) {
                echo '&gt;<i>' . htmlspecialchars(trim(substr($data[$i], 1))) . '</i><br />';
            } else {
                echo htmlspecialchars($data[$i]) . "<br />\n";
            }
            $i++;
        }
    }

    require TROLL_TEMPLATES . '/article/article-footers.inc';
}

function PrintThreadTree($artuid)
{
    global  $indentlevel, $overview, $article_kids, $showtree, $maxresults, $curresults, $totalexpand, $last_read, $stream;

    PrintArticle($stream, $artuid, $indentlevel[$artuid], "100%");

    if (isset($article_kids[$artuid])) {
        for ($i = 0; $i < count($article_kids[$artuid]); $i++) {
            if (strlen($article_kids[$artuid][$i]) > 0) {
                PrintThreadTree($article_kids[$artuid][$i]);
            }
        }
    }
}

function PrintThreadOverview($artuid)
{
    global $indentlevel, $overview, $article_kids, $showtree, $maxresults, $curresults, $totalexpand, $last_read, $nodhtml, $fontsize, $entry, $numtokey;

    $visible = $indentlevel[$artuid]==0 ? true : false;
    if ($showtree == 1) {
        $visible = true;
    }

    $key     = $numtokey[$artuid];
    $headers = $overview[$key];

    $subject = $headers->subject;
    $author  = $headers->from;
    $size    = $headers->size;
    $date    = $headers->date;

    $hasreplies = totalkidcount($artuid) == 0 ? false : true;
    $collapsed = false;
    $visible = true;
    $replies = 0;

    $art_status = GetArticleStatus($key, $artuid, $last_read);
    $anew    = $art_status['Recent'];
    $aunread = $art_status['Unseen'];

    $oldnodhtml = $nodhtml;
    $nodhtml  = 1;
    $fontsize = 2;

    if ($entry == $artuid) {
        $add = "<font color=red>&nbsp;<b>&lt; " . _("entry") . "</b></font>";
    } else {
        $add = "";
    }

    PrintLine($artuid, $indentlevel[$artuid], $visible, $subject, $author,
              $date, $size, $anew, $aunread, $hasreplies, false, $artuid,
              $replies, "#a$artuid", $add, "100%");     

    $nodhtml = $oldnodhtml;

    if (isset($article_kids[$artuid])) {
        for ($i = 0; $i < count($article_kids[$artuid]); $i++) {
            if (strlen($article_kids[$artuid][$i]) > 0) {
                PrintThreadOverView($article_kids[$artuid][$i]);
            }
        }
    }
}

function FlatThreadOverview($artuid)
{
    global $overview, $fontsize, $nodhtml, $last_read, $id, $indentlevel, $keytonum;


    $total = count($overview);
    end($overview);
    for ($i = 0; $i < $total; $i++) {
        $key = key($overview);
        if (($key != "count") && (isset($keytonum[$key]))) {
            $headers = current($overview);
            $subject = $headers->subject;
            $author  = $headers->from;
            $size    = $headers->size;
            $date    = $headers->date;
            $uid     = $headers->uid;

            $collapsed = false;
            $visible   = true;
            $replies   = 0;

            $art_status = GetArticleStatus($key, $artuid, $last_read);
            $anew = $art_status['Recent'];
            $aunread = $art_status['Unseen'];

            if ($artuid == $uid) {
                $add = "<font color=red>&nbsp;<b>&lt; " . _("entry") . "</b></font>";
            } else {
                $add = '';
            }

            $oldnodhtml=$nodhtml;
            $nodhtml=1;
            $fontsize=2;
            PrintLine($id, $indentlevel[$artuid], $visible, $subject, $author,
                      $date, $size, $anew, $aunread, false, false, $artuid, $replies,
                      '#a' . $key, $add, '100%');      
            $nodhtml = $oldnodhtml;
        }

        prev($overview);
    }
}

function FlatThreadTree()
{
    global $overview, $stream, $keytonum;

    $total = count($overview);
    end($overview);
    for ($i = 0; $i < $total; $i++) {
        $key = key($overview);
        if (($key != 'count') && (isset($keytonum[$key]))) {
            $headers = current($overview);
            $subject = $headers->subject;
            $author  = $headers->from;
            $size    = $headers->size;
            $date    = $headers->date;

            PrintArticle($stream, $keytonum[$key], 0, '100%');
        }

        prev($overview);
    }
}

/* TODO: to be removed?
function NewNews($nnrp, $group, $datestamp)
{
    global $NNRP_GLOBAL_STATUS, $nodhtml, $fontsize;

    $maxresult = 10;
    $res = 0;

    nnrp_group($nnrp,$group);
    $newnews = nnrp_newnews($nnrp, $group, $datestamp);
    for ($i = (count($newnews) - 1); ($i >= 0) && ($res < $maxresult); $i--) {
        $hdr = nnrp_head($nnrp, $newnews[$i]);
        if (is_array($hdr) && strlen($newnews[$i]) > 5) {
            for ($j = 0; $j < count($hdr); $j++) {
                if (substr($hdr[$j], 0, 4) == 'From') {
                    $author = substr($hdr[$j], 6);
                }

                if (substr($hdr[$j], 0, 4) == 'Date') {
                    $date = substr($hdr[$j], 6);
                }

                if (substr($hdr[$j],0,7)=="Subject") {
                    $subject = substr($hdr[$j],9);
                }
            }

            $id = IntVal(strtok($NNRP_GLOBAL_STATUS[$nnrp]['LASTRESULTTEXT'], ' '));

            $nodhtml = 1;
            $fontsize = 2;
            $url = "article_frames.php?group=$group&article=$id";
            if ($res > $maxresult) {
                PrintLine($id, 0, true, $subject, $author, $date, 0, false, false, false, false, $a, 0, $url, '', '90%');
                $res++;
            }
        }
    }
}
*/

/***
  * OpenStream: open an imap stream.
  *
  */
function OpenStream($group = '')
{
    global $prefs;

    if (!empty($group)) {
        $group = imap_utf7_encode($group);
    }

    if ($prefs->getValue('subscribe')) {
        // if realm is defined, Auth::getAuth() returns login@realm, and we only need login.
        $login_realm = explode('@', Auth::getAuth());
        $res = @imap_open(Troll::proxyServerString() . $group, $login_realm[0], Auth::getCredential('password'));
    } else {
        $res = @imap_open(Troll::serverString(), '', '', OP_HALFOPEN);
    }
    if (!$res) {
        Horde::logMessage("OpenStream: proxyServerString = '" . Troll::proxyServerString() . "'", __FILE__, __LINE__, LOG_DEBUG);
        Horde::fatal(new PEAR_Error(imap_last_error()), __FILE__, __LINE__);
    } else {
        return $res;
    }
}

/***
  * GetArticleStatus: return an array of boolean ['Recent', 'Unseen']
  *
  */
function GetArticleStatus($key, $artnum, $last_read)
{
    global $prefs, $overview;
    $statut = array();

    if ($prefs->getValue('subscribe')) {

        if (isset($overview)) {
            $art_header = $overview[$key];
            $statut['Recent'] = ($art_header->recent != ' ')  ? true : false;
            $statut['Unseen'] = ($art_header->deleted == ' ') ? true : false;
        } else {
            Horde::logMessage("GetArticleStatus: overview not set.", __FILE__, __LINE__, LOG_DEBUG);
            $statut['Recent'] = true;
            $statut['Unseen'] = true;
        }
    } else {
        if ($artnum > $last_read) {
            $statut['Recent'] = true;
            $statut['Unseen'] = true;
        } else {
            $statut['Recent'] = false;
            $statut['Unseen'] = false;
        }
    }

    return $statut;
}

/***
  * MarkReadUntil: mark all messages as read (i.e. "deleted") until the given argument.
  *
  */
function MarkReadUntil($maxnum)
{
    global $troll, $group;

    if (!isset($troll['stream']) || !is_array($troll) || (gettype($troll['stream']) != "resource")) {
        $troll['stream'] = OpenStream($group);
    }

    if (!@imap_setflag_full($troll['stream'], "1:" . $maxnum, "\\Deleted", ST_UID)) {
        Horde::logMessage("Error on imap_setflag_full: " . imap_last_error(), __FILE__, __LINE__, LOG_DEBUG);
        return false;
    }

    return true;
}

/***
  * ImapFirst: return the first uid of the current stream.
  *
  */
function ImapFirst()
{
    global $articles;

    return isset($articles[0]) ? $articles[0] : 0;
}

/***
  * ImapLast: return the last uid of the current stream.
  *
  */
function ImapLast()
{
    global $articles;

    $maxind = count($articles) - 1;

    return isset($articles[$maxind]) ? $articles[$maxind] : 0;
}
?>
