<?php
/*
 * $Horde: troll/lib/Listgroups.php,v 1.2 2002/05/04 09:08:52 thierry Exp $
 *
 * Copyright 2002 Thierry Thomas <thierry@pompo.net>
 * [from code from troll/newsgroups.php
 *  Copyright 2000 Charles J. Hagenbuch <chuck@horde.org>
 *  Copyright 2000, 2001 Jon Parise <jon@horde.org>
 *  Copyright 2000 Anil Madhavapeddy <avsm@horde.org>]
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('NAV_REFRESH_NEVER', -2);
define('NAV_REFRESH_NOW', -1);

define('TROLL_BASE', dirname(__FILE__) . '/..');
require_once TROLL_BASE . '/lib/base.php';
require_once TROLL_BASE . '/lib/Tree.php';

if (!isset($HTTP_SESSION_VARS['troll']) || !is_array($HTTP_SESSION_VARS['troll'])) {
    $troll = array();
    $HTTP_SESSION_VARS['troll'] = &$troll;
    session_register('troll');
} else {
    $troll = &$HTTP_SESSION_VARS['troll'];
}
$troll['stream'] = @imap_open(Troll::serverString(), '', '', OP_HALFOPEN);
if (!$troll['stream']) {
    Horde::fatal(new PEAR_Error(imap_last_error()), __FILE__, __LINE__);
}

$nntptreegl = new Troll_Tree();

$displayedNewsgroups = array();

/* This reinitializes the $nntptreegl variable and recalculates the
 * newsgroup list */
function initializeTree() {
    global $prefs, $nntptreegl;
    $nntptreegl->init(false, false);
}

/* Utility function to return a url for the various newsgroup images */
function newsgroupImage($name, $alt, $width , $height ) {
    return Horde::img('newsgroups/' . $name, $alt, 
                      '" border="0" width="' . $width . '" height="' . $height . '"');
}

if (isset($troll['nntptreegl']) && is_array($troll['nntptreegl'])) {
    $nntptreegl->unpickle($troll['nntptreegl']);
} else {
   initializeTree();
}

$refresh_time = false;
 
/* Run through the action handlers */
$actionID = Horde::getFormData('actionID', NOOP);
switch ($actionID) {
 case TROLL_EXPAND_NEWSGROUP:
     $newsgroup = urldecode(Horde::getFormData('newsgroup'));
     if (!empty($newsgroup)) {
         $nntptreegl->expand($newsgroup, false);
     }
     break;
     
 case TROLL_EXPAND_ALL_NEWSGROUPS:
     $nntptreegl->expandAllFolders(false);
     break;
     
 case TROLL_COLLAPSE_NEWSGROUP:
     $newsgroup = urldecode(Horde::getFormData('newsgroup'));
     if (!empty($newsgroup)) {
         $nntptreegl->collapse($newsgroup, false);
     }
     break;
     
 case TROLL_COLLAPSE_ALL_NEWSGROUPS:
     $nntptreegl->collapseAllFolders(false);
     break;
     
 case TROLL_REFRESH_NEWSGROUPS:
     initializeTree();
     break;

}

/* Set the URL to refresh the page too in the META tag */
$refresh_url = Horde::url('lib/Listgroups.php', true);

if ($conf['compress_pages']) {
    ob_start('ob_gzhandler');
}

$groups = Horde::getFormData('groups');
$fu2 = Horde::getFormData('fu2');
$origGroups = explode(",", $groups);

$title = _("Newsgroups List");
$js_onLoad = null;
require TROLL_TEMPLATES . '/common-header.inc';

?>
<style type="text/css">
 span.falselink {color: blue}
</style>
<?php

/* Default to the very top of the hierarchy */
if (!isset($pattern)) {
    $pattern = '%';
}

$i = 0;
$nntptreegl->reset();

require TROLL_TEMPLATES . '/listgroups/javascript.inc';
require TROLL_TEMPLATES . '/listgroups/head.inc';

$showAll = false;
$navclass = 'list';

/* Add a line for "poster" */
if ($fu2 == 'y') {
?>
<tr class="<?= $navclass ?>">
 <td class="<?= $navclass ?>" width="3">
<input class="list" type="checkbox" name="newsgroup_list[]" value="poster" /> </td>
<td class="list">
<img src="/hordecvs/troll/graphics/newsgroups/empty.gif" border="0" alt="" title="" border="0" width="18" height="18" /><img src="/hordecvs/troll/graphics/newsgroups/newsgroup.gif" border="0" alt="Forum" title="Forum" border="0" width="16" height="16" />&nbsp;&nbsp;<span class="falselink">poster</span> </td>
</tr>
<?php
}

/* Start iterating through the list of mailboxes, displaying them */
$mailbox = $nntptreegl->head();

while (isset($mailbox) && is_array($mailbox)) {

    $checkable = false;
    array_push($displayedNewsgroups, $mailbox['value']);
    if (!($mailbox['attributes'] & LATT_NOSELECT)) {
        $name = '<span class="falselink">' . $mailbox['label'] . '</span>';
        $dir2 = newsgroupImage('newsgroup.gif', _("Newsgroup"), 16, 16);
        $checkable = true;
    } else {
        $name = $mailbox['label'];
        if ($nntptreegl->isOpen($mailbox)) {
            $dir2 = newsgroupImage('newscollection.gif', _("Open Newsgroup"), 16, 16);
        } else {
            $dir2 = newsgroupImage('newscollection.gif', _("Closed Newsgroup"), 16, 16);
        }
    }
    
    if ($nntptreegl->hasChildren($mailbox)) {

        $newsgroup = urlencode($nntptreegl->server . $mailbox['value']);
        if ($nntptreegl->isOpen($mailbox)) {
            $dir = Horde::link('javascript:submitAction(' . TROLL_COLLAPSE_NEWSGROUP . ",'" . $newsgroup . "')", _("Collapse Newsgroup")) .
                   newsgroupImage('expanded.gif', _("Collapse Newsgroup"), 18, 18) . "</a>$dir2";
        } else {
            $dir = Horde::link('javascript:submitAction(' . TROLL_EXPAND_NEWSGROUP  . ",'" . $newsgroup . "')", _("Expand Newsgroup")) .
                   newsgroupImage('collapsed.gif', _("Expand Newsgroup"), 18, 18) . "</a>$dir2";
        }
    } else {
        $dir = newsgroupImage('empty.gif','', 18, 18) . $dir2;
    }
  
    include TROLL_TEMPLATES . '/listgroups/row.inc';
    $i++;
    
    if ($nntptreegl->isOpen($mailbox)) {
        $mailbox = $nntptreegl->next();
    } else {
        $mailbox = $nntptreegl->nextOnLevel();
    }
}

/* Preserve hidden selected groups */
$hidden_groups = implode(",", array_diff($origGroups, $displayedNewsgroups));

/* Put the tree back into the session object for caching */
$troll['nntptreegl'] = $nntptreegl->pickle();

require TROLL_TEMPLATES . '/listgroups/foot.inc';
$notFrame = true;
require TROLL_TEMPLATES . '/common-footer.inc';

?>
