<?php
/*
 * $Horde: troll/groupview.php,v 1.24 2002/06/15 19:22:42 thierry Exp $
 *
 * Copyright 2000 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 2000, 2001 Jon Parise <jon@horde.org>
 * Copyright 2000 Anil Madhavapeddy <avsm@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('TROLL_BASE', dirname(__FILE__));
require_once TROLL_BASE . '/lib/base.php';
require_once TROLL_BASE . '/lib/Troll.php';
require_once HORDE_BASE . '/config/html.php';
require_once TROLL_BASE . '/config/html.php';

$montha['Jan']=1;    $montha['Feb']=2;
$montha['Mar']=3;    $montha['Apr']=4;
$montha['May']=5;    $montha['Jun']=6;
$montha['Jul']=7;    $montha['Aug']=8;
$montha['Sep']=9;    $montha['Oct']=10;
$montha['Nov']=11;   $montha['Dec']=12;

if (isset($language) && !empty($language)) {
    setlocale (LC_TIME, $language);
}

$maxresults = $prefs->getValue('max_articles');
$curresults = 0;

$articles = array();
$_SESSION['sorted_articles'] = &$sorted_articles;
session_register('sorted_articles');

$art_anchor = array();
$_SESSION['articles_anchor'] = &$articles_anchor;
session_register('articles_anchor');


$group   = Horde::getFormData('group', $prefs->getValue('last_group'));
$catchup = Horde::getFormData('catchup', 'n');

$stream = OpenStream($group);

$prefs->setValue('last_group', $group);

$articles = @imap_search($stream, ($prefs->getValue('show_read') ? " ALL " : " UNDELETED "), SE_UID);
if (!$articles) {
    Horde::logMessage("Error on imap_search: " . imap_last_error(), __FILE__, __LINE__, LOG_NOTICE);
    $articles = array();
} else {
    sort($articles);
}

$nbr = count($articles);                                                                                     
if ($nbr > $maxresults) {                                                                                    
    $ind_min = $nbr - $maxresults;                                                                           
    $articles = array_slice($articles, $ind_min);                                                            
    MarkReadUntil ($articles[$ind_min - 1]);                                                                 
}

$last_read = ImapFirst();

$max = $prefs->getValue('expand_tree') ? ($maxresults * 2) : ($maxresults * 6);
$last = (Horde::getFormData('end') > 0) ? Horde::getFormData('end') : ImapLast();
if (Horde::getFormData('only_new')) {
    $first = $last_read + 1;
} else {
    $first = ($last > $max) ? ($last - $max) : 0;
}
$end = $last;
if ($first < $last_read) {
    $first = $last_read;
}

if ($catchup == 'y') {
    if ($prefs->getValue('subscribe')) {
        MarkReadUntil($last);
    }
    $last += 1;
    $first = $last;
}

$firstprinted = $last;
$lastprinted = $first;

if ($articles) {
    $overview = @imap_fetch_overview($stream, implode(',', $articles), FT_UID);
    if (!$overview) {
        Horde::fatal(new PEAR_Error("Error on imap_fetch_overview: " . imap_last_error()), __FILE__, __LINE__, true);
    }
}

$title = _("Newsgroup List");
$js_onLoad = null;
if ($conf['compress_pages']) {
    ob_start('ob_gzhandler');
}

$newstart = ($maxresults > $end) ? 0 : $end - $maxresults;

$prevend = $firstprinted - $maxresults;
$nextend = $firstprinted + $maxresults;

$preva = $maxresults;
$nexta = $maxresults;

if ($nextend > ImapLast())
{
    $nextend = $last;
    $nexta = $last - $end;
}

if ($prevend < ImapFirst())
{
    $preva = 0;
}

$t_last  = ImapLast();
$t_first = ImapFirst();
$t_new   = $last_read;
if ($t_new < $t_first)
{
    $t_new = $t_first;
}

$a_old = $t_new  - $t_first;
$a_new = $t_last - $t_new;

$refresh_url = htmlspecialchars($_SERVER['PHP_SELF'] . "?group=$group");
$prev_url = $refresh_url . "&end=$prevend";
$next_url = $refresh_url . "&end=$nextend";
$msg_count = sprintf(_("Articles: %d New, %d Old"), $a_new, $a_old);

require TROLL_TEMPLATES . '/common-header.inc';
require TROLL_BASE . '/menu.php';
$notification->notify();
require TROLL_TEMPLATES . '/groupview/header.inc';
require TROLL_TEMPLATES . '/groupview/navbar.inc';
require TROLL_TEMPLATES . '/groupview/article-header.inc';

@imap_close($stream);

if ($articles && is_array($overview)) {
    reset($overview);
    while (list( $key, $value ) = each( $overview ) )
    {
        $messagenum = $value->uid;
        $messageid  = $value->message_id;

        $numtokey[$messagenum] = $key;
        $idtonum[$messageid]   = $messagenum;
        $numtoid[$messagenum]  = $messageid;
        $haskids[$messagenum]  = 0;
            
        $value->references = isset($value->references) ? $value->references : '';
        $parent = chop(strrchr($value->references, "<"));        // Parent M-ID
                        
        if (strlen($parent) > 0 && $prefs->getValue('use_threads'))
        {
            $x = isset($idtonum[$parent]) ? intval($idtonum[$parent]) : 0;
            if($x == 0)
            {            
                $indentlevel[$messagenum] = 0;
                $kids[$messagenum] = 0;            
            } else {
                $article_parent[$messagenum] = $x;
                $article_kids[$x][] = $messagenum;
                $indentlevel[$messagenum] = $indentlevel[$x]+1;
            }
            
            if (($messagenum > $last_read) && $prefs->getValue('expand_tree'))
            {
                $root=$messagenum;
                while ($indentlevel[$root] != 0 && $root > 0)
                {
                    if ($root > 0)
                    {
                        $totalexpand[$root] = 1;
                    }
                    $root = $article_parent[$root];
                }
                if ($root > 0)
                {
                    $totalexpand[$root] = 1;
                }
            }
        } else {
            $indentlevel[$messagenum] = 0;
            $kids[$messagenum] = 0;			
        }
    }
} else {
    $notification->push(_("No article."), 'horde.warning');
}

unset($articles); // To be re-set in PrintLine.

if ($prefs->getValue('sortdir')) {
    $c = 0;
    for ($i = $last; ($i > $first) && ($c < $maxresults); $i--) {
        if ($indentlevel[$i] == 0) {
            $c++;
        }
    }
    
    $first = $i;
    for ($i = $first; $i <= $last; $i++) {
        if (empty($indentlevel[$i])) {
            PrintArticleTree($i);
        }
    }
} else { // normal sort
    for ($i = $last; $i >= $first; $i--) {
        if (empty($indentlevel[$i]) && (!empty($totalexpand[$i]) || empty($haskids[$i]))) {
            PrintArticleTree($i);
        }
    }
    
    for ($i = $last; $i >= $first; $i--) {
        if (empty($indentlevel[$i]) && (empty($totalexpand[$i]) && !empty($haskids[$i]))) {
            PrintArticleTree($i);
        }
    }
}

if (isset($articles)) {
    $sorted_articles = serialize($articles);
    $articles_anchor = serialize($art_anchor);
}

$firstprinted--;

$notification->notify();

require TROLL_TEMPLATES . '/groupview/article-footer.inc';
require TROLL_TEMPLATES . '/groupview/navbar.inc';
require TROLL_TEMPLATES . '/groupview/footer.inc';

require TROLL_TEMPLATES . '/common-footer.inc';

$prefs->store();

?>
