<?
/**
 * $Horde: passwd/lib/Driver/sql.php,v 1.2.2.1 2002/10/09 17:51:02 ericr Exp $
 *
 * The sql class attempts to change a user's password stored in an sql
 * databse.
 *
 * @author   Ilya Krel <mail@krel.org>
 * @author   Tjeerd van der Zee <admin@xar.nl>
 * @author   Mattias Webjrn Eriksson <mattias@webjorn.org>
 * @author   Eric Jon Rostetter <eric.rostetter@physics.utexas.edu>
 * @package  passwd
 */

class Passwd_Driver_sql extends Passwd_Driver {

    /** file pointer to the sql connection. */
    var $db;

    /** error string returned to user if an eror occurs. */
    var $err_str;

    /** boolean which contains state of sql connection */
    var $connected=false;


    var $params;

    /**
     * Constructs a new sql Passwd_Driver object.
     *
     * @param array  $params     A hash containing connection parameters.
     */
    function Passwd_Driver_sql($params = array())
    {
        $this->params = $params;
    }


    /**
     * Do an sql connect and login as user with privilege to change passwd.
     *
     * @return   boolean   True or False based on success of connect
     *
     */

    function _connect()
    {

        if (!$this->connected) {
            if (!is_array($this->params)) {
                Horde::fatal(new PEAR_Error(
                _("No configuration information specified for SQL authentication.")),
                __FILE__, __LINE__);
            }
            if (!isset($this->params['phptype'])) {
                Horde::fatal(new PEAR_Error(
                _("Required 'phptype' not specified in authentication configuration.")),
                __FILE__, __LINE__);
            }
            if (!isset($this->params['hostspec'])) {
                Horde::fatal(new PEAR_Error(
                _("Required 'hostspec' not specified in authentication configuration.")),
                __FILE__, __LINE__);
            }
            if (!isset($this->params['username'])) {
                Horde::fatal(new PEAR_Error(
                _("Required 'username' not specified in authentication configuration.")),
                __FILE__, __LINE__);
            }
            if (!isset($this->params['password'])) {
                Horde::fatal(new PEAR_Error(
                _("Required 'password' not specified in authentication configuration.")),
                __FILE__, __LINE__);
            }
            if (!isset($this->params['database'])) {
                Horde::fatal(new PEAR_Error(
                _("Required 'database' not specified in authentication configuration.")),
                __FILE__, __LINE__);
            }
            if (!isset($this->params['table'])) {
                Horde::fatal(new PEAR_Error(
                _("Required 'table' not specified in authentication configuration.")),
                __FILE__, __LINE__);
            }

            /* Connect to the SQL server using the supplied parameters. */
            include_once 'DB.php';
            $this->db = &DB::connect($this->params, true);
            if (DB::isError($this->db)) {
                Horde::fatal(new PEAR_Error(_("Unable to connect to SQL server.")), __FILE__, __LINE__);
            }

            /* Enable the "portability" option. */
            $this->db->setOption('optimize', 'portability');
            $this->connected = true;
        }

        return true;
    }

    /**
     * Disconnect from the SQL server and clean up the connection.
     *
     * @return boolean true on success, false on failure.
     */
    function _disconnect()
    {

        if ($this->connected) {
            $this->connected = false;
            return $this->db->disconnect();
        }
       return true;

    }

    /**
     * Find out if a set of current password and username is valid.
     *
     * @param string  $userID       The userID to check.
     * @param string  $oldPassword  An old password to check.
     *
     * @return boolean Whether or not the credentials are valid.
     */
    function lookup($user, $oldPassword)
    {

        /* _connect() will die with Horde::fatal() upon failure. */
//      $this->_connect();

        /* Build the SQL query. */
        $query = 'SELECT ' . $this->params['user_col'] . ' FROM ' . $this->params['table'];
        $query .= ' WHERE ' . $this->params['user_col'] . ' = ' . $this->db->quote($user);
        $query .= ' AND ' . $this->params['pass_col'] . ' = ' . $this->db->quote(md5($oldPassword));

        /* Execute the query. */
        $result = $this->db->query($query);

        if (!DB::isError($result)) {
            $row = $result->fetchRow(DB_GETMODE_ASSOC);
            if (is_array($row)) {
                $result->free();
//              $this->_disconnect();
                return true;
            } else {
                $result->free();
//              $this->_disconnect();
                return false;
            }
        } else {
//          $this->_disconnect();
            return false;
        }

//      $this->_disconnect();
        return false;

    }

    /**
     * Modify (update) a mysql password record for a user.
     *
     * @param   $user         The user whose record we will udpate.
     * @param   $realm        The realm (domain) name of the user.
     * @param   $oldPassword  The old (current) password value.
     * @param   $newPassword  The new password value to set.
     * @param   $encryption   The type of encryption to use (plain, crypt, SHA).
     *
     * @return  boolean    True or False based on success of the modify.
     */

    function modify($user, $realm, $oldPassword,
                    $newPassword, $encryption) {

      switch (strtolower($encryption)) {
      case "plain":
         $change_info["userPassword"] = $newPassword;
         break;
      case "sha":
         $change_info["userPassword"] = "{SHA}" .
         base64_encode(mHash(MHASH_SHA1, $newPassword));
         break;
      case "crypt":
         // The salt is left out, generated by php
         $change_info["userPassword"] = "{crypt}" . crypt($newPassword);
         break;
      case "md5":
     $change_info["userPassword"] = md5($newPassword);
         break;
      default:
         $this->err_str = _("Password module is not properly configured MD5");
         $change_info["userPassword"] = "";
         break;
      }
      if ($change_info["userPassword"] == "") { return false; }

      if ($this->lookup($user, $oldPassword)) {
        // now that we know that user exist and old password is correct, change the password
        /* Build the SQL query. */
        $query = 'UPDATE ' . $this->params['table'];
        $query .= ' set ' . $this->params['pass_col'] . ' = ' . $this->db->quote(md5($newPassword));
        $query .= ' WHERE ' . $this->params['user_col'] . ' = ' . $this->db->quote($user);

        /* Execute the query. */
        $result = $this->db->query($query);

        if (!DB::isError($result)) {
            if ($result === DB_OK) { return true; }
            else { return false; }
        }
        else { return false; }
        return false;
      }
        return false;

    }

    /**
     * Change the user's password.
     *
     * @param   $username     The user for which to change the password.
     * @param   $realm        The realm (domain) for the user.
     * @param   $oldpassword  The old (current) user password.
     * @param   $newpassword  The new user password to set.
     *
     * @return  boolean    True or false based on success of the change.
     */

    function change_password($user, $realm, $oldpassword, $newpassword) {

        $hostspec   = @$this->params['hostspec'];
        $username   = @$this->params['username'];
        $password   = @$this->params['password'];
        $database   = @$this->params['database'];
        $table      = @$this->params['table'];
        $encryption = @$this->params['encryption'];
        $phptype    = @$this->params['phptype'];

        if ( $hostspec == "" || $username == "" || $password == "" || $database == ""
                || $table == "" || $encryption== "" ) {
           $this->err_str = _("Password module is not properly configured");
           return false;
        }

        $return_value = false;
        if ($this->_connect()) {
            if ($this->modify($user, $realm, $oldpassword, $newpassword, $encryption)) {
                        $return_value = true;
            }
            $this->_disconnect();
        }
        $this->_disconnect();
        return $return_value;
    }

}
?>
