<?php
/**
 * $Horde: passwd/lib/Driver/smbpasswd.php,v 1.4.2.1 2002/10/09 17:51:02 ericr Exp $
 *
 * The smbpasswd class attempts to change a user's password via the smbpasswd
 * program.
 *
 * @author   Ren Lund Jensen <lundeman@tbkol.dk>
 * @author   Eric Jon Rostetter <eric.rostetter@physics.utexas.edu>
 * @package  passwd
 */

class Passwd_Driver_smbpasswd extends Passwd_Driver {

    /** file pointer to the pipe we open to smbpasswd. */
    var $fp;

    /** error string returned if an error occurs. */

    var $err_str;

    var $params;

    /**
     * Constructs a new smbpasswd Passwd_Driver object.
     *
     * @param array  $params    A hash containing connection parameters.
     */
    function Passwd_Driver_smbpasswd($params = array())
    {
        $this->params = $params;
    }

    /**
     * Disconnect the pipe.
     * @return  zero on success, non-zero on failure
     */

    function disconnect() {
        if (isset($this->fp)) {
            $return_val = (pclose($this->fp)>>8)&0xFF;
        } else {
            $this->error_str = _("Error closing pipe to smbpasswd");
            $return_val = 1;
        }
        return $return_val;
    }

    /**
     * Connect a pipe to the smbpasswd program.
     *
     * @param  $user    The user for which to change the password, should
     *                  be shellcmdescape'd before being passed in.
     * @param  $server  The smb server to point smbpasswd at.
     *
     * @param  $path    The path to the smbpasswd program.
     *
     * @param  $tmpfile The name of the tmp file in which to write output.
     *
     * @return boolean  True or False based on if the pipe is successful.
     */

    function connect($user, $server, $path, $tmpfile) {

        $cmd = "$path -r $server -s -U \"$user\" &> $tmpfile";
        $this->fp = popen($cmd, 'w');
        if ( !isset($this->fp)) {
            $this->err_str = _("Could not open pipe to smbpasswd.");
            return false;
        }
        return true;
    }

    /**
     * Attempt to send a password string to the waiting smbpasswd program.
     *
     * @param  $cmd     The line to send (without trailing newline).
     * @return boolean  True or False depending on success of the write.
     */

    function send_command($cmd) {
        if (fputs($this->fp, $cmd . "\n") == -1) {
            $this->err_str = _("Error sending data to smbpasswd.");
            return false;
        }
        sleep(1);
        return true;
    }


    /**
     * Change the password.
     *
     * @param   $user_name        The user to change the password for.
     * @param   $realm            The optional realm of the user.
     * @param   $old_password     The current user password.
     * @param   $new_password     The new password to set.
     * @return  boolean           True or False result of changing password.
     */

    function change_password($user_name, $realm, $old_password, $new_password) {

        $conf = &$GLOBALS['conf'];

        $smbpasswd_path = @$this->params['default']['program'];

        $server = @$this->params['default']['host'];
        if ( isset($realm) && $realm != "" ) {
           if ( isset($this->params[$realm]['host']) )
              $server = $this->params[$realm]['host'];
        }

        if ($server == "" || !is_executable($smbpasswd_path) ) {
           $this->err_str = _("Password module is not properly configured.");
           return false;
        }

        // clean up file name in case evil characters are in it
        $user = escapeshellcmd($user_name);

        $tmpfile = tempnam(@$conf['tmpdir'], "smbpasswd.");
        if ( $tmpfile == false) {
           $this->err_str = _("tempnam() failed!");
           return false;
        }

        $return_value = false;
        if ($this->connect($user, $server, $smbpasswd_path, $tmpfile)) {
            if ($this->send_command($old_password)) {
                if ($this->send_command($new_password)) {
                    if ($this->send_command($new_password)) {
                       $return_value = true;
                    }
                }
            }
        }
        if ($this->disconnect() != 0 ){
            $return_value = false;
            $error = file($tmpfile);
            $this->err_str = trim($error[0]);
        }
        return $return_value;
    }
}
?>
