<?php
/**
 * $Horde: passwd/lib/Driver/poppassd.php,v 1.4.2.1 2002/10/09 17:51:01 ericr Exp $
 *
 * The poppassd class attempts to change a user's password via a
 * poppassd server.
 *
 * @author   Eric Jon Rostetter <eric.rostetter@physics.utexas.edu>
 * @package  passwd
 */

    class Passwd_Driver_poppassd extends Passwd_Driver {

    var $fp;
    var $err_str;

    var $params;

    /**
     * Constructs a new poppassd Passwd_Driver object.
     *
     * @param array  $params    A hash containing connection parameters.
     */
    function Passwd_Driver_poppassd($params = array())
    {
        $this->params = $params;
    }

    function connect( $server, $port ) {
        $this->fp = fsockopen($server, $port, $err_no, $err_str, 30);
        if (!$this->fp) {
            $this->err_str = $err_str;
            return false;
        } else {
            return $this->get_prompt();
        }
    }

    function disconnect() {
        if (isset($this->fp)) {
            fputs($this->fp, "quit\n");
            fclose($this->fp);
        }
    }

    function get_prompt() {
        $prompt = fgets($this->fp, 4096);
        if (ereg("^[1-5][0-9][0-9]",$prompt))
        {
            if (substr($prompt, 0, 3) == "200") {
                return true;
            } else {
                $this->err_str = $prompt;
                return false;
            }
        }
        else {
            return true;
        }
    }

    function send_command($cmd, $arg) {
        $line = $cmd . " " . $arg . "\n";
        fputs($this->fp, $line);
        return $this->get_prompt();
    }

    function change_password($user_name, $realm, $old_password, $new_password) {

        $server = @$this->params['default']['host'];
        $port = @$this->params['default']['port'];
        if ( isset($realm) && $realm != "" ) {
           if ( isset($this->params[$realm]['host']) )
              @$server = $this->params[$realm]['host'];
           if ( isset($this->params[$realm]['port']) )
              @$port = $this->params[$realm]['port'];
        }

    if ( $server == "" || $port == "" ) {
           $this->err_str = _("Password module is not properly configured");
           return false;
        }

        $return_value = false;
        if ($this->connect($server, $port)) {
            if ($this->send_command("user", $user_name)) {
                if ($this->send_command("pass", $old_password)) {
                    if ($this->send_command("newpass", $new_password)) {
                        $return_value = true;
                    }
                }
            }
            $this->disconnect();
        }
        return $return_value;
    }

}
?>
