<?php
/**
 * $Horde: passwd/lib/Driver/mdaemon.php,v 1.3.2.1 2002/10/09 17:51:01 ericr Exp $
 *
 * The mdaemon class attempts to change a user's password on a mdaemon
 * mail server.
 *
 * @author   Mike Cochrane <mike@graftonhall.co.nz>
 * @author   Eric Rostetter <eric.rostetter@physics.utexas.edu>
 * @package  passwd
 */

class Passwd_Driver_mdaemon extends Passwd_Driver {

    /** Hash containing mdaemon server location. */
    var $params;

    /**
     * Constructs a new Mdaemon Passwd_Driver object.
     *
     * @param array  $params    A hash containing connection parameters.
     */
    function Passwd_Driver_mdaemon($params = array())
    {
        $this->params = $params;
    }

    /**
     * Change the user's password.
     *
     * @param   $username     The user for which to change the password.
     * @param   $realm        The realm (domain) for the user.
     * @param   $oldpassword  The old (current) user password.
     * @param   $newpassword  The new user password to set.
     *
     * @return  boolean       True or false based on success of the change.
     */
    function change_password($user_name, $realm, $old_password, $new_password) {

        $location = @$this->params['default']['location'];
        if ( isset($realm) && $realm != "" ) {
           @$location = $this->params[$realm]['location'];
        }

        if (!is_dir($location)) {
           $this->err_str = _("Mdaemon path not found");
           return false;
        }

        /* create lock file */
        $fp = fopen($location . '/edituser.lck', "w");
        if (!$fp) {
           $this->err_str = _("Not able to create lock file");
           return false;
        } else {
            fclose($fp);
        }

        /* get current details */
        $current_details = $this->_getUserDetails($user_name, $realm, $location);
        if ($current_details === false) {
           $this->err_str = _("Not able to retrieve current details.");
           return false;
        }

        $new_details = substr_replace($current_details, str_pad($new_password, 19) . "Y", 195, 20);

        /* create Semaphore file */
        $fp = fopen($location . '/edituser.sem', "wb");
        if (!$fp) {
           $this->err_str = _("Not able to create semaphore file");
           return false;
        } else {
            fwrite($fp, "$user_name@$realm, " . $new_details);
            fclose($fp);
        }

        /* remove lock file */
        @unlink($location . '/edituser.lck');

        return true;
    }


    /**
     * Retreive relevant line from userlist.dat
     *
     * @param   $username     The username for which to retrieve detals..
     * @param   $realm        The realm (domain) for the user.
     * @param   $location     The location of the mdaemon directory.
     *
     * @return  Mixed         (String) Line from userlist.dat or (boolean) False
     */
    function _getUserDetails($user_name, $realm, $location) {

        $searchString = str_pad($realm, 45) . str_pad($user_name, 30);

        $fp = fopen($location . '/userlist.dat', "rb");
        if (!$fp) {
           $this->err_str = _("Mdaemon userlist file not accessable or not found.");
           return false;
        }

        while (!feof ($fp)) {
            $line = fgets($fp, 4096);
            if (substr($line,0,strlen($searchString)) == $searchString) {
                return $line;
            }
        }

       fclose($fp);
       $this->err_str = sprintf(_("User %s@%s not found"), $user_name, $realm);
       return false;
    }
}
