<?php
/**
 * $Horde: passwd/lib/Driver.php,v 1.3.2.2 2002/10/09 17:52:04 ericr Exp $
 *
 * Passwd_Driver:: defines an API for implementing password change
 * systems for Passwd.
 *
 * @author   Mike Cochrane <mike@graftonhall.co.nz>
 * @author   Eric Rostetter <eric.rostetter@physics.utexas.edu>
 * @version
 * @since
 * @package passwd
 */

class Passwd_Driver {

    /** error string returned to user if an eror occurs. */
    var $err_str;

    /**
     * Attempts to return a concrete Passwd_Driver instance based on $driver.
     *
     * @param string    $driver     The type of concrete passwd_Driver subclass
     *                              to return.  The is based on the passwd
     *                              driver ($driver).  The code is dynamically
     *                              included.
     *
     * @param array     $params     (optional) A hash containing any additional
     *                              configuration or connection parameters a
     *                              subclass might need.
     *
     * @return mixed    The newly created concrete Passwd_Driver instance, or
     *                  false on an error.
     */
    function &factory($driver, $params = array())
    {
        $driver = strtolower(basename($driver));
        @include_once dirname(__FILE__) . '/Driver/' . $driver . '.php';
        $class = 'Passwd_Driver_' . $driver;
        if (class_exists($class)) {
            return new $class($params);
        } else {
            return false;
        }
    }

    /**
     * Attempts to return a reference to a concrete Passwd_Driver instance
     * based on $driver.  It will only create a new instance if no
     * Passwd_Driver instance with the same parameters currently exists.
     *
     * This should be used if multiple storage sources are required.
     *
     * This method must be invoked as: $var = &Passwd_Driver::singleton()
     *
     * @param string    $driver     The type of concrete Passwd_Driver subclass
     *                              to return.  The is based on the passwd
     *                              driver ($driver).  The code is dynamically
     *                              included.
     *
     * @param array     $params     (optional) A hash containing any additional
     *                              configuration or connection parameters a
     *                              subclass might need.
     *
     * @return mixed    The created concrete Passwd_Driver instance, or false
     *                  on error.
     */
    function &singleton($driver, $user, $params = array())
    {
        static $instances;

        if (!isset($instances)) $instances = array();

        $signature = md5(strtolower($driver) . '][' . $user . implode('][', $params));
        if (!isset($instances[$signature])) {
            $instances[$signature] = &Passwd_Driver::factory($driver, $params);
        }

        return $instances[$signature];
    }

    /**
     * Change the user's password.
     *
     * @param   $username     The user for which to change the password.
     * @param   $realm        The realm (domain) for the user.
     * @param   $oldpassword  The old (current) user password.
     * @param   $newpassword  The new user password to set.
     *
     * @return  boolean       True or false based on success of the change.
     */

    function change_password($user_name, $realm, $old_password, $new_password) {
        return false;
    }

}
