<?php

define('PASSWD_BASE', dirname(__FILE__));
include_once PASSWD_BASE . '/lib/base.php';
include_once PASSWD_BASE . '/config/conf.php';
include  $registry->getTemplatePath() . '/common-header.inc';
include_once $registry->getTemplatePath('horde') . '/javascript/open_help_win.js';

 
$submit=Horde::getFormData('submit', false);

if ( $submit ) {
    $error = false;
    $userid=Horde::getFormData('userid', "");
    if ( $userid != Auth::getAuth() ) {
        Horde::raiseMessage(_("Internal Error"),HORDE_ERROR);
        $error = true;
    }
    $splitted  = split("@", $userid);
    $userid = @$splitted[0]; $realm = @$splitted[1];
    if (in_array($userid, $conf['user']['refused'])) {
       $msg=sprintf (_("You can't change password for user %s"),$userid);
       Horde::raiseMessage($msg,HORDE_ERROR);
       $error = true;
    }
    $oldpassword=Horde::getFormData('oldpassword', false);
    if (!$oldpassword) {
        Horde::raiseMessage(_("You must give your old password"),HORDE_WARNING);
        $error = true;
    }
    $newpassword0=Horde::getFormData('newpassword0', false);
    $newpassword1=Horde::getFormData('newpassword1', false);
    if (!$newpassword0) {
        Horde::raiseMessage(_("You must give your new password"),HORDE_WARNING);
        $error = true;
    }
    if (!$newpassword1) {
        Horde::raiseMessage(_("You must verify your new password"),
                            HORDE_WARNING);
        $error = true;
    }
    if (!($newpassword0 == $newpassword1)) {
        Horde::raiseMessage( _("Your new passwords didn't match"),HORDE_WARNING);
        $error = true;
    }

    // check max/min lengths if specified in the config file
    if (isset($conf['password']['minlength'])) {
       if (strlen($newpassword0) < $conf['password']['minlength']) {
          Horde::raiseMessage(sprintf(_("Your new password must be at least %d characters long!"), $conf['password']['minlength']),HORDE_WARNING);
          $error = true;
       }
    }
    if (isset($conf['password']['maxlength'])) {
       if (strlen($newpassword0) > $conf['password']['maxlength']) {
          Horde::raiseMessage(sprintf(_("Your new password is too long; passwords may not be more than %d characters long!"), $conf['password']['maxlength']),HORDE_WARNING);
          $error = true;
       }
    }

    // do some simple strength tests, if enabled in the config file
    if (isset($conf['password']['strengthtests']) &&
              $conf['password']['strengthtests']) {
       // check for new==old, pass==user, simple reverse strings, etc.
       if ( (strcasecmp($newpassword0, $userid) == 0) ||
            (strcasecmp($newpassword0, strrev($userid)) == 0) ||
            (strcasecmp($newpassword0, $oldpassword) == 0) ||
            (strcasecmp($newpassword0, strrev($oldpassword)) == 0) ) {
          Horde::raiseMessage(_("Your new password is too simple to guess!  Not changed!"),HORDE_WARNING);
          $error = true;
       }
       // check for percentages similarity also.  This will catch very simple
       // things like "password" -> "password2" or "xpasssword"...
       @similar_text($newpassword0, $oldpassword, &$percent1);
       @similar_text($newpassword0, $userid, &$percent2);
       if ( ($percent1 > 80) || ($percent2 > 80) ) {
          Horde::raiseMessage(_("Your new password is too simple to guess!  Not changed!"),HORDE_WARNING);
          $error = true;
       }
    }

//  Check the old password versus their current login password.  Fail if
//  they don't match.  Currently not implemented, but could be in theory.
//  Advantage is basically that we could gettext() the error here, where as
//  that may not be possible in the different password changing classes...
//    $oldpass = Auth::getCredential('password');
//    if ($oldpass && ($oldpass != $oldpassword)) {
//        Horde::raiseMessage(_("Your old password isn't correct"),
//                      HORDE_WARNING);
//        $error = true;
//    }

    if ($error == false) {
        require PASSWD_BASE . "/poppassd.php";
        $daemon = new poppassd;
        if ($daemon->change_password($userid, $realm, $oldpassword, $newpassword0)) {
            Horde::raiseMessage(_("Password changed!"),HORDE_SUCCESS);
        } else {
            Horde::raiseMessage( _("Failure in changing password : ") . 
                    $daemon->err_str, HORDE_ERROR);
        }
    }
  }

  require $registry->getFileRoot() . '/status.php';
  include  $registry->getTemplatePath() . '/main.inc';
  include PASSWD_BASE . '/templates/common-footer.inc';
?>
