<?php

error_reporting(E_ALL);

// finger.php
// (c) 1998 Charles Hagenbuch, chuck@osmos.ml.org>

// makes no calls to the shell; should be secure
// uses the IOSocket to make TCP/IP connections to
// the specified server.

require_once '../lib/Session.php';
require_once '../lib/package.HTMLDocument.php';

Session::name('Horde');
Session::start();

require_once './lib/finger.php';
require_once '../lib/package.Registry.php';
require_once '../lib/Horde.php';

$registry = new Registry();
$doc = new HTMLDocument();

require './config/conf.php';
require './config/html.php';


error_reporting(E_ALL);

function output ($results = '') {
	global $address, $registry, $lang;
	page_header();
	print '<hr>';
	print 'Results for <b>finger <a href="' . $registry->call('mail/compose', array('to' => $address, 'label' => $address)) . '">' . $address . '</a>:</b><br><br><pre>';
	print $results;
	print '</pre>';
	form();
}

function page_header () {
  ?>
 <html>
    <head>
    <title>finger.pl - reach out and touch someone</title>
    </head>
    
    <body bgcolor="#ffffff" text="#000000">
    <?php
}

function form () {
  ?>
 <hr>
    <p>Type the address of the user or machine you wish to finger here:
    <br>
    <form action="finger.php" method="get">
    <input type="text" size=60 name="address">
    <input type="submit" value="Finger!">
    </form>
    <hr>
    </body>
    </html>
    <?php
}

require $conf['paths']['templates'] . '/doctype.inc';
require $conf['paths']['templates'] . '/header.inc';
require $conf['paths']['templates'] . '/menu.inc';

if (!empty($address)) {
	output(finger($address));
} else {
	page_header();
	form();
}

require $conf['paths']['templates'] . '/footer.inc';
$registry->shutdown();

?>
