<?php

require_once 'Horde/Notification/Listener/status.php';

/**
 * The Notification_Listener_status_nag:: class extends the
 * Notification_Listener_status:: class to display the messages for
 * Nag's special message type 'nag.alarm'.
 *
 * $Horde: nag/lib/Notification/Listener/status.php,v 1.6 2004/10/22 01:07:22 chuck Exp $
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.6 $
 * @since   Nag 2.0
 * @package Horde_Notification
 */
class Notification_Listener_status_nag extends Notification_Listener_status {

    /**
     * Constructor
     *
     * @access public
     */
    function Notification_Listener_status_nag()
    {
        parent::Notification_Listener_status();
        $this->_handles['nag.alarm'] = true;
    }

    /**
     * Outputs one message if it's a Nag message or calls the
     * parent method otherwise.
     *
     * @param array $message    One message hash from the stack.
     */
    function getMessage($message)
    {
        $event = $this->getEvent($message);
        switch ($message['type']) {
        case 'nag.alarm':
            return '<p class="control">' . Horde::img('alarm.png') . '&nbsp;&nbsp;' . $event->getMessage() . '</p>';
        }

        return parent::getMessage($message);
    }

}
