<?php
/**
 * $Horde: nag/prefs.php,v 1.14.2.9 2005/01/03 11:26:00 jan Exp $
 *
 * Copyright 2001-2005 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/**
 * Call PrefsUI::groupIsEditable() here because we can rely on it being present
 * in Horde 2.1 but the prefs template still calls groupIsEditable().
 */
function groupIsEditable($group)
{
    return PrefsUI::groupIsEditable($group);
}

function handle_category_management($updated)
{
    $actionID = Horde::getFormData('managementActionID');
    $categoryID = Horde::getFormData('category_id');
    $categoryName = Horde::getFormData('category_name');

    switch ($actionID) {
        case NAG_DELETE_CATEGORY:
            Nag::deleteCategory($categoryID);
            break;

        case NAG_RENAME_CATEGORY:
            Nag::renameCategory($categoryID, $categoryName);
            break;

        case NAG_ADD_CATEGORY:
            Nag::addCategory($categoryName);
            break;

        default:
            /* must have been the Save button */
            return true;
    }

    /* return false so it stays on this page */
    return false;
}

function prefs_callback()
{
    global $prefs, $js_onLoad;

    if ($prefs->isDirty('language')) {
        $js_onLoad = 'if (window.parent.frames.horde_menu) window.parent.frames.horde_menu.location.reload();';
    }
}

define('NAG_BASE', dirname(__FILE__));
require_once NAG_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/PrefsUI.php';
require NAG_BASE . '/config/prefs.php';

/* See if we have a preferences group set. */
$group = Horde::getFormData('group');
$js_onLoad = null;

if (PrefsUI::handleForm($group)) {
    $group = null;
    include NAG_BASE . '/config/prefs.php';
}

$title = _("User Options");
require NAG_TEMPLATES . '/common-header.inc';
require NAG_BASE . '/menu.php';
$notification->notify();

PrefsUI::generateUI($group);

$registry->shutdown();
require NAG_TEMPLATES . '/common-footer.inc';
