<?php
/**
 * $Horde: kronolith/viewevent.php,v 1.49 2004/12/21 16:41:44 chuck Exp $
 *
 * Copyright 1999-2004 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';
require_once 'Horde/Text.php';

if (Util::getFormData('calendar') == '**remote') {
    $event = Kronolith::getRemoteEventObject(Util::getFormData('remoteCal'), Util::getFormData('eventID'));
} elseif ($uid = Util::getFormData('uid')) {
    $event = &$kronolith->getByUID($uid);
} else {
    $kronolith->open(Util::getFormData('calendar'));
    $event = &$kronolith->getEvent(Util::getFormData('eventID'));
}
if (!$event) {
    if (($url = Util::getFormData('url')) === null) {
        $url = Horde::applicationUrl($prefs->getValue('defaultview') . '.php', true);
    }
    header('Location: ' . $url);
    exit;
}

/* Get the event's history. */
if ($event->getUID()) {
    $history = &Horde_History::singleton();
    $log = $history->getHistory('kronolith:' . $event->getCalendar() . ':' . $event->getUID());
    foreach ($log->getData() as $entry) {
        switch ($entry['action']) {
        case 'add':
            $created = $entry['ts'];
            break;

        case 'modify':
            $modified = $entry['ts'];
            break;
        }
    }
}

$category = $event->getCategory();
$description = $event->getDescription();
$location = $event->getLocation();
$status = Kronolith::statusToString($event->getStatus());
$attendees = $event->getAttendees();

if ($conf['metadata']['keywords']) {
    include KRONOLITH_BASE . '/config/keywords.php';
    $keyword_list = array();
    foreach ($keywords as $cat => $list) {
        $sub_list = array();
        foreach ($list as $entry) {
            if ($event->hasKeyword($entry)) {
                $sub_list[] = htmlspecialchars($entry);
            }
        }
        if (count($sub_list)) {
            $keyword_list[$cat] = $sub_list;
        }
    }
}

if ($timestamp = (int)Util::getFormData('timestamp')) {
    $month = date('n', $timestamp);
    $year = date('Y', $timestamp);
} else {
    $month = (int)Util::getFormData('month', date('n'));
    $year = (int)Util::getFormData('year', date('Y'));
}

$title = $event->getTitle();
$print_view = (bool)Util::getFormData('print');
if (!$print_view) {
    Horde::addScriptFile('popup.js', 'horde', true);
}
require KRONOLITH_TEMPLATES . '/common-header.inc';

if ($print_view) {
    require_once $registry->get('templates', 'horde') . '/javascript/print.js';
} else {
    if ($browser->hasFeature('javascript')) {
        $print_link = Util::addParameter(Horde::selfURL(true), 'print', 'true');
    }

    require KRONOLITH_TEMPLATES . '/menu.inc';
}

$mylinks = array();
$isRemote = Util::getFormData('calendar') == '**remote';

if (!$isRemote && $all_calendars[$event->getCalendar()]->hasPermission(Auth::getAuth(), PERMS_DELETE, $event->getCreatorID())) {
    $delurl = Util::addParameter('delevent.php', 'eventID', $event->getID());
    $delurl = Util::addParameter($delurl, 'calendar', $event->getCalendar());
    $delurl = Util::addParameter($delurl, 'timestamp', $timestamp);
    $delurl = Horde::applicationUrl($delurl);
    $mylinks[] = Horde::widget($delurl, sprintf(_("Delete '%s'"), $event->getTitle()), 'smallheader', '', '', _("De_lete"));
}

if ($isRemote || $all_calendars[$event->getCalendar()]->hasPermission(Auth::getAuth(), PERMS_EDIT, $event->getCreatorID())) {
    $editurl = 'editevent.php';
    if (Util::getFormData('calendar') != '**remote') {
        $editurl = Util::addParameter($editurl, 'eventID', $event->getID());
    } else {
        $editurl = Util::addParameter($editurl, 'eventID', $event->eventIndex);
        $editurl = Util::addParameter($editurl, 'remoteCal', $event->remoteCal);
    }
    $editurl = Util::addParameter($editurl, 'calendar', Util::getFormData('calendar'));
    $editurl = Util::addParameter($editurl, 'timestamp', $timestamp);
    $editurl = Util::addParameter($editurl, 'url', Horde::selfURL(true));
    $editurl = Horde::applicationUrl($editurl);

    if ($isRemote) {
        $mylinks[] = Horde::widget($editurl, sprintf(_("S_ave '%s' As New"), $event->getTitle()), 'smallheader', '', '', _("Save As New"));
    } else {
        $mylinks[] = Horde::widget($editurl, sprintf(_("Edit '%s'"), $event->getTitle()), 'smallheader', '', '', _("_Edit"));
    }
}

// Determine owner's name.
require_once 'Horde/Identity.php';
$owner = $event->getCreatorID();
$ident = &Identity::singleton('none', $owner);
$ident->setDefault($ident->getDefault());
$tmp_name = $ident->getValue('fullname');
if (!empty($tmp_name)) {
    $owner = $tmp_name;
}

require KRONOLITH_TEMPLATES . '/view/view.inc';
require $registry->get('templates', 'horde') . '/common-footer.inc';
