<!-- javascript action handling -->
<script language="JavaScript" type="text/javascript">
<!--
    function performAction(id, value)
    {
        document.attendeesForm.actionID.value = id;
        document.attendeesForm.actionValue.value = value;
        document.attendeesForm.submit();
        return false;
    }

    function switchTimestamp(timestamp)
    {
        document.attendeesForm.timestamp.value = timestamp;
        document.attendeesForm.submit();
        return false;
    }

    function switchView(view)
    {
        document.attendeesForm.view.value = view;
        document.attendeesForm.submit();
        return false;
    }
// -->
</script>

<form method="post" action="<?php echo $form_handler; ?>" name="attendeesForm">
<?php Util::pformInput(); ?>
<input type="hidden" name="actionID" value="" />
<input type="hidden" name="actionValue" value="" />
<input type="hidden" name="view" value="<?php echo $view ?>" />
<input type="hidden" name="timestamp" value="<?php echo $timestamp ?>" />

<?php $notification->notify(array('status')); ?>

<table border="0" width="100%" cellspacing="0" cellpadding="2">

<!-- header -->
<tr><td colspan="4" class="header"><b><?php echo $title ?></b></td></tr>

<!-- attendee list header -->
<tr class="item">
 <td nowrap="nowrap" width="2%" align="center"><?php echo $delimg ?></td>
 <td nowrap="nowrap" width="48%"><b><?php echo htmlspecialchars(_("Email Address")) ?></b></td>
 <td nowrap="nowrap" width="25%"><b><?php echo htmlspecialchars(_("Attendance")) ?></b></td>
 <td nowrap="nowrap" width="25%"><b><?php echo htmlspecialchars(_("Response")) ?></b></td>
</tr>

<!-- attendees -->
<?php $i = 0 ?>
<?php if (empty($attendees)): ?>
 <tr class="item<?php echo ($i++ % 2) ?>"><td align="center" colspan="4"><i><?php echo htmlspecialchars('-- ' . _("No attendees") . ' --') ?></i></td></tr>
<?php else: foreach ($attendees as $email => $status): ?>
 <tr class="item<?php echo ($i++ % 2) ?>">
 <?php
  $statustext = sprintf(_("Remove %s"), $email);
  echo "<td>", Horde::link("javascript:performAction('remove', '" . addslashes($email) . "')", $statustext), Horde::img('delete-small.png', $statustext, null, $registry->getImageDir('horde')), "</a></td>";
 ?>
  <td><?php echo Horde::link($registry->call('mail/compose', array(array('to' => addslashes($email)))), sprintf(_("Send an email to %s"), $email)), htmlspecialchars($email) . '</a>'; ?></td>
  <td>
   <?php $selname = "attendance_$i"; ?>
   <select name="<?php echo $selname; ?>" onchange="performAction('changeatt', document.attendeesForm.$selname.value + ' ", addslashes($email), "'" ?>);" >
    <option value="<?php echo KRONOLITH_PART_REQUIRED, '"', ($status['attendance'] == KRONOLITH_PART_REQUIRED ? ' selected' : ''), ">", Kronolith::partToString(KRONOLITH_PART_REQUIRED); ?></option>
    <option value="<?php echo KRONOLITH_PART_OPTIONAL, '"', ($status['attendance'] == KRONOLITH_PART_OPTIONAL ? ' selected' : ''), ">", Kronolith::partToString(KRONOLITH_PART_OPTIONAL); ?></option>
    <option value="<?php echo KRONOLITH_PART_NONE, '"', ($status['attendance'] == KRONOLITH_PART_NONE ? ' selected' : ''), ">", Kronolith::partToString(KRONOLITH_PART_NONE); ?></option>
   </select>
  </td>
  <td><?php echo Kronolith::responseToString($status['response']) ?></td>
 </tr>
<?php endforeach; ?>
<tr class="item<?php echo ($i++ % 2) ?>"><td align="right" colspan="4">
<input type="submit" class="button" name="clearAll" value="<?php echo htmlspecialchars(_("Clear all attandees")) ?>" />
</td></tr>
<?php endif; ?>

</table>

<br />

<table border="0" width="100%" cellspacing="0" cellpadding="2">
<tr><td align="right" class="light" nowrap="nowrap"><b><?php echo Horde::highlightAccessKey(_("Add attendees"), $ak = Horde::getAccessKey(_("Add attendees"))) ?>&nbsp;&nbsp;</b></td>
<td align="left" class="item0" colspan="2"><input type="text" name="newAttendees" size="50" maxlength="255" <?php echo (!empty($ak)) ? 'accesskey="' . $ak . '" ' : '' ?>/></td></tr>
<tr><td>&nbsp;</td><td align="left" class="item1">
<?php if ($registry->hasMethod('contacts/search')): ?>
 <input type="button" class="button" name="contacts" value="<?php echo htmlspecialchars(_("Add people from my Address Book")) ?>" onclick="window.open('<?php echo Horde::applicationUrl('contacts.php') ?>', 'contacts', 'toolbar=no,location=no,status=yes,scrollbars=yes,resizable=yes,width=650,height=350,left=100,top=100'); return false;" />
<?php else: ?>
 &nbsp;
<?php endif; ?>
</td><td align="right" class="item1"><input type="submit" class="button" name="addNew" value="<?php echo htmlspecialchars(_("Add these people")) ?>" /></td></tr>
</table>

<br />

<?php echo $tabs->render($view) . $vfb_html ?>
<?php if (!empty($legend_html)): ?>
<div style="padding-left:10px; padding-right:10px; padding-top:10px">
 <?php echo $legend_html ?><br/>
</div>
<?php endif; ?>

<table border="0" width="100%" cellspacing="0" cellpadding="2"><tr>
<td align="right"><input type="button" class="button" value="<?php echo htmlspecialchars(_("Dismiss")) ?>" onclick="performAction('dismiss', '')" /></td>
</tr></table>

</form>
