<?php
/**
 * $Horde: kronolith/search.php,v 1.8 2004/12/05 20:49:33 chuck Exp $
 *
 * Copyright 2004-2004 Meilof Veeningen <meilof@wanadoo.nl>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

$title = _("Search");
Horde::addScriptFile('tooltip.js', 'horde', true);
require KRONOLITH_TEMPLATES . '/common-header.inc';
require KRONOLITH_TEMPLATES . '/menu.inc';

/* Get search parameters. */
if (Util::getFormData('search_mode')) {
    $_SESSION['kronolith_search_mode'] = Util::getFormData('search_mode');
}
if (!isset($_SESSION['kronolith_search_mode'])) {
    $_SESSION['kronolith_search_mode'] = 'basic';
}

if ($_SESSION['kronolith_search_mode'] == 'basic') {
    require KRONOLITH_TEMPLATES . '/search/search.inc';
    $notification->push('document.event.pattern_title.focus()', 'javascript');
} else {
    /* Make a new empty event object with default values. */
    $event = &$kronolith->getEvent();
    $event->title = $event->calendars = $event->category = $event->location =
    $event->status = $event->description = null;

    /* Set start on today, stop on tomorrow. */
    $event->start = &new Horde_Date(mktime(0, 0, 0));
    $event->end = &new Horde_Date(mktime(0, 0, 0, date('n'), date('j') + 1));

    /* We need to set the event to initialized, otherwise we will end
     * up with a default end date. */
    $event->initialized = true;

    $q_title = Util::getFormData('title');

    if (isset($q_title)) {
        /* We're returning from a previous search. */
        $event->readForm();
        if ($event->category == '__any') $event->category = null;
        if (Util::getFormData('status') == KRONOLITH_STATUS_NONE) {
            $event->status = null;
        }
    }
    $notification->push('document.event.title.focus()', 'javascript');
    require KRONOLITH_TEMPLATES . '/search/search_advanced.inc';
}

if (($desc = Util::getFormData('pattern_desc')) ||
    ($title = Util::getFormData('pattern_title'))) {
    /* We're doing a simple search. */
    $event = &$kronolith->getEvent();

    $event->setDescription($desc);
    $event->setTitle($title);
    $event->category = null;
    $event->status = null;

    $time1 = time();
    $range = Util::getFormData('range');
    if ($range == '+') {
        $event->start = &new Horde_Date($time1);
        $event->end = null;
    } elseif ($range == '-') {
        $event->start = null;
        $event->end = &new Horde_Date($time1);
    } else {
        $time2 = $time1 + $range;
        $event->start = &new Horde_Date(min($time1, $time2));
        $event->end = &new Horde_Date(max($time1, $time2));
    }
    $events = Kronolith::search($event);
} elseif (isset($q_title)) {
    /* Advanced search. */
    $events = Kronolith::search($event);
}

/* Display search results. */
if (isset($events)) {
    if (count($events)) {
        require KRONOLITH_TEMPLATES . '/search/header.inc';
        require KRONOLITH_TEMPLATES . '/search/event_headers.inc';

        foreach ($events as $event) {
            require KRONOLITH_TEMPLATES . '/search/event_summaries.inc';
        }
        require KRONOLITH_TEMPLATES . '/search/event_footers.inc';
    } else {
        require KRONOLITH_TEMPLATES . '/search/empty.inc';
    }
}

require $registry->get('templates', 'horde') . '/common-footer.inc';
