<?php
/*
 * $Horde: kronolith/week.php,v 1.10 2001/11/10 10:47:45 jan Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';
require_once KRONOLITH_BASE . '/lib/WeekView.php';

$week = Horde::getFormData('week');
$year = Horde::getFormData('year');
if ($timestamp = Horde::getFormData('timestamp')) {
    $year = date('Y', $timestamp);
    $week = Kronolith::weekOfYear(date('d', $timestamp), date('m', $timestamp), $year);
}

if ($prefs->getValue('week_start_monday')) {
    $weekOb = new Kronolith_WeekView($week, $year);
} else {
    $weekOb = new Kronolith_WeekView($week, $year, -1, 5);
}
$title = sprintf(_("Week %d"), $weekOb->week);

if ($conf['compress_pages']) {
    include_once 'HTTP/Compress.php';
    HTTP_Compress::start();
}

require $registry->getTemplatePath() . '/common-header.inc';
require './menu.php';

$weekOb->html($registry->getTemplatePath());

require $registry->getTemplatePath() . '/common-footer.inc';

if ($conf['compress_pages']) {
    HTTP_Compress::output();
}

?>
