<?php // $Horde: kronolith/templates/menu/goto.inc,v 1.1 2001/11/21 17:44:35 jan Exp $ ?>
<script language="JavaScript" type="text/javascript">

var currentDate, currentYear;

function weekOfYear(d)
{
    var year = d.getYear()
    if (year < 1900) {
        year += 1900;
    }
    var firstday = new Date(year, 0, 1);
    var firstwday = 8 - firstday.getDay();
    if (firstwday == 8) {
        firstwday = 1;
    } else if (firstwday > 4) {
        firstwday -= 7;
    }
    
    var dayofyear = (d - firstday.getTime() + 86400000) / 86400000;
    if (dayofyear < firstwday) {
        return weekOfYear(new Date(year - 1, 12, 31));
    } else {
        return Math.floor((dayofyear - firstwday) / 7) + 1;
    }
}
        
function openGoto(timestamp)
{
    var row, cell, img, link, days;
    
    var d = new Date(timestamp * 1000);
    currentDate = d;
    var month = d.getMonth();
    var year = d.getYear();
    if (year < 1900) {
        year += 1900;
    }
    currentYear = year;
    var firstOfMonth = new Date(year, month, 1);
    var diff = firstOfMonth.getDay() - 1;
    if (diff == -1) diff = 6;
    switch (month) {
        case 3:
        case 5:
        case 8:
        case 10:
            days = 30;
            break;
        case 1:
            if (year % 4 == 0 && (year % 100 != 0 || year % 400 == 0)) {
                days = 29;
            } else {
                days = 28;
            }
            break;
        default:
            days = 31;
            break;
    }

    var wdays = [
        '<?= _("Mo") ?>',
        '<?= _("Tu") ?>',
        '<?= _("We") ?>',
        '<?= _("Th") ?>',
        '<?= _("Fr") ?>',
        '<?= _("Sa") ?>',
        '<?= _("Su") ?>'
    ];
    var months = [
        '<?= _("January") ?>',
        '<?= _("February") ?>',
        '<?= _("March") ?>',
        '<?= _("April") ?>',
        '<?= _("May") ?>',
        '<?= _("June") ?>',
        '<?= _("July") ?>',
        '<?= _("August") ?>',
        '<?= _("September") ?>',
        '<?= _("October") ?>',
        '<?= _("November") ?>',
        '<?= _("December") ?>'
    ];
    
    var lay = document.getElementById('goto');
    if (lay.firstChild) {
        lay.removeChild(lay.firstChild);
    }
    
    var table = document.createElement('TABLE');
    var tbody = document.createElement('TBODY');
    table.appendChild(tbody);
    //table.className = 'control';
    table.cellSpacing = 1;
    
    // title bar
    row = document.createElement('TR');
    cell = document.createElement('TD');
    cell.colSpan = 8;
    cell.align = 'right';
    cell.className = 'menu';
    link = document.createElement('A');
    link.href = '#';
    link.onclick = function() {
        document.getElementById('goto').style.visibility = 'hidden';
        return false;
    }
    link.className = 'menuitem';
    var x = document.createTextNode('x');
    link.appendChild(x);
    cell.appendChild(link);
    row.appendChild(cell);
    tbody.appendChild(row);
    
    // year
    row = document.createElement('TR');
    cell = document.createElement('TD');
    cell.colSpan = 8;
    cell.align = 'center';
    link = document.createElement('A');
    link.href = '#';
    link.onclick = function() {
        newDate = new Date(currentYear - 1, currentDate.getMonth(), currentDate.getDate());
        openGoto(newDate.getTime() / 1000);
    }
    cell.appendChild(link);
    img = document.createElement('IMG')
    img.src = '<?= $registry->getGraphicsPath() ?>/prev.gif';
    img.align = 'middle';
    img.border = 0;
    link.appendChild(img);
    var y = document.createTextNode(year);
    cell.appendChild(y);
    link = document.createElement('A');
    link.href = '#';
    link.onclick = function() {
        newDate = new Date(currentYear + 1, currentDate.getMonth(), currentDate.getDate());
        openGoto(newDate.getTime() / 1000);
    }
    cell.appendChild(link);
    img = document.createElement('IMG')
    img.src = '<?= $registry->getGraphicsPath() ?>/next.gif';
    img.align = 'middle';
    img.border = 0;
    link.appendChild(img);
    row.appendChild(cell);
    tbody.appendChild(row);
    
    // month name
    row = document.createElement('TR');
    cell = document.createElement('TD');
    cell.colSpan = 8;
    cell.align = 'center';
    link = document.createElement('A');
    link.href = '#';
    link.onclick = function() {
        newDate = new Date(currentYear, currentDate.getMonth() - 1, currentDate.getDate());
        openGoto(newDate.getTime() / 1000);
    }
    cell.appendChild(link);
    img = document.createElement('IMG')
    img.src = '<?= $registry->getGraphicsPath() ?>/prev.gif';
    img.align = 'middle';
    img.border = 0;
    link.appendChild(img);
    link = document.createElement('A');
    link.href = '<?= Horde::applicationUrl('month.php') ?>';
    if (link.href.indexOf('?') != -1) {
        link.href += '&year=' + year + '&month=' + (month + 1);
    } else {
        link.href += '?year=' + year + '&month=' + (month + 1);
    }
    cell.appendChild(link);
    var m = document.createTextNode(months[month]);
    link.appendChild(m);
    link = document.createElement('A');
    link.href = '#';
    link.onclick = function() {
        newDate = new Date(currentYear, currentDate.getMonth() + 1, currentDate.getDate());
        openGoto(newDate.getTime() / 1000);
    }
    cell.appendChild(link);
    img = document.createElement('IMG')
    img.src = '<?= $registry->getGraphicsPath() ?>/next.gif';
    img.align = 'middle';
    img.border = 0;
    link.appendChild(img);
    row.appendChild(cell);
    tbody.appendChild(row);
    
    // weekdays
    row = document.createElement('TR');
    cell = document.createElement('TD');
    row.appendChild(cell);
    for (var i = 0; i < 7; i++) {
        cell = document.createElement('TD');
        weekday = document.createTextNode(wdays[i]);
        cell.appendChild(weekday);
        row.appendChild(cell);
    }
    tbody.appendChild(row);
    
    // rows
    var week, italic;
    var count = 1;
    var today = new Date();
    var odd = true;
    for (var i = 1; i <= days; i++) {
        if (count == 1) {
            row = document.createElement('TR');
            row.align = 'right';
            if (odd) {
                row.className = 'item0';
            } else {
                row.className = 'item1';
            }
            odd = !odd;
            cell = document.createElement('TD');
            week = weekOfYear(new Date(year, month, i));
            italic = document.createElement('I');
            cell.appendChild(italic);
            link = document.createElement('A');
            link.href = '<?= Horde::applicationUrl('week.php') ?>';
            if (link.href.indexOf('?') != -1) {
                link.href += '&year=' + year + '&week=' + week;
            } else {
                link.href += '?year=' + year + '&week=' + week;
            }
            italic.appendChild(link);
            link.appendChild(document.createTextNode(week));
            row.appendChild(cell);
        }
        if (i == 1) {
            for (var j = 0; j < diff; j++) {
                cell = document.createElement('TD');
                row.appendChild(cell);
                count++;
            }
        }
        cell = document.createElement('TD');
        if (today.getYear() == year &&
            today.getMonth() == month &&
            today.getDate() == i) {
            cell.style.border = '1px solid red';
        }
        link = document.createElement('A');
        link.href = '<?= Horde::applicationUrl('day.php') ?>';
        if (link.href.indexOf('?') != -1) {
            link.href += '&year=';
        } else {
            link.href += '?year=';
        }
        link.href += year + '&month=' + (month + 1) + '&mday=' + i;
        cell.appendChild(link);
        day = document.createTextNode(i);
        link.appendChild(day);
        row.appendChild(cell);
        if (count == 7) {
            tbody.appendChild(row);
            count = 0;
        }
        count++;
    }
    if (count > 1) {
        for (i = count; i <= 7; i++) {
            cell = document.createElement('TD');
            row.appendChild(cell);
        }
        tbody.appendChild(row);
    }
    
    // show Layer
    lay.appendChild(table);
    lay.style.visibility = 'visible';
}

</script>

<div id="goto" class="control" style="position:absolute;visibility:hidden;left:50px;top:50px;padding:1px"></div>
