<?php
/*
 * $Horde: kronolith/status.php,v 1.10 2001/10/28 13:17:34 jan Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999, 2000 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */


// get any alarms in the next hour
$now = mktime();
$current_date = Kronolith::timestampToObject($now);
$events = $calendar->listAlarms($current_date);
$messages = array();
foreach ($events as $eventID) {
	$thisEvent = $calendar->getEventObject($eventID);
    $differential = $thisEvent->getStartTimestamp($now) - $now;
    $key = $thisEvent->getStartTimestamp();
    while (isset($messages[$key])) $key++;
    if ($differential >= -60 && $differential < 60) {
        $messages[$key] = array(sprintf(_("%s is starting now."), $thisEvent->getTitle()), KRONOLITH_ALARM);
    } else if ($differential < 0 && $now <= $thisEvent->getEndTimestamp()) {
        $messages[$key] = array(sprintf(_("%s is in progress."), $thisEvent->getTitle()), KRONOLITH_EVENT);
    } else if ($differential >= 60 && $differential < 7200) {
        $messages[$key] = array(sprintf(_("%s starts in %s"), $thisEvent->getTitle(), Kronolith::secondsToString($differential)), KRONOLITH_ALARM);
    }
}
ksort($messages);
foreach ($messages as $message) {
    Horde::raiseMessage($message[0], $message[1]);
}

if (isset($hordeMessageStack) && is_array($hordeMessageStack)) {
    echo '<table width="100%" border="0" cellpadding="0" cellspacing="0"><tr><td class="item"><table border="0" cellspacing="2" cellpadding="2" width="100%">';
    foreach ($hordeMessageStack as $message) {
        switch ($message['type']) {
        case KRONOLITH_ALARM:
            echo '<tr><td class="control">' . Horde::img('alarm.gif') . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;
            
        case KRONOLITH_EVENT:
            echo '<tr><td class="control">' . Horde::img('event.gif') . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;
            
        case HORDE_ERROR:
            echo '<tr><td class="control">' . Horde::img('alerts/error.gif', 'alt="' . _("Error") . '"', $registry->getGraphicsPath("horde")) . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;
            
        case HORDE_SUCCESS:
            echo '<tr><td class="control">' . Horde::img('alerts/success.gif', 'alt="' . _("Success") . '"', $registry->getGraphicsPath("horde")) . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;
            
        case HORDE_WARNING:
            echo '<tr><td class="control">' . Horde::img('alerts/warning.gif', 'alt="' . _("Warning") . '"', $registry->getGraphicsPath("horde")) . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;
            
        case HORDE_MESSAGE:
        default:
            echo '<tr><td class="control">' . Horde::img('alerts/message.gif', 'alt="' . _("Message") . '"', $registry->getGraphicsPath("horde")) . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;
            
        }
    }
    echo '</table></td></tr></table><br />';
}
?>
